/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.UjoManager;
import org.ujorm.core.UjoManagerXML;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.InitializationBatch;
import org.ujorm.orm.OrmHandlerProvider;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaRoot;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.template.AliasTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmHandler
implements OrmHandlerProvider {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(OrmHandler.class);
    private MetaRoot databases = new MetaRoot();
    private MetaRoot configuration;
    private Session defaultSession;
    private final HashMap<Key, MetaRelation2Many> propertyMap = new HashMap();
    private final HashMap<Class, MetaTable> entityMap = new HashMap();
    private final HashMap<Class, MetaProcedure> procedureMap = new HashMap();

    public OrmHandler() {
    }

    public <UJO extends OrmUjo> OrmHandler(Class<UJO> clazz) {
        this();
        this.loadDatabase(clazz);
    }

    public <UJO extends OrmUjo> OrmHandler(Class<UJO> ... classArray) {
        this();
        this.loadDatabase(classArray);
    }

    public Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.createSession();
        }
        return this.defaultSession;
    }

    public Session getSession() {
        return this.getDefaultSession();
    }

    public Session createSession() {
        return new Session(this);
    }

    public boolean config(String string) throws IllegalArgumentException {
        try {
            if (string.startsWith("~")) {
                String string2 = System.getProperty("user.home") + string.substring(1);
                return this.config(new File(string2).toURI().toURL(), true);
            }
            return this.config(new URL(string), true);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Configuration file is not valid " + string, malformedURLException);
        }
    }

    public void config(MetaParams metaParams) throws IllegalArgumentException {
        MetaRoot.PARAMETERS.setValue((Ujo)this.databases, (Object)metaParams);
    }

    public void config(MetaRoot metaRoot) throws IllegalArgumentException {
        this.configuration = metaRoot;
        MetaParams metaParams = (MetaParams)((Object)MetaRoot.PARAMETERS.of((Ujo)this.configuration));
        if (metaParams != null) {
            this.config(metaParams);
        }
    }

    public boolean config(URL uRL, boolean bl) throws IllegalArgumentException {
        try {
            MetaRoot metaRoot = (MetaRoot)UjoManagerXML.getInstance().parseXML((InputStream)new BufferedInputStream(uRL.openStream()), MetaRoot.class, (Object)this);
            this.config(metaRoot);
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                throw new IllegalArgumentException("Configuration file is not valid ", exception);
            }
            return false;
        }
    }

    public boolean isPersistent(Key key) {
        boolean bl = key.isTypeOf(List.class) || UjoManager.getInstance().isTransient(key);
        return !bl;
    }

    private <UJO extends OrmUjo> MetaDatabase loadDatabaseInternal(Class<UJO> clazz) {
        String string = clazz.getSimpleName();
        MetaDatabase metaDatabase = this.configuration != null ? this.configuration.removeDb(string) : null;
        UJO UJO = this.getInstance(clazz);
        MetaDatabase metaDatabase2 = new MetaDatabase(this, (OrmUjo)UJO, metaDatabase, this.databases.getDatabaseCount());
        this.databases.add(metaDatabase2);
        return metaDatabase2;
    }

    public final <UJO extends OrmUjo> void loadDatabase(Class<UJO> clazz) {
        this.loadDatabase(new Class[]{clazz});
    }

    public final synchronized <UJO extends OrmUjo> void loadDatabase(Class<UJO> ... classArray) {
        block14: {
            File file;
            if (this.isReadOnly()) {
                throw new IllegalArgumentException("The meta-model is locked and can\u00b4t be changed.");
            }
            for (Class<UJO> object2 : classArray) {
                this.loadDatabaseInternal(object2);
            }
            MetaParams metaParams = this.getParameters();
            Object object3 = this.propertyMap.values().iterator();
            while (object3.hasNext()) {
                MetaRelation2Many metaRelation2Many = object3.next();
                if (!metaRelation2Many.isColumn()) continue;
                ((MetaColumn)metaRelation2Many).initTypeCode();
            }
            this.databases.setReadOnly(true);
            Object object = object3 = (Boolean)MetaParams.LOG_METAMODEL_INFO.of(metaParams) != false ? UjoLogger.INFO : UjoLogger.DEBUG;
            if (LOGGER.isLoggable((Level)object3)) {
                String string = "DATABASE META-MODEL:\n" + this.getConfig();
                LOGGER.log((Level)object3, string);
            }
            if ((file = (File)MetaParams.SAVE_CONFIG_TO_FILE.of((Ujo)this.getParameters())) != null) {
                try {
                    this.databases.print(file);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Can't create configuration " + file, iOException);
                }
            }
            for (MetaDatabase metaDatabase : this.getDatabases()) {
                metaDatabase.create(this.getDefaultSession());
            }
            InitializationBatch initializationBatch = metaParams.getInitializationBatch();
            if (initializationBatch != null) {
                Session session;
                Session session2 = null;
                try {
                    session = this.createSession();
                    LOGGER.log(UjoLogger.INFO, "The initializaton batch is running: " + initializationBatch.getClass().getName());
                    initializationBatch.run(session);
                    session.commit();
                    session.close();
                    if (session == null) break block14;
                    session.rollback();
                }
                catch (Exception exception) {
                    try {
                        String string = "The batch failed: " + initializationBatch.getClass().getName();
                        LOGGER.log(UjoLogger.ERROR, string, (Throwable)exception);
                        throw new IllegalStateException(string, exception);
                    }
                    catch (Throwable throwable) {
                        if (session2 != null) {
                            session2.rollback();
                            session2.close();
                        }
                        throw throwable;
                    }
                }
                session.close();
            }
        }
    }

    private <UJO extends OrmUjo> UJO getInstance(Class<UJO> clazz) {
        try {
            return (UJO)((OrmUjo)clazz.newInstance());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't create instance of " + clazz, exception);
        }
    }

    public boolean isReadOnly() {
        List<MetaDatabase> list = this.getDatabases();
        boolean bl = list == null || list.isEmpty() ? false : list.get(0).readOnly();
        return bl;
    }

    public void addProcedureModel(MetaProcedure metaProcedure) {
        this.procedureMap.put(((Key)MetaProcedure.DB_PROPERTY.of((Ujo)metaProcedure)).getType(), metaProcedure);
    }

    public void addTableModel(MetaTable metaTable) {
        this.entityMap.put(metaTable.getType(), metaTable);
    }

    public void addColumnModel(MetaRelation2Many metaRelation2Many) {
        Key key = metaRelation2Many.getKey();
        Object t = this.findColumnModel(key);
        if (t == null) {
            this.propertyMap.put(key, metaRelation2Many);
        } else {
            Class<OrmUjo> clazz = ((MetaRelation2Many)((Object)t)).getTableClass();
            Class<OrmUjo> clazz2 = metaRelation2Many.getTableClass();
            if (clazz2.isAssignableFrom(clazz)) {
                this.propertyMap.put(key, metaRelation2Many);
            }
        }
    }

    public <T extends Annotation> T findAnnotation(Key<?, ?> key, Class<T> clazz) {
        if (key.isComposite()) {
            key = ((CompositeKey)key).getFirstKey();
        }
        try {
            for (Field field : ((MetaRelation2Many)((Object)this.findColumnModel(key, true))).getTableClass().getFields()) {
                if (field.getModifiers() != 25 || field.get(null) != key) continue;
                return field.getAnnotation(clazz);
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Illegal state for: " + key, throwable);
        }
        return null;
    }

    public final <T extends MetaRelation2Many> T findColumnModel(Key key) {
        return this.findColumnModel(key, false);
    }

    public <T extends MetaRelation2Many> T findColumnModel(Key key, boolean bl) throws IllegalArgumentException {
        if (key != null && key.isComposite()) {
            key = ((CompositeKey)key).getLastKey();
        }
        MetaRelation2Many metaRelation2Many = this.propertyMap.get(key);
        if (bl && metaRelation2Many == null) {
            String string = key != null ? key.toStringFull() : String.valueOf(key);
            throw new IllegalArgumentException("The key " + string + " have got no meta-model.");
        }
        return (T)((Object)metaRelation2Many);
    }

    public MetaTable findTableModel(Class<? extends OrmUjo> clazz) throws IllegalStateException {
        MetaTable metaTable = this.entityMap.get(clazz);
        if (metaTable == null) {
            String string = "An entity mapping bug: the " + clazz + " is not mapped to the Database.";
            throw new IllegalStateException(string);
        }
        return metaTable;
    }

    public MetaProcedure findProcedureModel(Class<? extends DbProcedure> clazz) throws IllegalStateException {
        MetaProcedure metaProcedure = this.procedureMap.get(clazz);
        if (metaProcedure == null) {
            String string = "An procedure mapping bug: the " + clazz + " is not mapped to the Database.";
            throw new IllegalStateException(string);
        }
        return metaProcedure;
    }

    public MetaParams getParameters() {
        return (MetaParams)((Object)MetaRoot.PARAMETERS.of((Ujo)this.databases));
    }

    public boolean isDatabaseLoaded() {
        int n = MetaRoot.DATABASES.getItemCount((Ujo)this.databases);
        return n > 0;
    }

    public List<MetaDatabase> getDatabases() {
        return (List)MetaRoot.DATABASES.of((Ujo)this.databases);
    }

    public List<Key> findPropertiesByType(Class clazz) {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        for (Key key : this.propertyMap.keySet()) {
            if (!key.isTypeOf(clazz)) continue;
            arrayList.add(key);
        }
        return arrayList;
    }

    public String getConfig() {
        return this.databases.toString();
    }

    @Override
    public OrmHandler getOrmHandler() {
        return this;
    }

    public <UJO extends OrmUjo> AliasTable<UJO> alias(Class<UJO> clazz, String string) {
        return AliasTable.of(clazz, string, this);
    }
}

