/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.util.List;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirebirdDialect
extends SqlDialect {
    @Override
    public String getJdbcDriver() {
        return "org.firebirdsql.jdbc.FBDriver";
    }

    @Override
    public String getJdbcUrl() {
        return "jdbc:firebirdsql:localhost/3050:DbFile?lc_ctype=UTF8";
    }

    @Override
    public Appendable printCreateSchema(String string, Appendable appendable) throws IOException {
        return appendable;
    }

    @Override
    protected Appendable printLockForSelect(Query query, Appendable appendable) throws IOException, UnsupportedOperationException {
        appendable.append("FOR UPDATE WITH LOCK");
        return appendable;
    }

    @Override
    public Appendable printAlterTableAddColumn(MetaColumn metaColumn, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaColumn.getTable(), appendable);
        appendable.append(" ADD ");
        if (metaColumn.isForeignKey()) {
            this.printFKColumnsDeclaration(metaColumn, appendable);
        } else {
            this.printColumnDeclaration(metaColumn, null, appendable);
        }
        if (metaColumn.hasDefaultValue()) {
            int n;
            if (metaColumn.isMandatory() && (n = appendable.toString().indexOf(" NOT NULL")) >= 0 && appendable instanceof StringBuilder) {
                ((StringBuilder)appendable).delete(n, n + " NOT NULL".length());
            }
            this.printDefaultValue(metaColumn, appendable);
            if (metaColumn.isMandatory()) {
                appendable.append(" NOT NULL");
            }
        }
        return appendable;
    }

    @Override
    public boolean isMultiRowInsertSupported() {
        return false;
    }

    @Override
    public Appendable printInsert(List<? extends OrmUjo> list, int n, int n2, Appendable appendable) throws IOException {
        return this.printInsertBySelect(list, n, n2, "FROM RDB$DATABASE", appendable);
    }

    @Override
    protected Appendable printQuotedNameAlways(CharSequence charSequence, Appendable appendable) throws IOException {
        appendable.append(charSequence);
        return appendable;
    }
}

