/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ujorm.Ujo;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.SqlDialectEx;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.ao.CheckReport;
import org.ujorm.orm.ao.CommentPolicy;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.utility.OrmTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDbService {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(MetaDbService.class);
    protected MetaDatabase db;
    protected final StringBuilder sql = new StringBuilder(256);
    protected Statement stat = null;
    protected boolean anyChange = false;

    public void create(MetaDatabase metaDatabase, Session session) {
        this.db = metaDatabase;
        Connection connection = session.getConnection(this.db, true);
        ArrayList<MetaTable> arrayList = new ArrayList<MetaTable>();
        ArrayList<MetaColumn> arrayList2 = new ArrayList<MetaColumn>();
        ArrayList<MetaColumn> arrayList3 = new ArrayList<MetaColumn>();
        ArrayList<MetaIndex> arrayList4 = new ArrayList<MetaIndex>();
        int n = this.db.getTableTotalCount();
        try {
            boolean bl = this.initialize(connection);
            boolean bl2 = false;
            switch ((Orm2ddlPolicy)((Object)MetaDatabase.ORM2DLL_POLICY.of((Ujo)this.db))) {
                case CREATE_DDL: {
                    bl2 = true;
                }
                case CREATE_OR_UPDATE_DDL: 
                case VALIDATE: 
                case WARNING: 
                case INHERITED: {
                    boolean bl3 = this.isModelChanged(connection, arrayList, arrayList2, arrayList4);
                    if (!bl3 || !bl2 || arrayList.size() >= n) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.checkReportKeywords(connection, arrayList, arrayList2, arrayList4);
            this.createSchema(n, arrayList, connection);
            this.createTable(arrayList, arrayList3);
            this.createNewColumn(arrayList2, arrayList3);
            this.changeIndex(arrayList4);
            this.createForeignKey(arrayList3);
            this.createSequenceTable(bl);
            this.createTableComments(arrayList);
            connection.commit();
        }
        catch (Throwable throwable) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                LOGGER.log(UjoLogger.WARN, "Can't rollback DB" + this.db.getId(), (Throwable)sQLException);
            }
            throw new IllegalArgumentException("ILLEGAL SQL: " + this.getSql(), throwable);
        }
    }

    public StringBuilder getSql() {
        return this.sql;
    }

    protected boolean isModelChanged(Connection connection, List<MetaTable> list, List<MetaColumn> list2, List<MetaIndex> list3) throws SQLException {
        list.clear();
        list2.clear();
        list3.clear();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        boolean bl = this.isCatalog();
        String string = null;
        for (MetaTable metaTable : (List)MetaDatabase.TABLES.of((Ujo)this.db)) {
            boolean bl2;
            boolean bl3;
            if (!metaTable.isTable()) continue;
            HashSet<String> hashSet = new HashSet<String>(32);
            String string2 = this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)metaTable), databaseMetaData);
            ResultSet resultSet = databaseMetaData.getColumns(bl ? string2 : null, bl ? null : string2, this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData), string);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("COLUMN_NAME").toUpperCase());
            }
            resultSet.close();
            boolean bl4 = bl3 = hashSet.size() > 0;
            if (bl3) {
                for (MetaColumn metaColumn : (List)MetaTable.COLUMNS.of((Ujo)metaTable)) {
                    bl2 = hashSet.contains(metaColumn.getName().toUpperCase());
                    if (bl2) continue;
                    LOGGER.log(UjoLogger.INFO, "New DB column: " + metaColumn.getFullName());
                    list2.add(metaColumn);
                }
            } else {
                LOGGER.log(UjoLogger.INFO, "New DB table: " + (String)MetaTable.NAME.of((Ujo)metaTable));
                list.add(metaTable);
            }
            hashSet.clear();
            if (bl3) {
                resultSet = databaseMetaData.getIndexInfo(bl ? string2 : null, bl ? null : string2, this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData), false, false);
                while (resultSet.next()) {
                    String string3 = resultSet.getString("INDEX_NAME");
                    if (string3 == null) continue;
                    hashSet.add(string3.toUpperCase());
                }
                resultSet.close();
            }
            for (MetaIndex metaIndex : metaTable.getIndexCollection()) {
                bl2 = hashSet.contains(((String)MetaIndex.NAME.of((Ujo)metaIndex)).toUpperCase());
                if (bl2) continue;
                LOGGER.log(UjoLogger.INFO, "New DB index: " + (Object)((Object)metaIndex));
                list3.add(metaIndex);
            }
        }
        boolean bl5 = !list.isEmpty() || !list2.isEmpty() || !list3.isEmpty();
        return bl5;
    }

    protected String dbIdentifier(String string, DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData.storesUpperCaseIdentifiers()) {
            return string.toUpperCase();
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            return string.toLowerCase();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initialize(Connection connection) throws Exception {
        this.stat = connection.createStatement();
        boolean bl = false;
        if (this.db.isSequenceTableRequired()) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            Throwable throwable = null;
            String string = "";
            try {
                this.db.getDialect().printSequenceCurrentValue(this.findFirstSequencer(), this.sql);
                preparedStatement = connection.prepareStatement(this.sql.toString());
                preparedStatement.setString(1, "-");
                resultSet = preparedStatement.executeQuery();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (throwable != null) {
                switch ((Orm2ddlPolicy)((Object)MetaDatabase.ORM2DLL_POLICY.of((Ujo)this.db))) {
                    case VALIDATE: 
                    case WARNING: {
                        throw new IllegalStateException(string, throwable);
                    }
                    case CREATE_DDL: 
                    case CREATE_OR_UPDATE_DDL: 
                    case INHERITED: {
                        bl = true;
                    }
                }
            }
            if (LOGGER.isLoggable(UjoLogger.INFO)) {
                string = "Table ''{0}'' {1} available on the database ''{2}''.";
                string = MessageFormat.format(string, this.db.getDialect().getSeqTableModel().getTableName(), throwable != null ? "is not" : "is", this.db.getId());
                LOGGER.log(UjoLogger.INFO, string);
            }
            try {
                if (throwable != null) {
                    connection.rollback();
                }
            }
            finally {
                MetaDatabase.close(null, preparedStatement, resultSet, false);
            }
        }
        return bl;
    }

    protected void checkReportKeywords(Connection connection, List<MetaTable> list, List<MetaColumn> list2, List<MetaIndex> list3) throws Exception {
        switch ((CheckReport)((Object)MetaParams.CHECK_KEYWORDS.of((Ujo)this.db.getParams()))) {
            case WARNING: 
            case EXCEPTION: {
                Set<String> set = this.db.getDialect().getKeywordSet(connection);
                for (MetaTable abstractMetaModel : list) {
                    if (!abstractMetaModel.isTable()) continue;
                    this.checkKeyWord((String)MetaTable.NAME.of((Ujo)abstractMetaModel), abstractMetaModel, set);
                    for (MetaColumn metaColumn : (List)MetaTable.COLUMNS.of((Ujo)abstractMetaModel)) {
                        this.checkKeyWord(metaColumn.getName(), abstractMetaModel, set);
                    }
                }
                for (MetaColumn metaColumn : list2) {
                    this.checkKeyWord((String)MetaColumn.NAME.of((Ujo)metaColumn), metaColumn.getTable(), set);
                }
                for (MetaIndex metaIndex : list3) {
                    this.checkKeyWord((String)MetaIndex.NAME.of((Ujo)metaIndex), (MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex), set);
                }
                break;
            }
        }
    }

    protected void createSchema(int n, List<MetaTable> list, Connection connection) throws SQLException, IOException {
        if (n == list.size()) {
            for (String string : this.db.getSchemas(list)) {
                this.sql.setLength(0);
                this.db.getDialect().printCreateSchema(string, this.sql);
                if (!OrmTools.isFilled(this.sql)) continue;
                try {
                    this.stat.executeUpdate(this.sql.toString());
                }
                catch (SQLException sQLException) {
                    LOGGER.log(UjoLogger.INFO, "{0}: {1}; {2}", new Object[]{sQLException.getClass().getName(), this.sql.toString(), sQLException.getMessage()});
                    connection.rollback();
                }
            }
        }
    }

    protected void createTable(List<MetaTable> list, List<MetaColumn> list2) throws Exception {
        for (MetaTable metaTable : list) {
            if (!metaTable.isTable()) continue;
            this.sql.setLength(0);
            this.db.getDialect().printTable(metaTable, this.sql);
            this.executeUpdate(this.sql, metaTable);
            list2.addAll(metaTable.getForeignColumns());
            this.anyChange = true;
        }
    }

    protected void createNewColumn(List<MetaColumn> list, List<MetaColumn> list2) throws Exception {
        for (MetaColumn metaColumn : list) {
            this.sql.setLength(0);
            this.db.getDialect().printAlterTableAddColumn(metaColumn, this.sql);
            this.executeUpdate(this.sql, metaColumn.getTable());
            this.anyChange = true;
            if (!metaColumn.isForeignKey()) continue;
            list2.add(metaColumn);
        }
    }

    protected void changeIndex(List<MetaIndex> list) throws Exception {
        for (MetaIndex metaIndex : list) {
            this.sql.setLength(0);
            this.db.getDialect().printIndex(metaIndex, this.sql);
            this.executeUpdate(this.sql, (MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex));
            this.anyChange = true;
        }
    }

    protected void createForeignKey(List<MetaColumn> list) throws Exception {
        for (MetaColumn metaColumn : list) {
            if (!metaColumn.isForeignKey()) continue;
            this.sql.setLength(0);
            this.db.getDialect().printForeignKey(metaColumn, this.sql);
            this.executeUpdate(this.sql, metaColumn.getTable());
            this.anyChange = true;
        }
    }

    protected void createSequenceTable(boolean bl) throws Exception {
        if (bl) {
            this.sql.setLength(0);
            this.db.getDialect().printSequenceTable(this.db, this.sql);
            MetaTable metaTable = new MetaTable();
            MetaTable.ORM2DLL_POLICY.setValue((Ujo)metaTable, MetaParams.ORM2DLL_POLICY.getDefault());
            this.executeUpdate(this.sql, metaTable);
        }
    }

    protected void createTableComments(List<MetaTable> list) throws Exception {
        List<MetaTable> list2;
        switch ((CommentPolicy)((Object)MetaParams.COMMENT_POLICY.of((Ujo)this.db.getParams()))) {
            case FOR_NEW_OBJECT: {
                list2 = list;
                break;
            }
            case ALWAYS: {
                list2 = MetaDatabase.TABLES.getList((Ujo)this.db);
                break;
            }
            case ON_ANY_CHANGE: {
                list2 = this.isAnyChange() ? MetaDatabase.TABLES.getList((Ujo)this.db) : Collections.emptyList();
                break;
            }
            case NEVER: {
                list2 = Collections.emptyList();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported parameter");
            }
        }
        if (!list2.isEmpty()) {
            this.createTableComments(list2, this.sql);
        }
    }

    protected void createTableComments(List<MetaTable> list, StringBuilder stringBuilder) {
        try {
            for (MetaTable metaTable : list) {
                switch ((Orm2ddlPolicy)((Object)MetaTable.ORM2DLL_POLICY.of((Ujo)metaTable))) {
                    case CREATE_DDL: 
                    case CREATE_OR_UPDATE_DDL: {
                        if (!metaTable.isTable()) break;
                        if (metaTable.isCommented()) {
                            stringBuilder.setLength(0);
                            Appendable appendable = this.db.getDialect().printComment(metaTable, (Appendable)stringBuilder);
                            if (appendable.toString().length() > 0) {
                                this.executeUpdate(appendable, metaTable);
                            }
                        }
                        for (MetaColumn metaColumn : (List)MetaTable.COLUMNS.of((Ujo)metaTable)) {
                            if (!metaColumn.isCommented()) continue;
                            stringBuilder.setLength(0);
                            Appendable appendable = this.db.getDialect().printComment(metaColumn, (Appendable)stringBuilder);
                            if (appendable.toString().length() <= 0) continue;
                            this.executeUpdate(appendable, metaTable);
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(UjoLogger.ERROR, "Error on table comment: {0}", new Object[]{stringBuilder});
        }
    }

    protected void checkKeyWord(String string, MetaTable metaTable, Set<String> set) throws Exception {
        if (set.contains(string.toUpperCase())) {
            String string2 = "The database table or column called '" + string + "' is a SQL keyword. See the class: " + metaTable.getType().getName() + ".\nNOTE: the keyword checking can be disabled by the Ujorm parameter: " + MetaParams.CHECK_KEYWORDS.toStringFull();
            switch ((CheckReport)((Object)MetaParams.CHECK_KEYWORDS.of((Ujo)this.db.getParams()))) {
                case EXCEPTION: {
                    throw new IllegalArgumentException(string2);
                }
                case WARNING: {
                    LOGGER.log(UjoLogger.WARN, string2);
                }
            }
        }
    }

    protected void executeUpdate(Appendable appendable, MetaTable metaTable) throws IllegalStateException, SQLException {
        boolean bl = false;
        switch (metaTable.getOrm2ddlPolicy()) {
            case INHERITED: {
                throw new IllegalStateException("An internal error due the DDL policy: " + (Object)((Object)metaTable.getOrm2ddlPolicy()));
            }
            case DO_NOTHING: {
                return;
            }
            case VALIDATE: {
                bl = true;
            }
            case WARNING: {
                String string = "A database validation (caused by the parameter " + MetaTable.ORM2DLL_POLICY + ") have found an inconsistency. " + "There is required a database change: " + appendable;
                if (bl) {
                    throw new IllegalStateException(string);
                }
                LOGGER.log(UjoLogger.WARN, string);
            }
        }
        this.stat.executeUpdate(appendable.toString());
        LOGGER.log(UjoLogger.INFO, appendable.toString());
    }

    protected UjoSequencer findFirstSequencer() {
        for (MetaTable metaTable : (List)MetaDatabase.TABLES.of((Ujo)this.db)) {
            if (!metaTable.isTable()) continue;
            return metaTable.getSequencer();
        }
        return null;
    }

    protected boolean isAnyChange() {
        return this.anyChange;
    }

    protected SqlDialect getDialect() {
        return this.db.getDialect();
    }

    protected SqlDialectEx getDialectEx() {
        return this.db.getDialect().getExtentedDialect();
    }

    protected final boolean isCatalog() {
        return this.getDialect().isCatalog();
    }
}

