/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.criterion.Criterion;
import org.ujorm.criterion.Operator;
import org.ujorm.criterion.TemplateValue;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.AliasKey;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SeqTableModel;
import org.ujorm.orm.SqlDialectEx;
import org.ujorm.orm.SqlNameProvider;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaSelect;
import org.ujorm.orm.metaModel.MetaTable;

public abstract class SqlDialect {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(SqlDialect.class);
    private final SeqTableModel pkTableModel = new SeqTableModel();
    public static final String COMMON_SEQ_TABLE_KEY = "<ALL>";
    public static final String DEFAULT_SCHEMA_SYMBOL = "~";
    protected OrmHandler ormHandler;
    private SqlNameProvider nameProvider;
    private SqlDialectEx extentedDialect;
    private Boolean quoteRequest;

    public void setHandler(OrmHandler ormHandler) {
        if (this.ormHandler != null) {
            throw new IllegalStateException("The OrmHandler is assigned yet.");
        }
        this.ormHandler = ormHandler;
    }

    public abstract String getJdbcUrl();

    public abstract String getJdbcDriver();

    public Connection createConnection(MetaDatabase metaDatabase) throws Exception {
        return metaDatabase.createInternalConnection();
    }

    public InitialContext createJndiInitialContext(MetaDatabase metaDatabase) throws NamingException {
        return new InitialContext();
    }

    public boolean isCatalog() {
        return false;
    }

    public Appendable printCreateSchema(String string, Appendable appendable) throws IOException {
        appendable.append("CREATE SCHEMA IF NOT EXISTS ");
        this.printQuotedName(string, appendable);
        return appendable;
    }

    @Deprecated
    public Appendable printDefaultSchema(String string, Appendable appendable) throws IOException {
        appendable.append("SET SCHEMA ");
        this.printQuotedName(string, appendable);
        return appendable;
    }

    public final Appendable printFullTableName(MetaTable metaTable, Appendable appendable) throws IOException {
        return this.printFullTableName(metaTable, false, appendable);
    }

    public Appendable printFullTableName(MetaTable metaTable, boolean bl, Appendable appendable) throws IOException {
        String string = (String)MetaTable.SCHEMA.of((Ujo)metaTable);
        String string2 = (String)MetaTable.NAME.of((Ujo)metaTable);
        if (this.isFilled(string)) {
            if (bl && metaTable.isDefaultSchema()) {
                appendable.append(DEFAULT_SCHEMA_SYMBOL);
            } else {
                this.printQuotedName(string, appendable);
            }
            appendable.append('.');
        }
        this.printQuotedName(string2, appendable);
        return appendable;
    }

    public void printTableAliasDefinition(TableWrapper tableWrapper, Appendable appendable) throws IOException {
        this.printFullTableName(tableWrapper.getModel(), appendable);
        String string = tableWrapper.getAlias();
        if (this.isFilled(string)) {
            appendable.append(' ');
            this.printQuotedName(string, appendable);
        }
    }

    public Appendable printColumnAlias(ColumnWrapper columnWrapper, Appendable appendable) throws IOException {
        this.printQuotedName(columnWrapper.getTableAlias(), appendable);
        appendable.append('.');
        this.printQuotedName(columnWrapper.getName(), appendable);
        return appendable;
    }

    public Appendable printTable(MetaTable metaTable, Appendable appendable) throws IOException {
        appendable.append("CREATE TABLE ");
        this.printFullTableName(metaTable, appendable);
        String string = "\n\t( ";
        for (MetaColumn metaColumn : MetaTable.COLUMNS.getList((Ujo)metaTable)) {
            appendable.append(string);
            string = "\n\t, ";
            if (metaColumn.isForeignKey()) {
                this.printFKColumnsDeclaration(metaColumn, appendable);
                continue;
            }
            this.printColumnDeclaration(metaColumn, null, appendable);
        }
        appendable.append("\n\t)");
        return appendable;
    }

    public Appendable printAlterTableAddColumn(MetaColumn metaColumn, Appendable appendable) throws IOException {
        return this.printAlterTableColumn(metaColumn, true, appendable);
    }

    public Appendable printAlterTableColumn(MetaColumn metaColumn, boolean bl, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaColumn.getTable(), appendable);
        appendable.append(bl ? " ADD COLUMN " : " ALTER COLUMN ");
        if (metaColumn.isForeignKey()) {
            this.printFKColumnsDeclaration(metaColumn, appendable);
        } else {
            this.printColumnDeclaration(metaColumn, null, appendable);
        }
        if (metaColumn.hasDefaultValue()) {
            this.printDefaultValue(metaColumn, appendable);
        }
        return appendable;
    }

    public Appendable printDefaultValue(MetaColumn metaColumn, Appendable appendable) throws IOException {
        Object object = metaColumn.getJdbcFriendlyDefaultValue();
        boolean bl = object != null;
        String string = "";
        if (object instanceof String) {
            bl = ((String)object).length() > 0;
            string = "'";
        } else if (object instanceof Date) {
            bl = true;
            string = "'";
        }
        if (bl) {
            appendable.append(" DEFAULT ");
            appendable.append(string);
            appendable.append(object.toString());
            appendable.append(string);
        }
        return appendable;
    }

    public Appendable printDefaultConstraint(MetaColumn metaColumn, StringBuilder stringBuilder) throws IOException {
        if (metaColumn.hasDefaultValue()) {
            MetaTable metaTable = metaColumn.getTable();
            stringBuilder.append("ALTER TABLE ");
            this.printFullTableName(metaTable, stringBuilder);
            stringBuilder.append(" ALTER COLUMN ");
            this.printQuotedName(metaColumn.getName(), stringBuilder);
            stringBuilder.append(" SET ");
            this.printDefaultValue(metaColumn, stringBuilder);
        }
        return stringBuilder;
    }

    public Appendable printForeignKey(MetaColumn metaColumn, Appendable appendable) throws IOException {
        MetaTable metaTable = metaColumn.getTable();
        List<MetaColumn> list = metaColumn.getForeignColumns();
        MetaTable metaTable2 = list.get(0).getTable();
        int n = list.size();
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaTable, appendable);
        appendable.append("\n\tADD CONSTRAINT ");
        this.getNameProvider().printConstraintName(metaTable, metaColumn, appendable);
        appendable.append(" FOREIGN KEY ");
        for (int i = 0; i < n; ++i) {
            appendable.append(i == 0 ? "(" : ", ");
            String string = metaColumn.getForeignColumnName(i);
            this.printQuotedName(string, appendable);
        }
        appendable.append(")\n\tREFERENCES ");
        this.printFullTableName(metaTable2, appendable);
        String string = "(";
        for (MetaColumn metaColumn2 : list) {
            appendable.append(string);
            string = ", ";
            this.printQuotedName(metaColumn2.getName(), appendable);
        }
        appendable.append(")");
        return appendable;
    }

    public Appendable printIndex(MetaIndex metaIndex, Appendable appendable) throws IOException {
        appendable.append("CREATE ");
        if (((Boolean)MetaIndex.UNIQUE.of((Ujo)metaIndex)).booleanValue()) {
            appendable.append("UNIQUE ");
        }
        appendable.append("INDEX ");
        appendable.append((CharSequence)MetaIndex.NAME.of((Ujo)metaIndex));
        appendable.append(" ON ");
        this.printFullTableName((MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex), appendable);
        String string = " (";
        for (MetaColumn metaColumn : (List)MetaIndex.COLUMNS.of((Ujo)metaIndex)) {
            appendable.append(string);
            this.printQuotedName(metaColumn.getName(), appendable);
            string = ", ";
        }
        appendable.append(')');
        return appendable;
    }

    protected boolean isColumnLengthAllowed(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case INT: 
            case SMALLINT: 
            case BIGINT: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return false;
            }
        }
        return !MetaColumn.MAX_LENGTH.isDefault((Ujo)metaColumn);
    }

    public Appendable printColumnDeclaration(MetaColumn metaColumn, String string, Appendable appendable) throws IOException {
        String string2 = string != null ? string : metaColumn.getName();
        this.printQuotedName(string2, appendable);
        appendable.append(' ');
        appendable.append(this.getColumnType(metaColumn));
        if (this.isColumnLengthAllowed(metaColumn)) {
            appendable.append("(" + MetaColumn.MAX_LENGTH.of((Ujo)metaColumn));
            if (!MetaColumn.PRECISION.isDefault((Ujo)metaColumn)) {
                appendable.append("," + MetaColumn.PRECISION.of((Ujo)metaColumn));
            }
            appendable.append(")");
        }
        if (((Boolean)MetaColumn.MANDATORY.of((Ujo)metaColumn)).booleanValue() && string == null) {
            appendable.append(" NOT NULL");
        }
        if (((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)metaColumn)).booleanValue() && string == null) {
            appendable.append(" PRIMARY KEY");
        }
        return appendable;
    }

    protected String getColumnType(MetaColumn metaColumn) {
        return ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))).name();
    }

    public Appendable printFKColumnsDeclaration(MetaColumn metaColumn, Appendable appendable) throws IOException {
        List<MetaColumn> list = metaColumn.getForeignColumns();
        for (int i = 0; i < list.size(); ++i) {
            MetaColumn metaColumn2 = list.get(i);
            appendable.append(i == 0 ? "" : "\n\t, ");
            String string = metaColumn.getForeignColumnName(i);
            this.printColumnDeclaration(metaColumn2, string, appendable);
            if (((Boolean)MetaColumn.MANDATORY.of((Ujo)metaColumn)).booleanValue()) {
                appendable.append(" NOT NULL");
            }
            if (!((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)metaColumn)).booleanValue()) continue;
            appendable.append(" PRIMARY KEY");
        }
        return appendable;
    }

    public Appendable printInsert(OrmUjo ormUjo, Appendable appendable) throws IOException {
        MetaTable metaTable = this.ormHandler.findTableModel(ormUjo.getClass());
        StringBuilder stringBuilder = new StringBuilder();
        appendable.append("INSERT INTO ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" (");
        this.printTableColumns(metaTable.getColumns(), stringBuilder, appendable);
        appendable.append(") VALUES (").append(stringBuilder).append(")");
        return appendable;
    }

    public Appendable printInsert(List<? extends OrmUjo> list, int n, int n2, Appendable appendable) throws IOException {
        MetaTable metaTable = this.ormHandler.findTableModel(list.get(n).getClass());
        StringBuilder stringBuilder = new StringBuilder(32);
        appendable.append("INSERT INTO ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" (");
        this.printTableColumns(metaTable.getColumns(), stringBuilder, appendable);
        for (int i = n; i < n2; ++i) {
            appendable.append(i == n ? ") VALUES \n(" : "),\n(").append(stringBuilder);
        }
        appendable.append(")");
        return appendable;
    }

    public Appendable printInsertBySelect(List<? extends OrmUjo> list, int n, int n2, String string, Appendable appendable) throws IOException {
        MetaTable metaTable = this.ormHandler.findTableModel(list.get(n).getClass());
        StringBuilder stringBuilder = new StringBuilder(32);
        appendable.append("INSERT INTO ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" (");
        this.printTableColumns(metaTable.getColumns(), stringBuilder, appendable);
        for (int i = n; i < n2; ++i) {
            appendable.append(i == n ? ")\nSELECT " : " UNION ALL\nSELECT ").append(stringBuilder);
            if (!this.isFilled(string)) continue;
            appendable.append(" ").append(string);
        }
        return appendable;
    }

    public boolean isMultiRowInsertSupported() {
        return true;
    }

    public Appendable printUpdate(List<MetaColumn> list, CriterionDecoder criterionDecoder, Appendable appendable) throws IOException {
        MetaTable metaTable = criterionDecoder.getBaseTable();
        appendable.append("UPDATE ");
        this.printTableAliasDefinition(metaTable, appendable);
        appendable.append("\n\tSET ");
        for (int i = 0; i < list.size(); ++i) {
            MetaColumn metaColumn = list.get(i);
            if (metaColumn.isPrimaryKey()) {
                throw new IllegalStateException("Primary key can not be changed: " + metaColumn);
            }
            appendable.append(i == 0 ? "" : ", ");
            this.printQuotedName(metaColumn.getName(), appendable);
            appendable.append("=?");
        }
        appendable.append("\n\tWHERE ");
        if (criterionDecoder.getTableCount() > 1) {
            this.printQuotedName(metaTable.getFirstPK().getName(), appendable);
            appendable.append(" IN (");
            this.printSelectTableBase(this.createSubQuery(criterionDecoder), false, appendable);
            appendable.append(")");
        } else {
            appendable.append(criterionDecoder.getWhere());
        }
        return appendable;
    }

    public Appendable printDelete(CriterionDecoder criterionDecoder, Appendable appendable) throws IOException {
        MetaTable metaTable = criterionDecoder.getBaseTable();
        appendable.append("DELETE FROM ");
        this.printTableAliasDefinition(metaTable, appendable);
        appendable.append(" WHERE ");
        if (criterionDecoder.getTableCount() > 1) {
            this.printQuotedName(metaTable.getFirstPK().getName(), appendable);
            appendable.append(" IN (");
            this.printSelectTableBase(this.createSubQuery(criterionDecoder), false, appendable);
            appendable.append(")");
        } else {
            appendable.append(criterionDecoder.getWhere());
        }
        return appendable;
    }

    protected Query createSubQuery(CriterionDecoder criterionDecoder) {
        MetaTable metaTable = criterionDecoder.getBaseTable();
        Query query = new Query(metaTable, criterionDecoder.getCriterion());
        query.setDecoder(criterionDecoder);
        query.setColumns(true, new Key[0]);
        return query;
    }

    public String getCriterionTemplate(ValueCriterion valueCriterion) {
        switch (valueCriterion.getOperator()) {
            case EQ: {
                return "{0}={1}";
            }
            case NOT_EQ: {
                return "{0}<>{1}";
            }
            case GT: {
                return "{0}>{1}";
            }
            case GE: {
                return "{0}>={1}";
            }
            case LT: {
                return "{0}<{1}";
            }
            case LE: {
                return "{0}<={1}";
            }
            case EQUALS_CASE_INSENSITIVE: {
                return "UPPER({0})={1}";
            }
            case STARTS_CASE_INSENSITIVE: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "UPPER({0}) LIKE {1}";
            }
            case STARTS: 
            case ENDS: 
            case CONTAINS: {
                return "{0} LIKE {1}";
            }
            case IN: {
                return "{0} IN ({1})";
            }
            case NOT_IN: {
                return "NOT {0} IN ({1})";
            }
            case XFIXED: {
                return valueCriterion.evaluate((Ujo)null) ? "1=1" : "1=0";
            }
            case XSQL: {
                Object object = valueCriterion.getRightNode() instanceof TemplateValue ? ((TemplateValue)valueCriterion.getRightNode()).getTemplate() : valueCriterion.getRightNode();
                return "(" + object + ')';
            }
        }
        throw new UnsupportedOperationException("Unsupported: " + valueCriterion.getOperator());
    }

    public void printTableColumns(Collection<? extends ColumnWrapper> collection, Appendable appendable, Appendable appendable2) throws IOException {
        String string = "";
        boolean bl = appendable == null;
        for (ColumnWrapper columnWrapper : collection) {
            MetaColumn metaColumn = columnWrapper.getModel();
            if (metaColumn.isForeignKey()) {
                for (int i = 0; i < metaColumn.getForeignColumns().size(); ++i) {
                    appendable2.append(string);
                    if (bl) {
                        this.printQuotedName(columnWrapper.getTableAlias(), appendable2);
                        appendable2.append('.');
                    }
                    this.printQuotedName(metaColumn.getForeignColumnName(i), appendable2);
                    if (appendable != null) {
                        appendable.append(string);
                        appendable.append("?");
                    }
                    string = ", ";
                }
                continue;
            }
            if (!metaColumn.isColumn()) continue;
            appendable2.append(string);
            if (bl) {
                this.printColumnAlias(metaColumn, appendable2);
            } else {
                this.printQuotedName(metaColumn.getName(), appendable2);
            }
            if (appendable != null) {
                appendable.append(string);
                appendable.append("?");
            }
            string = ", ";
        }
    }

    public ValueCriterion printCriterion(ValueCriterion valueCriterion, Appendable appendable) throws IOException {
        Operator operator = valueCriterion.getOperator();
        Key key = valueCriterion.getLeftNode();
        ColumnWrapper columnWrapper = key != null ? AliasKey.getLastKey(key).getColumn(this.ormHandler) : null;
        Object object = valueCriterion.getRightNode();
        if (object == null) {
            switch (operator) {
                case EQ: 
                case EQUALS_CASE_INSENSITIVE: {
                    this.printColumnAlias(columnWrapper, appendable);
                    appendable.append(" IS NULL");
                    return null;
                }
                case NOT_EQ: {
                    this.printColumnAlias(columnWrapper, appendable);
                    appendable.append(" IS NOT NULL");
                    return null;
                }
            }
            throw new UnsupportedOperationException("Comparation the NULL value is forbiden by a operator: " + operator);
        }
        String string = this.getCriterionTemplate(valueCriterion);
        if (string == null) {
            throw new UnsupportedOperationException("Unsupported SQL operator: " + operator);
        }
        switch (valueCriterion.getOperator()) {
            case XFIXED: {
                appendable.append(string);
                break;
            }
            case XSQL: {
                if (object instanceof TemplateValue) {
                    object = ((TemplateValue)object).getRightVale();
                    ValueCriterion valueCriterion2 = (ValueCriterion)Criterion.where((Key)valueCriterion.getLeftNode(), (Operator)Operator.EQ, (Object)object);
                    return this.printCriterionValue(string, columnWrapper, valueCriterion2, appendable);
                }
                if (string.contains("{0}")) {
                    appendable.append(MessageFormat.format(string, this.getAliasColumnName(columnWrapper)));
                    break;
                }
                appendable.append(string);
                break;
            }
            default: {
                return this.printCriterionValue(string, columnWrapper, valueCriterion, appendable);
            }
        }
        return null;
    }

    protected ValueCriterion printCriterionValue(String string, ColumnWrapper columnWrapper, ValueCriterion valueCriterion, Appendable appendable) throws IOException {
        ColumnWrapper columnWrapper2;
        Object object = valueCriterion.getRightNode();
        if (object instanceof Key) {
            Key key = (Key)object;
            columnWrapper2 = AliasKey.getLastKey(key).getColumn(this.ormHandler);
            if (columnWrapper2.getModel().isForeignKey()) {
                throw new UnsupportedOperationException("Foreign key is not supported yet");
            }
        } else {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                StringBuilder stringBuilder = new StringBuilder(2 * objectArray.length);
                for (Object object2 : objectArray) {
                    stringBuilder.append(stringBuilder.length() > 0 ? ",?" : "?");
                }
                String string2 = MessageFormat.format(string, this.getAliasColumnName(columnWrapper), stringBuilder.toString());
                appendable.append(string2);
                return valueCriterion;
            }
            if (columnWrapper.getModel().isForeignKey()) {
                this.printForeignKey(valueCriterion, columnWrapper, string, appendable);
                return valueCriterion;
            }
            String string2 = MessageFormat.format(string, this.getAliasColumnName(columnWrapper), "?");
            appendable.append(string2);
            return valueCriterion;
        }
        String string3 = MessageFormat.format(string, this.getAliasColumnName(columnWrapper), this.getAliasColumnName(columnWrapper2));
        appendable.append(string3);
        return null;
    }

    protected String getAliasColumnName(ColumnWrapper columnWrapper) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.printQuotedName(columnWrapper.getTableAlias(), stringBuilder);
        stringBuilder.append('.');
        this.printQuotedName(columnWrapper.getName(), stringBuilder);
        return ((Object)stringBuilder).toString();
    }

    public void printForeignKey(ValueCriterion valueCriterion, ColumnWrapper columnWrapper, String string, Appendable appendable) throws IOException {
        int n = columnWrapper.getModel().getForeignColumns().size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                appendable.append(' ');
                appendable.append(valueCriterion.getOperator().name());
                appendable.append(' ');
            }
            StringBuilder stringBuilder = new StringBuilder(256);
            String string2 = columnWrapper.getTableAlias();
            if (this.isFilled(string2)) {
                this.printQuotedName(string2, stringBuilder);
                stringBuilder.append('.');
            }
            this.printQuotedName(columnWrapper.getModel().getForeignColumnName(i), stringBuilder);
            String string3 = MessageFormat.format(string, stringBuilder, "?");
            appendable.append(string3);
        }
    }

    public final Appendable printSelect(TableWrapper tableWrapper, Query query, boolean bl, Appendable appendable) throws IOException {
        return tableWrapper.isView() ? this.printSelectView(tableWrapper, query, bl, appendable) : this.printSelectTable(query, bl, appendable);
    }

    protected Appendable printSelectView(TableWrapper tableWrapper, Query query, boolean bl, Appendable appendable) throws IOException {
        String string = query.getSqlParameters() != null ? query.getSqlParameters().getSqlStatement() : null;
        MetaSelect metaSelect = string != null ? new MetaSelect(string, (String)MetaTable.SCHEMA.of((Ujo)tableWrapper.getModel())) : (MetaSelect)((Object)MetaTable.SELECT_MODEL.of((Ujo)tableWrapper.getModel()));
        String string2 = query.getDecoder().getWhere();
        List list = query.getOrderBy();
        for (Key key : metaSelect.readKeys()) {
            String string3 = (String)key.of((Ujo)metaSelect);
            if (key == MetaSelect.SELECT && bl) {
                appendable.append(key.toString());
                appendable.append("COUNT(*)");
                continue;
            }
            if (key == MetaSelect.WHERE && string3.length() + string2.length() > 0) {
                appendable.append(key.toString());
                appendable.append(string3);
                appendable.append(string3.length() == 0 || string2.length() == 0 ? "" : " AND ");
                appendable.append(string2);
                continue;
            }
            if (key == MetaSelect.ORDER && !bl && !list.isEmpty()) {
                this.printSelectOrder(query, appendable);
                continue;
            }
            if (key == MetaSelect.LIMIT && !bl && query.getLimit() > 0) {
                appendable.append(key.toString());
                appendable.append(String.valueOf(query.getLimit()));
                continue;
            }
            if (key == MetaSelect.OFFSET && !bl && query.getOffset() > 0L) {
                appendable.append(key.toString());
                appendable.append(String.valueOf(query.getOffset()));
                continue;
            }
            if (!this.isFilled(string3)) continue;
            appendable.append(key.toString());
            appendable.append(string3);
        }
        return appendable;
    }

    protected Appendable printSelectTable(Query query, boolean bl, Appendable appendable) throws IOException {
        if (bl && query.isDistinct()) {
            appendable.append("SELECT COUNT(*) FROM (");
            this.printSelectTableBase(query, bl, appendable);
            appendable.append("\n\tGROUP BY ");
            this.printTableColumns(query.getColumns(), null, appendable);
            appendable.append(") ujorm_count_");
        } else {
            this.printSelectTableBase(query, bl, appendable);
        }
        return appendable;
    }

    protected void printSelectTableBase(Query query, boolean bl, Appendable appendable) throws IOException {
        appendable.append("SELECT ");
        if (bl != query.isDistinct()) {
            appendable.append(bl ? "COUNT(*)" : "DISTINCT ");
        }
        if (!bl || query.isDistinct()) {
            this.printTableColumns(query.getColumns(), null, appendable);
        }
        appendable.append("\n\tFROM ");
        if (query.getCriterion() != null) {
            CriterionDecoder criterionDecoder = query.getDecoder();
            TableWrapper[] tableWrapperArray = criterionDecoder.getTables();
            for (int i = 0; i < tableWrapperArray.length; ++i) {
                if (i > 0) {
                    appendable.append(", ");
                }
                this.printTableAliasDefinition(tableWrapperArray[i], appendable);
            }
            String string = criterionDecoder.getWhere();
            if (string.length() > 0) {
                appendable.append(" WHERE ");
                appendable.append(string);
            }
        } else {
            this.printTableAliasDefinition(query.getTableModel(), appendable);
        }
        if (!bl) {
            if (!query.getOrderBy().isEmpty()) {
                this.printSelectOrder(query, appendable);
            }
            if (query.isOffset()) {
                this.printOffset(query, appendable);
            }
            if (query.isLockRequest()) {
                appendable.append(' ');
                this.printLockForSelect(query, appendable);
            }
        }
    }

    protected Appendable printLockForSelect(Query query, Appendable appendable) throws IOException, UnsupportedOperationException {
        appendable.append("FOR UPDATE");
        return appendable;
    }

    protected void printSelectOrder(Query query, Appendable appendable) throws IOException {
        appendable.append(" ORDER BY ");
        List list = query.getOrderBy();
        for (int i = 0; i < list.size(); ++i) {
            MetaColumn metaColumn = query.readOrderColumn(i);
            boolean bl = list.get(i).isAscending();
            if (i > 0) {
                appendable.append(", ");
            }
            this.printColumnAlias(metaColumn, appendable);
            if (bl) continue;
            appendable.append(" DESC");
        }
    }

    public Appendable printCall(MetaProcedure metaProcedure, Appendable appendable) throws IOException {
        List list = (List)MetaProcedure.PARAMETERS.of((Ujo)metaProcedure);
        appendable.append('{').append(' ');
        if (!((MetaColumn)list.get(0)).isVoid()) {
            appendable.append("? =");
        }
        appendable.append(" call ");
        appendable.append(metaProcedure.getProcedureName());
        if (list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                appendable.append(i == 1 ? "(?" : ",?");
            }
            appendable.append(')');
        }
        appendable.append(' ').append('}');
        return appendable;
    }

    public void printOffset(Query query, Appendable appendable) throws IOException {
        int n = query.isLimit() ? query.getLimit() : Integer.MAX_VALUE;
        appendable.append(" LIMIT " + n);
        appendable.append(" OFFSET " + query.getOffset());
    }

    protected Appendable printSequenceTableName(UjoSequencer ujoSequencer, Appendable appendable) throws IOException {
        String string = ujoSequencer.getDatabaseSchema();
        if (this.isFilled(string)) {
            this.printQuotedName(string, appendable);
            appendable.append('.');
        }
        this.printQuotedName(this.getSeqTableModel().getTableName(), appendable);
        return appendable;
    }

    public Appendable printSequenceTable(MetaDatabase metaDatabase, Appendable appendable) throws IOException {
        String string = (String)MetaDatabase.SCHEMA.of((Ujo)metaDatabase);
        Integer n = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)metaDatabase.getParams());
        appendable.append("CREATE TABLE ");
        if (this.isFilled(string)) {
            this.printQuotedName(string, appendable);
            appendable.append('.');
        }
        MetaColumn metaColumn = new MetaColumn();
        MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BIGINT);
        this.printQuotedName(this.getSeqTableModel().getTableName(), appendable);
        appendable.append("\n\t( " + this.getQuotedName(this.getSeqTableModel().getId()) + " VARCHAR(96) NOT NULL PRIMARY KEY" + "\n\t, " + this.getQuotedName(this.getSeqTableModel().getSequence()) + " " + this.getColumnType(metaColumn) + " DEFAULT " + n + " NOT NULL" + "\n\t, " + this.getQuotedName(this.getSeqTableModel().getCache()) + " INT DEFAULT " + n + " NOT NULL" + "\n\t, " + this.getQuotedName(this.getSeqTableModel().getMaxValue()) + " " + this.getColumnType(metaColumn) + " DEFAULT 0 NOT NULL" + "\n\t)");
        return appendable;
    }

    public Appendable printSequenceInit(UjoSequencer ujoSequencer, Appendable appendable) throws IOException {
        Integer n = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)ujoSequencer.getDatabase().getParams());
        return this.printSequenceInitWithValues(ujoSequencer, n.intValue(), n, appendable);
    }

    public Appendable printSequenceInitWithValues(UjoSequencer ujoSequencer, long l, int n, Appendable appendable) throws IOException {
        appendable.append("INSERT INTO ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" (");
        this.printQuotedNameAlways(this.getSeqTableModel().getId(), appendable);
        appendable.append(",");
        this.printQuotedNameAlways(this.getSeqTableModel().getSequence(), appendable);
        appendable.append(",");
        this.printQuotedNameAlways(this.getSeqTableModel().getCache(), appendable);
        appendable.append(",");
        this.printQuotedNameAlways(this.getSeqTableModel().getMaxValue(), appendable);
        appendable.append(") VALUES (?," + l).append("," + n).append(",0)");
        return appendable;
    }

    public Appendable printSequenceNextValue(UjoSequencer ujoSequencer, Appendable appendable) throws IOException {
        appendable.append("UPDATE ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" SET ");
        this.printQuotedNameAlways(this.getSeqTableModel().getSequence(), appendable);
        appendable.append("=");
        this.printQuotedNameAlways(this.getSeqTableModel().getSequence(), appendable);
        appendable.append("+");
        this.printQuotedNameAlways(this.getSeqTableModel().getCache(), appendable);
        appendable.append(" WHERE ");
        this.printQuotedNameAlways(this.getSeqTableModel().getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    public Appendable printSetMaxSequence(UjoSequencer ujoSequencer, Appendable appendable) throws IOException {
        appendable.append("UPDATE ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" SET ");
        this.printQuotedNameAlways(this.getSeqTableModel().getSequence(), appendable);
        appendable.append("=");
        this.printQuotedNameAlways(this.getSeqTableModel().getMaxValue(), appendable);
        appendable.append(" WHERE ");
        this.printQuotedNameAlways(this.getSeqTableModel().getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    public Appendable printSequenceCurrentValue(UjoSequencer ujoSequencer, Appendable appendable) throws IOException {
        SeqTableModel seqTableModel = this.getSeqTableModel();
        appendable.append("SELECT ");
        this.printQuotedNameAlways(seqTableModel.getSequence(), appendable);
        appendable.append(", ");
        this.printQuotedNameAlways(seqTableModel.getCache(), appendable);
        appendable.append(", ");
        this.printQuotedNameAlways(seqTableModel.getMaxValue(), appendable);
        appendable.append(" FROM ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" WHERE ");
        this.printQuotedNameAlways(seqTableModel.getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    public Appendable printSequenceDeleteById(UjoSequencer ujoSequencer, String string, Appendable appendable) throws IOException {
        SeqTableModel seqTableModel = this.getSeqTableModel();
        appendable.append("DELETE FROM ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" WHERE ");
        this.printQuotedNameAlways(seqTableModel.getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    protected final boolean isFilled(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public final void println(Appendable appendable) throws IOException {
        appendable.append('\n');
    }

    public Appendable printCommit(Appendable appendable) throws IOException {
        appendable.append("COMMIT");
        return appendable;
    }

    public Appendable printComment(MetaTable metaTable, Appendable appendable) throws IOException {
        appendable.append("COMMENT ON TABLE ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" IS '");
        this.escape((CharSequence)MetaTable.COMMENT.of((Ujo)metaTable), appendable);
        appendable.append("'");
        return appendable;
    }

    public Appendable printComment(MetaColumn metaColumn, Appendable appendable) throws IOException {
        appendable.append("COMMENT ON COLUMN ");
        this.printFullTableName((MetaTable)MetaColumn.TABLE.of((Ujo)metaColumn), appendable);
        appendable.append('.');
        appendable.append(metaColumn.getName());
        appendable.append(" IS '");
        this.escape((CharSequence)MetaColumn.COMMENT.of((Ujo)metaColumn), appendable);
        appendable.append("'");
        return appendable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeywordSet(Connection connection) {
        HashSet<String> hashSet = new HashSet<String>(128);
        Reader reader = null;
        try {
            reader = new CharArrayReader(connection.getMetaData().getSQLKeywords().concat(",").toCharArray());
            this.assignKeywords(hashSet, reader);
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/ujorm/orm/sql-keywords.txt"), "UTF8"));
            this.assignKeywords(hashSet, reader);
        }
        catch (Throwable throwable) {
            LOGGER.log(UjoLogger.WARN, "Can't read SQL keywords", throwable);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(UjoLogger.WARN, "Can't close reader", (Throwable)iOException);
                }
            }
        }
        hashSet.remove("");
        return hashSet;
    }

    private void assignKeywords(Set<String> set, Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != -1) {
            if (n == 44) {
                set.add(stringBuilder.toString().trim().toUpperCase());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append((char)n);
        }
    }

    protected final void escape(CharSequence charSequence, Appendable appendable) throws IOException {
        block3: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\'': {
                    appendable.append("''");
                    continue block3;
                }
                default: {
                    appendable.append(c);
                }
            }
        }
    }

    public SeqTableModel getSeqTableModel() {
        return this.pkTableModel;
    }

    public void releaseSavepoint(Connection connection, Savepoint savepoint, boolean bl) throws SQLException {
        connection.releaseSavepoint(savepoint);
    }

    public final Appendable printQuotedName(CharSequence charSequence, Appendable appendable) throws IOException {
        if (this.quoteRequest == null) {
            this.quoteRequest = this.ormHandler.getParameters().isQuotedSqlNames();
        }
        if (this.quoteRequest.booleanValue()) {
            this.printQuotedNameAlways(charSequence, appendable);
        } else {
            appendable.append(charSequence);
        }
        return appendable;
    }

    protected Appendable printQuotedNameAlways(CharSequence charSequence, Appendable appendable) throws IOException {
        appendable.append('\"');
        appendable.append(charSequence);
        appendable.append('\"');
        return appendable;
    }

    protected final String getQuotedName(CharSequence charSequence) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 4);
        this.printQuotedNameAlways(charSequence, stringBuilder);
        return stringBuilder.toString();
    }

    public SqlNameProvider getNameProvider() throws IllegalStateException {
        if (this.nameProvider == null) {
            try {
                this.nameProvider = (SqlNameProvider)((Class)MetaParams.SQL_NAME_PROVIDER.of((Ujo)this.ormHandler.getParameters())).newInstance();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Can't create an instance of the " + (Object)((Object)this.ormHandler.getParameters()), exception);
            }
        }
        return this.nameProvider;
    }

    public SqlDialectEx getExtentedDialect() {
        if (this.extentedDialect == null) {
            this.extentedDialect = new SqlDialectEx(this);
        }
        return this.extentedDialect;
    }

    public Appendable printNextSequence(String string, MetaTable metaTable, Appendable appendable) throws IOException {
        appendable.append("SELECT NEXTVAL('");
        appendable.append(string);
        appendable.append("')");
        return appendable;
    }
}

