/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.impl;

import org.ujorm.Key;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.metaModel.MetaColumn;

public class ColumnWrapperImpl
implements ColumnWrapper {
    private MetaColumn column;
    private String tableAlias;
    private Key key;

    public ColumnWrapperImpl(MetaColumn metaColumn, String string) {
        this(metaColumn, string, metaColumn.getKey());
    }

    public ColumnWrapperImpl(MetaColumn metaColumn, Key key) {
        this(metaColumn, null, key);
    }

    public ColumnWrapperImpl(MetaColumn metaColumn, String string, Key key) {
        assert (metaColumn != null) : "The MetaColumn must not be null";
        this.column = metaColumn;
        this.tableAlias = string != null ? string : metaColumn.getTableAlias();
        this.key = key != null ? key : metaColumn.getKey();
    }

    @Override
    public MetaColumn getModel() {
        return this.column;
    }

    @Override
    public String getName() {
        return this.column.getName();
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public boolean isCompositeKey() {
        return this.key.isComposite();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ColumnWrapper) {
            Key key = ((ColumnWrapper)object).getKey();
            return this.getKey().getName().equals(key.getName()) && this.getKey().getDomainType() == key.getDomainType();
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().getName().hashCode();
    }

    public String toString() {
        return this.key.getFullName();
    }
}

