/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.Session;
import org.ujorm.orm.ao.CheckReport;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.dialect.MSSqlDialect;
import org.ujorm.orm.dialect.MySqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaDbService;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;

public class MetaDbServiceEx
extends MetaDbService {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(MetaDbServiceEx.class);
    public static boolean DEFAULT_VALUES_IN_DB_ALLOWED = false;
    public static final String COLUMN_DEF_DEFAULT_VALUE = "COLUMN_DEF";
    public static final String COLUMN_DEF_NAME = "COLUMN_NAME";
    public static final String COLUMN_DEF_NULLABLE = "NULLABLE";
    public static final String COLUMN_DEF_CHAR_LENGTH = "COLUMN_SIZE";
    public static final String COLUMN_DEF_VALUE_CONSTRAINTS = "COLUMN_DEF_VALUE_CONSTRAINTS";
    public static final String PKEY_DEF_NAME = "PK_NAME";
    public static final String PKEY_DEF_COLUMN_NAME = "COLUMN_NAME";
    public static final String FKEY_DEF_NAME = "FK_NAME";
    private static final String MYSQL_PRIMARY_KEY_NAME = "PRIMARY";
    private static final String ID_COLUMN_NAME = "ID";

    public void checkDBStructure(Session session, boolean bl) throws Exception {
        LOGGER.log(UjoLogger.INFO, "UJORM checking db structure...");
        Connection connection = session.getConnection(this.db, bl);
        try {
            Object object;
            ArrayList<? extends String> arrayList = new ArrayList<String>();
            ArrayList<MetaTable> arrayList2 = new ArrayList<MetaTable>((Collection)((Object)this.db.get(MetaDatabase.TABLES)));
            Object object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                object = (MetaTable)object2.next();
                if (((MetaTable)object).isPersistent()) continue;
                object2.remove();
            }
            object2 = this.db.getIndexList();
            switch ((CheckReport)((Object)MetaParams.CHECK_KEYWORDS.of((Ujo)this.db.getParams()))) {
                case EXCEPTION: {
                    LOGGER.log(UjoLogger.INFO, "Checking keywords (tables=" + arrayList2.size() + ", indexes=" + object2.size() + ") ...");
                    this.checkKeywords(connection, arrayList2, null, (List<MetaIndex>)object2);
                }
            }
            LOGGER.log(UjoLogger.INFO, "Checking tables (tables=" + arrayList2.size() + ") ...");
            arrayList.addAll(this.checkTables(connection, arrayList2, bl));
            LOGGER.log(UjoLogger.INFO, "Checking ujorm_pk_support sequences (tables=" + arrayList2.size() + ") ...");
            arrayList.addAll(this.checkUjormPKSupport(connection, arrayList2, bl));
            if (bl) {
                connection.commit();
                LOGGER.log(UjoLogger.INFO, "REPAIR finished, you should look at the previous logs for details. Possible errors could be repaired, you should restart server now!");
            }
            if (arrayList.size() > 0) {
                object = new StringBuilder("FATAL errors [" + arrayList.size() + "] in database (some could be repaired, you should restart server):\n");
                for (String string : arrayList) {
                    ((StringBuilder)object).append(string.trim()).append("\n");
                }
                throw new RuntimeException(((StringBuilder)object).toString());
            }
            LOGGER.log(UjoLogger.INFO, "CHECK DB finished, everything is ok!");
        }
        catch (Exception exception) {
            if (bl) {
                connection.commit();
            } else {
                connection.rollback();
            }
            throw exception;
        }
    }

    public void checkKeywords(Connection connection, List<MetaTable> list, List<MetaColumn> list2, List<MetaIndex> list3) throws Exception {
        Set<String> set = this.getDialect().getKeywordSet(connection);
        if (list != null) {
            for (MetaTable abstractMetaModel : list) {
                if (!abstractMetaModel.isTable()) continue;
                this.checkKeyWord((String)MetaTable.NAME.of((Ujo)abstractMetaModel), abstractMetaModel, set);
                for (MetaColumn metaColumn : (List)MetaTable.COLUMNS.of((Ujo)abstractMetaModel)) {
                    this.checkKeyWord((String)MetaColumn.NAME.of((Ujo)metaColumn), abstractMetaModel, set);
                }
            }
        }
        if (list2 != null) {
            for (MetaColumn metaColumn : list2) {
                this.checkKeyWord((String)MetaColumn.NAME.of((Ujo)metaColumn), metaColumn.getTable(), set);
            }
        }
        if (list3 != null) {
            for (MetaIndex metaIndex : list3) {
                this.checkKeyWord((String)MetaIndex.NAME.of((Ujo)metaIndex), (MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex), set);
            }
        }
    }

    private List<String> checkTables(Connection connection, List<MetaTable> list, boolean bl) throws Exception {
        List<String> list2;
        ArrayList<String> arrayList = new ArrayList<String>();
        LOGGER.log(UjoLogger.INFO, "Checking tables (" + list.size() + ") for existence ...");
        for (MetaTable metaTable : list) {
            if (!metaTable.isTable()) continue;
            if (bl) {
                metaTable.clearReadOnly();
                MetaTable.ORM2DLL_POLICY.setValue((Ujo)metaTable, (Object)Orm2ddlPolicy.CREATE_OR_UPDATE_DDL);
                metaTable.setReadOnly(false);
            }
            list2 = (List<String>)((Object)metaTable.get(MetaTable.COLUMNS));
            LOGGER.log(UjoLogger.INFO, "Checking table '" + metaTable.getAlias() + "', columns=" + list2.size() + " ...");
            Map<String, Map<String, Object>> map = this.listDBTableColumns(metaTable, connection.getMetaData());
            if (map.size() >= 1) continue;
            String string = "MISSING db table '" + metaTable.getAlias() + "'";
            LOGGER.log(UjoLogger.WARN, string);
            arrayList.add(string);
            if (!bl) continue;
            StringBuilder stringBuilder = new StringBuilder();
            this.getDialect().printTable(metaTable, stringBuilder);
            string = "  REPAIR: Adding table '" + metaTable.getAlias() + "' with SQL:\n" + stringBuilder;
            LOGGER.log(UjoLogger.INFO, string);
            this.executeUpdate(stringBuilder, metaTable);
        }
        LOGGER.log(UjoLogger.INFO, "Checking tables (" + list.size() + ") for missing columns ...");
        for (MetaTable metaTable : list) {
            if (!metaTable.isTable()) continue;
            LOGGER.log(UjoLogger.INFO, "Checking table '" + metaTable.getAlias() + "' for missing columns ...");
            list2 = this.checkTableForMissingColumns(connection, metaTable, bl);
            arrayList.addAll(list2);
        }
        LOGGER.log(UjoLogger.INFO, "Checking tables (" + list.size() + ") for columns properies ...");
        for (MetaTable metaTable : list) {
            if (!metaTable.isTable()) continue;
            LOGGER.log(UjoLogger.INFO, "Checking table '" + metaTable.getAlias() + "' for columns properties ...");
            list2 = this.checkTableForColumnsProperties(connection, metaTable, bl);
            arrayList.addAll(list2);
        }
        LOGGER.log(UjoLogger.INFO, "Checking tables (" + list.size() + ") for missing columns ...");
        for (MetaTable metaTable : list) {
            if (!metaTable.isTable()) continue;
            LOGGER.log(UjoLogger.INFO, "Checking table '" + metaTable.getAlias() + "' for primary keys ...");
            list2 = this.checkTableForPrimaryKeys(connection, metaTable, bl);
            arrayList.addAll(list2);
        }
        LOGGER.log(UjoLogger.INFO, "Checking tables (" + list.size() + ") for foreign keys ...");
        for (MetaTable metaTable : list) {
            if (!metaTable.isTable()) continue;
            LOGGER.log(UjoLogger.INFO, "Checking table '" + metaTable.getAlias() + "' for foreign keys ...");
            list2 = this.checkTableForForeignKeys(connection, metaTable, bl);
            arrayList.addAll(list2);
        }
        LOGGER.log(UjoLogger.INFO, "Checking tables (" + list.size() + ") for indexes ...");
        for (MetaTable metaTable : list) {
            if (!metaTable.isTable()) continue;
            LOGGER.log(UjoLogger.INFO, "Checking table '" + metaTable.getAlias() + "' for indexes ...");
            list2 = this.checkTableForIndexes(connection, metaTable, bl);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public List<String> checkTableForMissingColumns(Connection connection, MetaTable metaTable, boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = (List)((Object)metaTable.get(MetaTable.COLUMNS));
        Map<String, Map<String, Object>> map = this.listDBTableColumns(metaTable, connection.getMetaData());
        if (list.size() != map.size()) {
            String string = "  DIFFERENT count of mapped (ujorm) and received (db) columns in table '" + metaTable.getAlias() + "'! Mapped=" + list.size() + ",Received=" + map.size();
            LOGGER.log(UjoLogger.WARN, string);
            arrayList.add(string);
        }
        for (MetaColumn metaColumn : list) {
            String string = ((String)metaColumn.get(MetaColumn.NAME)).toUpperCase();
            LOGGER.log(UjoLogger.INFO, "  Checking column " + string + " ...");
            if (map.containsKey(string)) continue;
            String string2 = "  MISSING db column '" + string + "' in table '" + metaTable.getAlias() + "'";
            LOGGER.log(UjoLogger.WARN, string2);
            arrayList.add(string2);
            if (!bl) continue;
            StringBuilder stringBuilder = new StringBuilder();
            this.getDialect().printAlterTableAddColumn(metaColumn, stringBuilder);
            string2 = "  REPAIR: Adding column '" + string + "' to table '" + metaTable.getAlias() + "' with SQL:\n" + stringBuilder;
            LOGGER.log(UjoLogger.INFO, string2);
            this.executeUpdate(stringBuilder, metaTable);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<String> checkTableForColumnsProperties(Connection connection, MetaTable metaTable, boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = (List)((Object)metaTable.get(MetaTable.COLUMNS));
        Map<String, Map<String, Object>> map = this.listDBTableColumns(metaTable, connection.getMetaData());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            MetaColumn metaColumn = (MetaColumn)iterator.next();
            String string = ((String)metaColumn.get(MetaColumn.NAME)).toUpperCase();
            String string2 = metaColumn.get(MetaColumn.DB_TYPE).name();
            LOGGER.log(UjoLogger.INFO, "  Checking column " + string + " ...");
            Map<String, Object> map2 = map.get(string);
            if (map2 == null) {
                LOGGER.log(UjoLogger.WARN, "  Missing column " + string);
                continue;
            }
            int n = metaColumn.getMaxLength();
            if (n != -1 && metaColumn.getKey().isTypeOf(CharSequence.class)) {
                LOGGER.log(UjoLogger.INFO, "    Checking column char max length...");
                object4 = map2.get(COLUMN_DEF_CHAR_LENGTH);
                if (object4 != null && !object4.equals(n)) {
                    object3 = "    MISSING or DIFFERENT max length on column '" + string + "' in table '" + metaTable.getAlias() + "': Mapped=" + n + ", Received=" + object4;
                    LOGGER.log(UjoLogger.WARN, (String)object3);
                    arrayList.add((String)object3);
                    if (bl) {
                        boolean bl2;
                        boolean bl3 = bl2 = metaColumn.get(MetaColumn.UNIQUE_INDEX).length() > 0;
                        if (bl2) {
                            object3 = "    It's not possible to repair column length with unique index.";
                            LOGGER.log(UjoLogger.WARN, (String)object3);
                        } else {
                            object2 = metaTable.createIndexNameForColumn(metaColumn, false);
                            object = null;
                            if (object2 != null) {
                                object = metaTable.createIndexForColumn((String)object2, metaColumn);
                                ((AbstractMetaModel)((Object)object)).writeValue((Key<?, ?>)MetaIndex.COLUMNS, new ArrayList(1));
                                ((List)((Object)((AbstractMetaModel)((Object)object)).get(MetaIndex.COLUMNS))).add(metaColumn);
                                StringBuilder stringBuilder = new StringBuilder();
                                this.getDialectEx().printDropIndex((MetaIndex)((Object)object), stringBuilder);
                                object3 = "  REPAIR: Dropping index '" + (String)object2 + "' to table '" + metaTable.getAlias() + "' with SQL:\n" + stringBuilder;
                                LOGGER.log(UjoLogger.INFO, (String)object3);
                                this.executeUpdate(stringBuilder, metaTable);
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            this.getDialect().printAlterTableColumn(metaColumn, false, stringBuilder);
                            object3 = "  REPAIR: Changing column '" + string + "' to table '" + metaTable.getAlias() + "' with SQL:\n" + stringBuilder;
                            LOGGER.log(UjoLogger.INFO, (String)object3);
                            this.executeUpdate(stringBuilder, metaTable);
                            if (object2 != null) {
                                StringBuilder stringBuilder2 = new StringBuilder();
                                this.getDialect().printIndex((MetaIndex)((Object)object), stringBuilder2);
                                object3 = "  REPAIR: Adding index '" + (String)object2 + "' to table '" + metaTable.getAlias() + "' with SQL:\n" + stringBuilder2;
                                LOGGER.log(UjoLogger.INFO, (String)object3);
                                this.executeUpdate(stringBuilder2, metaTable);
                            }
                        }
                    }
                }
            }
            if (DEFAULT_VALUES_IN_DB_ALLOWED && metaColumn.hasDefaultValue()) {
                boolean bl4;
                String string3;
                LOGGER.log(UjoLogger.INFO, "    Checking column default constraint name ...");
                object4 = (Map)map2.get(COLUMN_DEF_VALUE_CONSTRAINTS);
                if (object4 != null && !((String)(object3 = (String)object4.get("constraint"))).equals(string3 = this.getDialect().getNameProvider().buildDefaultConstraintForDefaultValueName(metaTable, metaColumn))) {
                    String string4 = "    DIFFERENT default value constraint name on column '" + string + "' in table '" + metaTable.getAlias() + "': Mapped=" + string3 + ", Received=" + (String)object3;
                    LOGGER.log(UjoLogger.WARN, string4);
                    arrayList.add(string4);
                    if (bl) {
                        // empty if block
                    }
                }
                object3 = metaColumn.getJdbcFriendlyDefaultValue();
                LOGGER.log(UjoLogger.INFO, "    Checking column default value '" + object3 + "' ...");
                Object object5 = map2.get(COLUMN_DEF_DEFAULT_VALUE);
                if (object5 instanceof String) {
                    String string5 = (String)object5;
                    if (string5.startsWith("(N'") && string5.endsWith("')")) {
                        String string6 = string5.substring(3, string5.length() - 2);
                        object5 = string6;
                    } else if (string5.startsWith("('") && string5.endsWith("')")) {
                        String string7 = string5.substring(2, string5.length() - 2);
                        object5 = string7;
                    } else if (!string2.equalsIgnoreCase("BOOLEAN") && string5.matches("\\(\\(.*\\)\\)")) {
                        object2 = Pattern.compile("\\(\\((.*)\\)\\)");
                        object = ((Pattern)object2).matcher(string5);
                        if (((Matcher)object).find()) {
                            object5 = ((Matcher)object).group(1);
                        }
                    } else if (string2.equalsIgnoreCase("BOOLEAN") && (string5.equals("((1))") || string5.equals("1"))) {
                        object5 = true;
                    } else if (string2.equalsIgnoreCase("BOOLEAN") && (string5.equals("((0))") || string5.equals("0"))) {
                        object5 = false;
                    } else if (string2.equalsIgnoreCase("DECIMAL")) {
                        object5 = new BigDecimal(string5);
                    }
                }
                boolean bl5 = true;
                if (object3 == null && object5 != null || object3 != null && object5 == null || object3 != null && !object3.toString().equals("" + object5)) {
                    boolean bl6 = false;
                }
                if (object5 instanceof BigDecimal && object3 instanceof BigDecimal) {
                    object2 = (BigDecimal)object5;
                    object = (BigDecimal)object3;
                    boolean bl7 = bl4 = ((BigDecimal)object2).compareTo((BigDecimal)object) == 0;
                }
                if (!bl4) {
                    object2 = "    MISSING or DIFFERENT default value on column '" + string + "' in table '" + metaTable.getAlias() + "': Mapped=" + object3 + ", Received=" + object5;
                    LOGGER.log(UjoLogger.WARN, (String)object2);
                    arrayList.add((String)object2);
                    if (!bl) {
                        // empty if block
                    }
                }
            } else {
                LOGGER.log(UjoLogger.INFO, "    Checking column has no default value ...");
                object4 = map2.get(COLUMN_DEF_DEFAULT_VALUE);
                if (!this.isDefaultValueNull(map2)) {
                    object3 = "    DIFFERENT default value on column '" + string + "' in table '" + metaTable.getAlias() + "': Mapped=" + null + ", Received=" + object4;
                    LOGGER.log(UjoLogger.WARN, (String)object3);
                    arrayList.add((String)object3);
                    if (bl) {
                        // empty if block
                    }
                }
            }
            object4 = (Integer)map2.get(COLUMN_DEF_NULLABLE);
            if (metaColumn.isMandatory() || metaColumn.isPrimaryKey()) {
                LOGGER.log(UjoLogger.INFO, "    Checking column not null ...");
                if (object4 != null && (Integer)object4 == 0) continue;
                object3 = "    MISSING not null on column '" + string + "' in table '" + metaTable.getAlias() + "'";
                LOGGER.log(UjoLogger.WARN, (String)object3);
                arrayList.add((String)object3);
                if (bl) continue;
                continue;
            }
            LOGGER.log(UjoLogger.INFO, "    Checking column nullable ...");
            if (object4 != null && (Integer)object4 == 1) continue;
            object3 = "    MISSING nullable on column '" + string + "' in table '" + metaTable.getAlias() + "'";
            LOGGER.log(UjoLogger.WARN, (String)object3);
            arrayList.add((String)object3);
            if (bl) continue;
        }
        return arrayList;
    }

    private boolean isDefaultValueNull(Map<String, Object> map) {
        Object object = map.get(COLUMN_DEF_DEFAULT_VALUE);
        Object object2 = map.get("COLUMN_NAME");
        if (this.isDialectTypeMySql() && object2.equals("id") && object != null && object.equals("0")) {
            return true;
        }
        return object == null;
    }

    public List<String> checkTableForPrimaryKeys(Connection connection, MetaTable metaTable, boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MetaColumn> list = Arrays.asList(metaTable.getFirstPK());
        Map<String, Map<String, Object>> map = this.listDBTablePKey(metaTable, connection.getMetaData());
        if (list.size() != map.size()) {
            String string = "  DIFFERENT count of mapped (ujorm) and received (db) primary keys in table '" + metaTable.getAlias() + "'! Mapped=" + list.size() + ",Received=" + map.size();
            LOGGER.log(UjoLogger.WARN, string);
            arrayList.add(string);
        }
        for (MetaColumn metaColumn : list) {
            Object object;
            Object object2;
            CharSequence charSequence2;
            String string = ((String)metaColumn.get(MetaColumn.NAME)).toUpperCase();
            if (this.isDialectTypeMySql() && string.equals(ID_COLUMN_NAME) && map.containsKey(MYSQL_PRIMARY_KEY_NAME)) continue;
            String string2 = this.getDialect().getNameProvider().buildPrimaryKeyName(metaTable, Arrays.asList(metaColumn));
            LOGGER.log(UjoLogger.INFO, "  Checking primary key '" + string2 + "' on column " + string + " ...");
            if (map.containsKey(string2.toUpperCase())) continue;
            String string3 = null;
            for (CharSequence charSequence2 : map.keySet()) {
                object2 = map.get(charSequence2).get("COLUMN_NAME").toString().toUpperCase();
                if (!string.equals(object2)) continue;
                string3 = charSequence2;
                break;
            }
            if (string3 != null) {
                object = "  DIFFERENT primary key name on column '" + string + "' in table '" + metaTable.getAlias() + "', Mapped=" + string2 + ", Received=" + string3;
                LOGGER.log(UjoLogger.WARN, (String)object);
                arrayList.add((String)object);
                if (!bl) continue;
            }
            object = "  MISSING primary key '" + string2 + "' on column '" + string + "' in table '" + metaTable.getAlias() + "'";
            LOGGER.log(UjoLogger.WARN, (String)object);
            arrayList.add((String)object);
            if (!bl) continue;
            charSequence2 = new StringBuilder();
            object2 = metaColumn.getTable();
            this.getDialectEx().printPrimaryKey(metaColumn, (StringBuilder)charSequence2);
            object = "  REPAIR: Adding primary key '" + string2 + "' on column '" + string + "' in table '" + metaTable.getAlias() + "' with SQL:\n" + charSequence2;
            LOGGER.log(UjoLogger.INFO, (String)object);
            this.executeUpdate((Appendable)((Object)charSequence2), (MetaTable)object2);
        }
        return arrayList;
    }

    public List<String> checkTableForForeignKeys(Connection connection, MetaTable metaTable, boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MetaColumn> list = metaTable.getForeignColumns();
        Map<String, Map<String, Object>> map = this.listDBTableFKey(metaTable, connection.getMetaData());
        if (list.size() != map.size()) {
            String string = "  DIFFERENT count of mapped (ujorm) and received (db) foreign keys in table '" + metaTable.getAlias() + "'! Mapped=" + list.size() + ",Received=" + map.size();
            LOGGER.log(UjoLogger.WARN, string);
            arrayList.add(string);
        }
        for (MetaColumn metaColumn : list) {
            String string = ((String)metaColumn.get(MetaColumn.NAME)).toUpperCase();
            String string2 = this.getDialectEx().buildConstraintName(metaColumn, metaTable);
            LOGGER.log(UjoLogger.INFO, "  Checking foreign key '" + string2 + "' on column " + string + " ...");
            if (map.containsKey(string2.toUpperCase())) continue;
            String string3 = "  MISSING foreign key '" + string2 + "' on column '" + string + "' in table '" + metaTable.getAlias() + "'";
            LOGGER.log(UjoLogger.WARN, string3);
            arrayList.add(string3);
            if (!bl) continue;
            StringBuilder stringBuilder = new StringBuilder();
            this.getDialect().printForeignKey(metaColumn, stringBuilder);
            string3 = "  REPAIR: Adding foreign key '" + string2 + "' on column '" + string + "' in table '" + metaTable.getAlias() + "' with SQL:\n" + stringBuilder;
            LOGGER.log(UjoLogger.INFO, string3);
            this.executeUpdate(stringBuilder, metaColumn.getTable());
        }
        return arrayList;
    }

    public List<String> checkTableForIndexes(Connection connection, MetaTable metaTable, boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MetaColumn> list = Arrays.asList(metaTable.getFirstPK());
        Set<String> set = this.listDBTableIndexes(metaTable, connection.getMetaData(), list);
        Collection<MetaIndex> collection = metaTable.getIndexCollection();
        if (collection.size() != set.size()) {
            String string = "  DIFFERENT count of mapped (ujorm) and received (db) indexes in table '" + metaTable.getAlias() + "'! Mapped=" + collection.size() + ",Received=" + set.size();
            LOGGER.log(UjoLogger.WARN, string);
            arrayList.add(string);
        }
        for (MetaIndex metaIndex : collection) {
            StringBuilder stringBuilder;
            String string;
            String string2;
            if (!metaIndex.get(MetaIndex.UNIQUE).booleanValue()) {
                string2 = metaIndex.get(MetaIndex.NAME).toUpperCase();
                LOGGER.log(UjoLogger.INFO, "  Checking index " + string2 + " ...");
                if (set.contains(string2)) continue;
                string = "  MISSING db index '" + string2 + "' in table '" + metaTable.getAlias() + "'";
                LOGGER.log(UjoLogger.WARN, string);
                arrayList.add(string);
                if (!bl) continue;
                stringBuilder = new StringBuilder();
                this.getDialect().printIndex(metaIndex, stringBuilder);
                string = "  REPAIR: Adding index '" + string2 + "' to table '" + metaTable.getAlias() + "' with SQL:\n" + stringBuilder;
                LOGGER.log(UjoLogger.INFO, string);
                this.executeUpdate(stringBuilder, metaTable);
                continue;
            }
            string2 = this.getDialect().getNameProvider().getUniqueConstraintName((List)((Object)metaIndex.get(MetaIndex.COLUMNS))).toUpperCase();
            LOGGER.log(UjoLogger.INFO, "  Checking unique index " + string2 + " ...");
            if (set.contains(string2)) continue;
            string = "  MISSING db unique index '" + string2 + "' in table '" + metaTable.getAlias() + "'";
            LOGGER.log(UjoLogger.WARN, string);
            arrayList.add(string);
            if (!bl) continue;
            stringBuilder = new StringBuilder();
            this.getDialectEx().printUniqueConstraint((List)MetaIndex.COLUMNS.of((Ujo)metaIndex), stringBuilder);
            string = "  REPAIR: Adding unique index '" + string2 + "' to table '" + metaTable.getAlias() + "' with SQL:\n" + stringBuilder;
            LOGGER.log(UjoLogger.INFO, string);
            this.executeUpdate(stringBuilder, metaTable);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends String> checkUjormPKSupport(Connection connection, List<MetaTable> list, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (MetaTable object52 : list) {
            PreparedStatement preparedStatement;
            String string;
            int n;
            String string2;
            if (!object52.getSequencer().isSequenceTableRequired()) continue;
            LOGGER.log(UjoLogger.INFO, "Checking ujorm_pk_support for table '" + object52.getAlias() + "' ...");
            object4 = new StringBuilder();
            ((StringBuilder)object4).append("SELECT MAX(");
            this.getDialect().printColumnAlias(object52.getFirstPK(), (Appendable)object4);
            ((StringBuilder)object4).append(") FROM ");
            this.getDialect().printFullTableName(object52, (Appendable)object4);
            hashSet.add(this.getDialect().printFullTableName(object52, true, new StringBuilder()).toString());
            object3 = connection.prepareStatement(((StringBuilder)object4).toString());
            object2 = null;
            object = null;
            try {
                object2 = object3.executeQuery();
                object2.next();
                object = object2.getLong(1);
                LOGGER.log(UjoLogger.INFO, "  Table max id = " + object);
            }
            finally {
                MetaDatabase.close(null, (Statement)object3, (ResultSet)object2, true);
            }
            long[] lArray = object52.getSequencer().getCurrentDBSequence(connection, null);
            Long l = lArray != null ? Long.valueOf(lArray[1]) : null;
            LOGGER.log(UjoLogger.INFO, "  Ujorm max id = " + l);
            if ((Long)object > 0L && l == null) {
                string2 = "  CORRUPTED db sequence for table '" + object52.getAlias() + "': there are real data and sequence is not created! table max id: " + object;
                LOGGER.log(UjoLogger.WARN, string2);
                arrayList.add(string2);
                if (!bl) continue;
                object4 = new StringBuilder();
                n = object52.getSequencer().getIncrement();
                l = ((Long)object / (long)n + 1L) * (long)n;
                this.getDialect().printSequenceInitWithValues(object52.getSequencer(), l, n, (Appendable)object4);
                string2 = "  REPAIR: Adding new sequence for table '" + object52.getAlias() + "' with new ujormMaxId = '" + l + "' with SQL:\n" + object4;
                LOGGER.log(UjoLogger.INFO, string2);
                string = this.getDialect().printFullTableName(object52, true, new StringBuilder()).toString();
                preparedStatement = connection.prepareStatement(((StringBuilder)object4).toString());
                try {
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
                finally {
                    MetaDatabase.close(null, preparedStatement, null, true);
                }
                object52.getSequencer().reset();
                continue;
            }
            if (l == null || (Long)object <= l) continue;
            string2 = "  CORRUPTED db sequence for table '" + object52.getAlias() + "': ujorm max id > table max id: " + l + ">" + object;
            LOGGER.log(UjoLogger.WARN, string2);
            arrayList.add(string2);
            if (!bl) continue;
            object4 = new StringBuilder();
            n = (int)lArray[2];
            l = ((Long)object / (long)n + 1L) * (long)n;
            this.getDialectEx().printSequenceNextValueWithValues(object52.getSequencer(), l, (Appendable)object4);
            string2 = "  REPAIR: Updating sequence for table '" + object52.getAlias() + "' with new ujormMaxId = '" + l + "' with SQL:\n" + object4;
            LOGGER.log(UjoLogger.INFO, string2);
            string = this.getDialect().printFullTableName(object52, true, new StringBuilder()).toString();
            preparedStatement = connection.prepareStatement(((StringBuilder)object4).toString());
            try {
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
            }
            finally {
                MetaDatabase.close(null, preparedStatement, null, true);
            }
            object52.getSequencer().reset();
        }
        LOGGER.log(UjoLogger.INFO, "Checking ujorm_pk_support for invalid sequences ...");
        Object object6 = new StringBuilder();
        this.getDialectEx().printSequenceListAllId(this.findFirstSequencer(), (Appendable)object6);
        PreparedStatement preparedStatement = connection.prepareStatement(((StringBuilder)object6).toString());
        object4 = null;
        try {
            object4 = preparedStatement.executeQuery();
            while (object4.next()) {
                object3 = object4.getString(1);
                if (hashSet.contains(object3)) continue;
                object2 = "  INVALID db sequence '" + (String)object3 + "': there is no mapped table for that sequence";
                LOGGER.log(UjoLogger.WARN, (String)object2);
                arrayList.add((String)object2);
                if (!bl) continue;
                object6 = new StringBuilder();
                this.getDialect().printSequenceDeleteById(this.findFirstSequencer(), (String)object3, (Appendable)object6);
                object2 = "  REPAIR: Deleting invalid sequence '" + (String)object3 + "' with SQL:\n" + object6;
                LOGGER.log(UjoLogger.INFO, (String)object2);
                object = connection.prepareStatement(((StringBuilder)object6).toString());
                try {
                    object.setString(1, (String)object3);
                    object.executeUpdate();
                }
                finally {
                    MetaDatabase.close(null, (Statement)object, null, true);
                }
            }
        }
        finally {
            MetaDatabase.close(null, preparedStatement, (ResultSet)object4, true);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> listDBTableColumns(MetaTable metaTable, DatabaseMetaData databaseMetaData) throws SQLException {
        boolean bl;
        HashMap<String, Object> hashMap;
        String string;
        ResultSet resultSet;
        LinkedHashMap<String, Map<String, Object>> linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
        String string2 = this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)metaTable), databaseMetaData);
        String string3 = this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData);
        HashMap hashMap2 = null;
        if (this.isDialectTypeMSSql()) {
            PreparedStatement preparedStatement = databaseMetaData.getConnection().prepareStatement("SELECT o.name [table], c.name [column], object_name(d.constid) [constraint], cm.text [default_value] FROM sysconstraints d, sysobjects o, syscolumns c, syscomments cm WHERE  (o.id = d.id)   AND (c.id = o.id AND c.colid = d.colid)   AND (cm.id = d.constid)   AND (d.[status] & 5 = 5) AND (o.xtype = 'U')  AND (o.name = ?) ORDER BY [table], [column], [constraint];");
            resultSet = null;
            try {
                preparedStatement.setString(1, string3);
                resultSet = preparedStatement.executeQuery();
                hashMap2 = new HashMap();
                while (resultSet.next()) {
                    string = resultSet.getString("column");
                    hashMap = new HashMap();
                    hashMap2.put(string, hashMap);
                    hashMap.put("constraint", resultSet.getString("constraint"));
                    hashMap.put("default_value", resultSet.getString("default_value"));
                }
            }
            finally {
                MetaDatabase.close(null, preparedStatement, resultSet, true);
            }
        }
        resultSet = databaseMetaData.getColumns((bl = this.isCatalog()) ? string2 : null, bl ? null : string2, string3, null);
        while (resultSet.next()) {
            string = resultSet.getString("COLUMN_NAME");
            hashMap = new HashMap<String, Object>();
            linkedHashMap.put(string.toUpperCase(), hashMap);
            hashMap.put("COLUMN_NAME", string);
            hashMap.put(COLUMN_DEF_DEFAULT_VALUE, resultSet.getString(COLUMN_DEF_DEFAULT_VALUE));
            hashMap.put(COLUMN_DEF_NULLABLE, resultSet.getInt(COLUMN_DEF_NULLABLE));
            hashMap.put(COLUMN_DEF_CHAR_LENGTH, resultSet.getInt(COLUMN_DEF_CHAR_LENGTH));
            hashMap.put(COLUMN_DEF_VALUE_CONSTRAINTS, hashMap2 != null ? (HashMap)hashMap2.get(string) : null);
        }
        resultSet.close();
        return linkedHashMap;
    }

    public Map<String, Map<String, Object>> listDBTablePKey(MetaTable metaTable, DatabaseMetaData databaseMetaData) throws SQLException {
        LinkedHashMap<String, Map<String, Object>> linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
        String string = this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)metaTable), databaseMetaData);
        String string2 = this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData);
        boolean bl = this.isCatalog();
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(bl ? string : null, bl ? null : string, string2);
        while (resultSet.next()) {
            String string3 = resultSet.getString(PKEY_DEF_NAME);
            String string4 = resultSet.getString("COLUMN_NAME");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            linkedHashMap.put(string3.toUpperCase(), hashMap);
            hashMap.put(PKEY_DEF_NAME, string3);
            hashMap.put("COLUMN_NAME", string4);
        }
        resultSet.close();
        return linkedHashMap;
    }

    public Map<String, Map<String, Object>> listDBTableFKey(MetaTable metaTable, DatabaseMetaData databaseMetaData) throws SQLException {
        LinkedHashMap<String, Map<String, Object>> linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
        String string = this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)metaTable), databaseMetaData);
        String string2 = this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData);
        boolean bl = this.isCatalog();
        ResultSet resultSet = databaseMetaData.getImportedKeys(bl ? string : null, bl ? null : string, string2);
        while (resultSet.next()) {
            String string3 = resultSet.getString(FKEY_DEF_NAME);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            linkedHashMap.put(string3.toUpperCase(), hashMap);
            hashMap.put(FKEY_DEF_NAME, string3);
        }
        resultSet.close();
        return linkedHashMap;
    }

    public Set<String> listDBTableIndexes(MetaTable metaTable, DatabaseMetaData databaseMetaData, List<MetaColumn> list) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)metaTable), databaseMetaData);
        String string2 = this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData);
        boolean bl = this.isCatalog();
        ResultSet resultSet = databaseMetaData.getIndexInfo(bl ? string : null, bl ? null : string, string2, false, false);
        while (resultSet.next()) {
            String string3 = resultSet.getString("INDEX_NAME");
            String string4 = resultSet.getString("COLUMN_NAME");
            boolean bl2 = false;
            if (string3 == null) continue;
            if (list != null) {
                for (MetaColumn metaColumn : list) {
                    String string5 = (String)metaColumn.get(MetaColumn.NAME);
                    if (!string5.toUpperCase().equals(string4.toUpperCase())) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) continue;
            hashSet.add(string3.toUpperCase());
        }
        resultSet.close();
        return hashSet;
    }

    private boolean isDialectTypeMySql() {
        return this.getDialect() instanceof MySqlDialect;
    }

    private boolean isDialectTypeMSSql() {
        return this.getDialect() instanceof MSSqlDialect;
    }
}

