/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.template;

import java.io.IOException;
import org.ujorm.Key;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.impl.ColumnWrapperImpl;
import org.ujorm.orm.impl.TableWrapperImpl;
import org.ujorm.orm.metaModel.MetaColumn;

public class AliasTable<UJO extends OrmUjo> {
    private final OrmHandler handler;
    private final TableWrapper table;

    public AliasTable(Class<UJO> clazz, String string, OrmHandler ormHandler) {
        this(new TableWrapperImpl(ormHandler.findTableModel(clazz), string), ormHandler);
    }

    protected AliasTable(TableWrapper tableWrapper, OrmHandler ormHandler) {
        this.handler = ormHandler;
        this.table = tableWrapper;
    }

    protected SqlDialect getDialect() {
        return this.table.getModel().getDatabase().getDialect();
    }

    public TableWrapper getTableModel() {
        return this.table;
    }

    public String table() throws IllegalStateException {
        try {
            StringBuilder stringBuilder = new StringBuilder(32);
            this.getDialect().printTableAliasDefinition(this.table, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getClass().getSimpleName(), iOException);
        }
    }

    public <T> String columnAs(String string, Key<UJO, T> key) throws IllegalStateException {
        return string + " AS " + key.getName();
    }

    public <T> String column(Key<UJO, T> key) throws IllegalStateException {
        return this.printColumn(this.findColumnModel(key), null, new StringBuilder(32)).toString();
    }

    public <T> String columnAs(Key<UJO, T> key) throws IllegalStateException {
        return this.columnAs(key, (CharSequence)null);
    }

    public <T> String columnAs(Key<UJO, T> key, CharSequence charSequence) throws IllegalStateException {
        return this.printColumn(this.findColumnModel(key), charSequence != null ? charSequence : key.getName(), new StringBuilder(64)).toString();
    }

    public String allColumns() throws IllegalStateException {
        return this.allColumns(false);
    }

    public String allColumns(boolean bl) throws IllegalStateException {
        StringBuilder stringBuilder = new StringBuilder(128);
        for (ColumnWrapper columnWrapper : this.table.getModel().getColumns()) {
            if (!columnWrapper.getModel().isColumn()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            this.printColumn(columnWrapper.getModel(), bl ? columnWrapper.getKey().getName() : null, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.table();
    }

    protected StringBuilder printColumn(MetaColumn metaColumn, CharSequence charSequence, StringBuilder stringBuilder) throws IllegalStateException {
        try {
            this.getDialect().printColumnAlias(new ColumnWrapperImpl(metaColumn, this.table.getAlias()), stringBuilder);
            if (charSequence != null) {
                stringBuilder.append(" AS ").append(charSequence);
            }
            return stringBuilder;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getClass().getSimpleName(), iOException);
        }
    }

    protected MetaColumn findColumnModel(Key<UJO, ?> key) throws IllegalArgumentException {
        return (MetaColumn)this.handler.findColumnModel(key, true);
    }

    public static <UJO extends OrmUjo> AliasTable<UJO> of(Class<UJO> clazz, String string, OrmHandler ormHandler) {
        return new AliasTable<UJO>(clazz, string, ormHandler);
    }

    public static <UJO extends OrmUjo> AliasTable<UJO> of(Class<UJO> clazz, OrmHandler ormHandler) {
        return new AliasTable<UJO>(ormHandler.findTableModel(clazz), ormHandler);
    }

    public static final class Build {
        public static final String PARAM = "?";
        private static final String NO_SEPARATOR = null;

        public static String SELECT(Object ... objectArray) {
            return "SELECT " + Build.toText(", ", objectArray);
        }

        public static String FROM(Object ... objectArray) {
            return " FROM " + Build.toText(", ", objectArray);
        }

        public static String INNER_JOIN(Object object, Object ... objectArray) {
            return " INNER JOIN " + object + " ON " + Build.toText(" ", objectArray) + " ";
        }

        public static String OUTER_JOIN(Object object, Object ... objectArray) {
            return " OUTER JOIN " + object + " ON " + Build.toText(" ", objectArray) + " ";
        }

        public static String WHERE(Object ... objectArray) {
            return " WHERE " + Build.toText(NO_SEPARATOR, objectArray);
        }

        public static String GROUP_BY(Object ... objectArray) {
            return " GROUP BY " + Build.toText(", ", objectArray);
        }

        public static String ORDER_BY(Object ... objectArray) {
            return " ORDER BY " + Build.toText(", ", objectArray);
        }

        public static String toText(String string, Object ... objectArray) {
            StringBuilder stringBuilder = new StringBuilder(256);
            for (Object object : objectArray) {
                if (string != null && stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(object);
            }
            return stringBuilder.toString();
        }
    }
}

