/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.UjoAction;
import org.ujorm.core.UjoManager;
import org.ujorm.extensions.Property;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.DbType;
import org.ujorm.orm.ITypeService;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlParameters;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaTable;

public class JdbcStatement {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(JdbcStatement.class);
    private final PreparedStatement ps;
    private final ITypeService typeService;
    private final int logValueLengthLimit;
    private int parameterPointer = 0;
    private StringBuilder values;
    private boolean logValues;

    public JdbcStatement(Connection connection, CharSequence charSequence, OrmHandler ormHandler) throws SQLException {
        this(connection.prepareStatement(((Object)charSequence).toString()), ormHandler);
    }

    public JdbcStatement(PreparedStatement preparedStatement, OrmHandler ormHandler) {
        this.ps = preparedStatement;
        this.typeService = ormHandler.getParameters().getConverter(null);
        this.logValues = LOGGER.isLoggable(UjoLogger.INFO);
        this.logValueLengthLimit = Math.max(10, (Integer)MetaParams.LOG_VALUE_LENGTH_LIMIT.of((Ujo)ormHandler.getParameters()));
        if (this.logValues) {
            this.values = new StringBuilder();
        }
    }

    public String getAssignedValues() {
        if (this.values != null && this.values.length() > 0) {
            return this.values.toString() + "]";
        }
        return "NONE";
    }

    public void close() throws SQLException {
        this.ps.close();
    }

    public void execute() throws SQLException {
        this.ps.execute();
    }

    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    public void assignValues(OrmUjo ormUjo) throws SQLException {
        MetaTable metaTable = ormUjo.readSession().getHandler().findTableModel(ormUjo.getClass());
        List list = MetaTable.COLUMNS.getList((Ujo)metaTable);
        this.assignValues(ormUjo, list);
    }

    public void assignValues(List<? extends OrmUjo> list, int n, int n2) throws SQLException {
        OrmUjo ormUjo = list.get(n);
        MetaTable metaTable = ormUjo.readSession().getHandler().findTableModel(ormUjo.getClass());
        List list2 = MetaTable.COLUMNS.getList((Ujo)metaTable);
        for (int i = n; i < n2; ++i) {
            this.assignValues(list.get(i), list2);
        }
    }

    public void assignValues(OrmUjo ormUjo, List<MetaColumn> list) throws SQLException {
        for (MetaColumn metaColumn : list) {
            if (metaColumn.isForeignKey()) {
                Key key = metaColumn.getKey();
                Object object = ormUjo != null ? key.of((Ujo)ormUjo) : null;
                this.assignValues((OrmUjo)object, metaColumn.getForeignColumns());
                continue;
            }
            if (!metaColumn.isColumn()) continue;
            this.assignValue(ormUjo, metaColumn);
        }
    }

    public final void assignValues(Query query) throws SQLException {
        if (query.getSqlParameters() != null) {
            this.assignExtendedValues(query);
        }
        this.assignValues(query.getDecoder());
    }

    public void assignExtendedValues(Query query) throws SQLException {
        SqlParameters sqlParameters = query.getSqlParameters();
        if (sqlParameters == null) {
            return;
        }
        int n = sqlParameters.getCount();
        for (int i = 0; i < n; ++i) {
            Object object = sqlParameters.getParameter(i);
            Class clazz = object != null ? object.getClass() : Void.class;
            Property property = Property.of((String)"[sqlParameter]", clazz);
            MetaColumn metaColumn = new MetaColumn(this.typeService);
            MetaColumn.TABLE.setValue((Ujo)metaColumn, (Object)query.getTableModel());
            MetaColumn.TABLE_KEY.setValue((Ujo)metaColumn, (Object)property);
            query.getTableModel().getDatabase().changeDbType(metaColumn);
            query.getTableModel().getDatabase().changeDbLength(metaColumn);
            metaColumn.initTypeCode();
            if (this.logValues) {
                String string = UjoManager.getInstance().encodeValue(object, false);
                this.logValue(string, (Key)property);
            }
            try {
                ++this.parameterPointer;
                metaColumn.getConverter().setValue(metaColumn, this.ps, object, this.parameterPointer);
                continue;
            }
            catch (Throwable throwable) {
                String string = UjoManager.getInstance().encodeValue(object, false);
                String string2 = String.format("table: %s, column %s, columnOffset: %d, value: %s", property.getType().getSimpleName(), metaColumn, this.parameterPointer, string);
                throw new IllegalStateException(string2, throwable);
            }
        }
    }

    public void assignValues(CriterionDecoder criterionDecoder) throws SQLException {
        int n = criterionDecoder.getColumnCount();
        for (int i = 0; i < n; ++i) {
            MetaColumn metaColumn = criterionDecoder.getColumn(i);
            Object object = criterionDecoder.getValueExtended(i);
            if (metaColumn.isForeignKey()) {
                Object object2;
                List<MetaColumn> list = metaColumn.getForeignColumns();
                if (object instanceof Object[]) {
                    object2 = (Object[])object;
                    Object[] objectArray = new Object[((Object[])object2).length];
                    MetaColumn metaColumn2 = list.get(0);
                    boolean bl = ((Object[])object2).length > 0 && object2[0] instanceof OrmUjo;
                    for (int j = 0; j < ((Object[])object2).length; ++j) {
                        Object object3 = object2[j];
                        if (bl) {
                            Object object4;
                            OrmUjo ormUjo = (OrmUjo)object3;
                            objectArray[j] = object4 = metaColumn2.getValue(ormUjo);
                            continue;
                        }
                        objectArray[j] = object3;
                    }
                    this.assignValue(metaColumn2, objectArray, null);
                    continue;
                }
                if (object instanceof OrmUjo) {
                    object2 = (OrmUjo)object;
                    for (MetaColumn metaColumn2 : list) {
                        Object object5 = metaColumn2.getValue((OrmUjo)object2);
                        this.assignValue(metaColumn2, object5, (OrmUjo)object2);
                    }
                    continue;
                }
                assert (metaColumn.getKey().getType().isInstance(object));
                this.assignValue(metaColumn, object, null);
                continue;
            }
            this.assignValue(metaColumn, object, null);
        }
    }

    public void assignValue(OrmUjo ormUjo, MetaColumn metaColumn) throws SQLException {
        Key key = metaColumn.getKey();
        Object object = ormUjo != null ? key.of((Ujo)ormUjo) : null;
        this.assignValue(metaColumn, object, ormUjo);
    }

    public void assignValue(MetaColumn metaColumn, Object object, OrmUjo ormUjo) throws SQLException {
        Key key = metaColumn.getKey();
        if (this.logValues) {
            if (ormUjo != null) {
                this.logValue(ormUjo, key);
            } else {
                String object2 = object instanceof Object[] ? this.arrayToString((Object[])object) : UjoManager.getInstance().encodeValue(object, false);
                this.logValue(object2, key);
            }
        }
        try {
            if (object instanceof Object[]) {
                for (Object object2 : (Object[])object) {
                    ++this.parameterPointer;
                    metaColumn.getConverter().setValue(metaColumn, this.ps, object2, this.parameterPointer);
                }
            } else {
                ++this.parameterPointer;
                metaColumn.getConverter().setValue(metaColumn, this.ps, object, this.parameterPointer);
            }
        }
        catch (Throwable throwable) {
            String string = ormUjo != null ? UjoManager.getInstance().getText((Ujo)ormUjo, key, UjoAction.DUMMY) : UjoManager.getInstance().encodeValue(object, false);
            String string2 = String.format("table: %s, column %s, columnOffset: %d, value: %s", ormUjo != null ? ormUjo.getClass().getSimpleName() : "null", metaColumn, this.parameterPointer, string);
            throw new IllegalStateException(string2, throwable);
        }
    }

    public void assignValues(DbProcedure dbProcedure) {
        CallableStatement callableStatement = (CallableStatement)this.ps;
        MetaProcedure metaProcedure = dbProcedure.metaProcedure();
        Object object = null;
        for (MetaColumn metaColumn : MetaProcedure.PARAMETERS.getList((Ujo)metaProcedure)) {
            String string;
            Key key = metaColumn.getKey();
            if (key.isTypeOf(Void.class)) continue;
            try {
                ++this.parameterPointer;
                int n = ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))).getSqlType();
                if (metaProcedure.isInput(metaColumn)) {
                    object = key.of((Ujo)dbProcedure);
                    metaColumn.getConverter().setValue(metaColumn, callableStatement, object, this.parameterPointer);
                    if (this.logValues) {
                        string = UjoManager.getInstance().encodeValue(object, false);
                        this.logValue(string, key);
                    }
                }
                if (!metaProcedure.isOutput(metaColumn)) continue;
                callableStatement.registerOutParameter(this.parameterPointer, n);
            }
            catch (Throwable throwable) {
                string = dbProcedure != null ? UjoManager.getInstance().getText((Ujo)dbProcedure, key, UjoAction.DUMMY) : UjoManager.getInstance().encodeValue(object, false);
                String string2 = String.format("table: %s, column %s, columnOffset: %d, value: %s", dbProcedure != null ? ((Object)((Object)dbProcedure)).getClass().getSimpleName() : "null", key, this.parameterPointer, string);
                throw new IllegalStateException(string2, throwable);
            }
        }
    }

    public void loadValues(DbProcedure dbProcedure) {
        CallableStatement callableStatement = (CallableStatement)this.ps;
        MetaProcedure metaProcedure = dbProcedure.metaProcedure();
        int n = 0;
        try {
            for (MetaColumn metaColumn : MetaProcedure.PARAMETERS.getList((Ujo)metaProcedure)) {
                if (metaProcedure.isOutput(metaColumn)) {
                    Object j = metaColumn.getConverter().getValue(metaColumn, callableStatement, ++n);
                    metaColumn.setValue((Ujo)dbProcedure, j);
                    continue;
                }
                if (!metaProcedure.isInput(metaColumn)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Procedure: " + (Object)((Object)dbProcedure), exception);
        }
    }

    protected void logValue(Ujo ujo, Key key) {
        String string = UjoManager.getInstance().getText(ujo, key, UjoAction.DUMMY);
        this.logValue(string, key);
    }

    protected void logValue(String string, Key key) {
        boolean bl = key.isTypeOf(CharSequence.class) || key.isTypeOf(Date.class);
        String string2 = bl ? "'" : "";
        this.values.append(this.parameterPointer == 0 ? "[" : ", ");
        this.values.append(string2);
        if (string != null && string.length() > this.logValueLengthLimit) {
            this.values.append(string.subSequence(0, this.logValueLengthLimit));
            this.values.append("...[");
            this.values.append(string.length());
            this.values.append(this.logValueLengthLimit < 20 ? "]" : " total characters]");
        } else {
            this.values.append(string);
        }
        this.values.append(string2);
    }

    PreparedStatement getPreparedStatement() {
        return this.ps;
    }

    private String arrayToString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder(128);
        int n = Math.min(3, objectArray.length);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(stringBuilder.length() == 0 ? (char)'[' : ',');
            stringBuilder.append(objectArray[i]);
        }
        if (n < objectArray.length) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.ps != null) {
            return this.ps.toString();
        }
        return super.toString();
    }
}

