/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAResource;
import org.ujorm.Ujo;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaDatabase;

public final class Transaction
implements javax.transaction.Transaction {
    private final Session session;
    private final Transaction parent;
    private final Savepoint[] savepoints;
    private int status;
    private boolean rollbackOnly;

    Transaction(Session session, Transaction transaction) {
        this.session = session;
        this.parent = transaction;
        this.status = 0;
        this.savepoints = new Savepoint[session.getHandler().getDatabases().size()];
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    void assignSavepoint(MetaDatabase metaDatabase, Connection connection) throws IllegalStateException {
        int n = (Integer)MetaDatabase.ORDER.of((Ujo)metaDatabase);
        if (this.savepoints[n] == null) {
            if (this.parent != null) {
                this.parent.assignSavepoint(metaDatabase, connection);
            }
            try {
                this.savepoints[n] = connection.setSavepoint();
                this.status = 0;
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException("Cant save Savepoint", sQLException);
            }
        }
    }

    public void commit() throws IllegalStateException {
        if (this.status != 0 || this.rollbackOnly) {
            if (this.rollbackOnly) {
                throw new SecurityException("Transaction have got status ROLLBACK_ONLY");
            }
            throw new IllegalStateException("Transact\u00edon state isn't STATUS_ACTIVE, but " + this.status);
        }
        this.status = 3;
        this.session.commit(true, this);
    }

    public void rollback() throws IllegalStateException {
        if (this.status != 0) {
            throw new IllegalStateException("Transact\u00edon state isn't STATUS_ACTIVE, but " + this.status);
        }
        this.status = 4;
        this.session.commit(false, this);
    }

    public Transaction nestedTransaction() {
        return this.session.beginTransaction();
    }

    public Session getSession() {
        return this.session;
    }

    Transaction getParent() {
        return this.parent;
    }

    Savepoint[] getSavepoints() {
        return this.savepoints;
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean enlistResource(XAResource xAResource) throws IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerSynchronization(Synchronization synchronization) throws IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public int getStatus() {
        return this.status;
    }
}

