/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoManager;
import org.ujorm.criterion.BinaryCriterion;
import org.ujorm.criterion.Criterion;
import org.ujorm.criterion.Operator;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.orm.AliasKey;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.metaModel.MoreParams;

public class CriterionDecoder {
    protected final OrmHandler handler;
    protected final SqlDialect dialect;
    protected final Criterion criterion;
    protected final List<Key> orderBy;
    protected final StringBuilder sql;
    protected final List<ValueCriterion> values;
    protected final List<ValueCriterion> nullValues;
    protected final Set<TableWrapper> tables;
    protected final MetaTable baseTable;
    protected final boolean printAllJoinedTables;

    public CriterionDecoder(Criterion criterion, MetaTable metaTable) {
        this(criterion, metaTable, null);
    }

    public CriterionDecoder(Criterion criterion, MetaTable metaTable, List<Key> list) {
        MetaDatabase metaDatabase = metaTable.getDatabase();
        this.baseTable = metaTable;
        this.criterion = criterion;
        this.dialect = metaDatabase.getDialect();
        this.orderBy = list;
        this.handler = metaDatabase.getOrmHandler();
        this.sql = new StringBuilder(64);
        this.values = new ArrayList<ValueCriterion>();
        this.nullValues = new ArrayList<ValueCriterion>();
        this.tables = new LinkedHashSet<TableWrapper>();
        this.tables.add(metaTable);
        this.printAllJoinedTables = (Boolean)MetaParams.MORE_PARAMS.add(MoreParams.PRINT_All_JOINED_TABLES).of((Ujo)this.handler.getParameters());
        if (this.criterion != null) {
            this.unpack(this.criterion);
        }
        if (this.criterion != null || this.orderBy != null) {
            this.writeRelations();
        }
    }

    protected void unpack(Criterion criterion) {
        if (criterion.isBinary()) {
            this.unpackBinary((BinaryCriterion)criterion);
        } else {
            try {
                ValueCriterion valueCriterion = (ValueCriterion)criterion;
                ValueCriterion valueCriterion2 = this.dialect.printCriterion(valueCriterion, this.sql);
                if (valueCriterion2 != null) {
                    this.values.add(valueCriterion2);
                } else {
                    this.nullValues.add(valueCriterion);
                }
            }
            catch (IOException | RuntimeException exception) {
                throw new IllegalUjormException("Unpack failed for criterion: " + criterion, (Throwable)exception);
            }
        }
    }

    private void unpackBinary(BinaryCriterion binaryCriterion) {
        boolean bl = false;
        switch (binaryCriterion.getOperator()) {
            case OR: {
                bl = true;
            }
            case AND: {
                if (bl) {
                    this.sql.append(" (");
                }
                this.unpack(binaryCriterion.getLeftNode());
                this.sql.append(' ');
                this.sql.append(binaryCriterion.getOperator().name());
                this.sql.append(' ');
                this.unpack(binaryCriterion.getRightNode());
                if (!bl) break;
                this.sql.append(") ");
                break;
            }
            case NOT: {
                this.sql.append(' ');
                this.sql.append(binaryCriterion.getOperator().name());
                this.sql.append(" (");
                this.unpack(binaryCriterion.getRightNode());
                this.sql.append(") ");
                break;
            }
            default: {
                String string = "Operator is not supported in the SQL statement: " + binaryCriterion.getOperator();
                throw new UnsupportedOperationException(string);
            }
        }
    }

    public int getColumnCount() {
        return this.values.size();
    }

    public MetaColumn getColumn(int n) throws IllegalArgumentException {
        Key key = this.values.get(n).getLeftNode();
        MetaColumn metaColumn = (MetaColumn)this.handler.findColumnModel(key, true);
        return metaColumn;
    }

    public Operator getOperator(int n) {
        Operator operator = this.values.get(n).getOperator();
        return operator;
    }

    public Object getValue(int n) {
        Object object = this.values.get(n).getRightNode();
        return object;
    }

    public Object getValueExtended(int n) {
        ValueCriterion valueCriterion = this.values.get(n);
        Object object = valueCriterion.getRightNode();
        if (object == null) {
            return object;
        }
        if (valueCriterion.isInsensitive()) {
            object = object.toString().toLowerCase();
        }
        switch (valueCriterion.getOperator()) {
            case CONTAINS: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "%" + object + "%";
            }
            case STARTS: 
            case STARTS_CASE_INSENSITIVE: {
                return object + "%";
            }
            case ENDS: 
            case ENDS_CASE_INSENSITIVE: {
                return "%" + object;
            }
        }
        return object;
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public String getWhere() {
        return this.sql.toString();
    }

    public boolean isEmpty() {
        return this.sql.length() == 0;
    }

    public Key getBaseProperty() {
        Key key = null;
        for (ValueCriterion valueCriterion : this.values) {
            if (valueCriterion.getLeftNode() == null) continue;
            key = valueCriterion.getLeftNode();
            break;
        }
        while (UjoManager.isCompositeKey(key)) {
            key = ((CompositeKey)key).getFirstKey();
        }
        return key;
    }

    protected void writeRelations() {
        boolean bl;
        Collection<AliasKey> collection = this.getPropertyRelations();
        boolean bl2 = bl = this.sql.length() > 0 && !collection.isEmpty();
        if (bl) {
            this.sql.append(" AND (");
        }
        boolean bl3 = false;
        for (AliasKey aliasKey : collection) {
            try {
                ColumnWrapper columnWrapper = aliasKey.getColumn(this.handler);
                MetaTable metaTable = columnWrapper.getModel().getTable();
                ColumnWrapper columnWrapper2 = columnWrapper.getModel().getForeignColumns().get(0).addTableAlias(aliasKey.aliasTo);
                MetaTable metaTable2 = columnWrapper2.getModel().getTable();
                this.tables.add(metaTable.addAlias(aliasKey.getAliasFrom()));
                this.tables.add(metaTable2.addAlias(aliasKey.getAliasTo()));
                if (bl3) {
                    this.sql.append(" AND ");
                } else {
                    bl3 = true;
                }
                this.dialect.printColumnAlias(columnWrapper, this.sql);
                this.sql.append(" = ");
                this.dialect.printColumnAlias(columnWrapper2, this.sql);
            }
            catch (IOException iOException) {
                throw new IllegalUjormException(iOException.getMessage(), (Throwable)iOException);
            }
        }
        if (bl) {
            this.sql.append(")");
        }
    }

    protected Collection<AliasKey> getPropertyRelations() {
        LinkedHashSet<AliasKey> linkedHashSet = new LinkedHashSet<AliasKey>();
        ArrayList<ValueCriterion> arrayList = new ArrayList<ValueCriterion>(this.values.size() + this.nullValues.size());
        arrayList.addAll(this.values);
        arrayList.addAll(this.nullValues);
        for (ValueCriterion valueCriterion : arrayList) {
            Key key = valueCriterion.getLeftNode();
            if (key == null) continue;
            AliasKey.addRelations(key, linkedHashSet);
            Object object = valueCriterion.getRightNode();
            if (!(object instanceof CompositeKey)) continue;
            AliasKey.addRelations((CompositeKey)object, linkedHashSet);
        }
        if (this.orderBy != null) {
            for (Key key : this.orderBy) {
                AliasKey.addRelations((CompositeKey)key, linkedHashSet);
            }
        }
        return linkedHashSet;
    }

    public MetaTable getBaseTable() {
        return this.baseTable;
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public TableWrapper[] getTables() {
        if (this.printAllJoinedTables) {
            HashSet<TableWrapper> hashSet = new HashSet<TableWrapper>();
            hashSet.addAll(this.tables);
            ArrayList<ValueCriterion> arrayList = new ArrayList<ValueCriterion>(this.values.size() + this.nullValues.size());
            arrayList.addAll(this.values);
            arrayList.addAll(this.nullValues);
            for (ValueCriterion valueCriterion : arrayList) {
                TableWrapper tableWrapper;
                Key key = valueCriterion.getLeftNode();
                Object object = valueCriterion.getRightNode();
                if (key instanceof Key) {
                    tableWrapper = this.handler.findTableModel(key);
                    hashSet.add(tableWrapper);
                }
                if (!(object instanceof Key)) continue;
                tableWrapper = this.handler.findTableModel((Key)object);
                hashSet.add(tableWrapper);
            }
            return hashSet.toArray(new TableWrapper[hashSet.size()]);
        }
        return this.tables.toArray(new TableWrapper[this.tables.size()]);
    }

    public TableWrapper[] getTablesSorted() {
        TableWrapper[] tableWrapperArray = this.getTables();
        if (tableWrapperArray.length > 1 && tableWrapperArray[0] != this.baseTable) {
            for (int i = tableWrapperArray.length - 1; i >= 1; --i) {
                if (tableWrapperArray[i] != this.baseTable) continue;
                tableWrapperArray[i] = tableWrapperArray[0];
                tableWrapperArray[0] = this.baseTable;
            }
        }
        return tableWrapperArray;
    }

    public OrmHandler getHandler() {
        return this.handler;
    }

    public String toString() {
        return this.criterion != null ? this.criterion.toString() : null;
    }
}

