/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoIterator;
import org.ujorm.criterion.Criterion;
import org.ujorm.implementation.orm.OrmTable;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlParameters;
import org.ujorm.orm.impl.ColumnWrapperImpl;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.utility.OrmTools;

public class Query<UJO extends OrmUjo>
implements Iterable<UJO> {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(Query.class);
    private final MetaTable table;
    private ArrayList<ColumnWrapper> columns;
    private Session session;
    private Criterion<UJO> criterion;
    private boolean distinct;
    private CriterionDecoder decoder;
    private String statementInfo;
    private List<Key<UJO, ?>> orderBy;
    private Set<ColumnWrapper> outerJoins;
    private long offset = 0L;
    private int limit = -1;
    private int fetchSize = -1;
    private boolean lockRequest;
    private SqlParameters sqlParameters;
    static final Comparator<Key> INNER_KEY_COMPARATOR = new Comparator<Key>(){

        @Override
        public int compare(Key key, Key key2) {
            if (!key.isComposite()) {
                return key2.isComposite() ? -1 : 0;
            }
            if (key2.isComposite()) {
                int n;
                int n2 = ((CompositeKey)key).getCompositeCount();
                return n2 == (n = ((CompositeKey)key2).getCompositeCount()) ? 0 : (n2 < n ? -1 : 1);
            }
            return 1;
        }
    };

    public Query(MetaTable metaTable, Criterion<UJO> criterion, Session session) {
        this.table = metaTable;
        this.columns = null;
        this.criterion = criterion;
        this.session = session;
        this.orderByMany(new Key[0]);
    }

    public Query(MetaTable metaTable, Criterion<UJO> criterion) {
        this(metaTable, criterion, null);
    }

    private OrmHandler getHandler() {
        OrmHandler ormHandler = null;
        if (this.table != null) {
            ormHandler = this.table.getDatabase().getOrmHandler();
        } else if (this.session != null) {
            ormHandler = this.session.getHandler();
        }
        if (ormHandler == null) {
            throw new IllegalUjormException("The base class must be assigned first!");
        }
        return ormHandler;
    }

    public Query<UJO> setSession(Session session) {
        this.session = session;
        return this;
    }

    public long getLimitedCount() {
        long l = this.getCount();
        if (this.isOffset() && (l -= this.offset) < 0L) {
            l = 0L;
        }
        if (this.limit >= 0 && (long)this.limit < l) {
            l = this.limit;
        }
        return l;
    }

    public long getCount() {
        long l = this.session.getRowCount(this);
        return l;
    }

    public <ITEM> void setParameter(Key<UJO, ITEM> key, ITEM ITEM) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void addCriterion(Criterion<UJO> criterion) throws IllegalArgumentException {
        if (criterion == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.criterion = this.criterion != null ? this.criterion.and(criterion) : criterion;
        this.clearDecoder();
    }

    public Query<UJO> setCriterion(Criterion<UJO> criterion) {
        this.criterion = criterion != null ? criterion : Criterion.where((boolean)true);
        this.clearDecoder();
        return this;
    }

    public Criterion<UJO> getCriterion() {
        return this.criterion;
    }

    public final CriterionDecoder getDecoder() {
        if (this.decoder == null) {
            ArrayList<Key> arrayList = new ArrayList<Key>(16);
            for (Key<UJO, ?> object : this.orderBy) {
                if (!object.isComposite()) continue;
                arrayList.add(object);
            }
            for (ColumnWrapper columnWrapper : this.getColumns()) {
                if (!columnWrapper.isCompositeKey()) continue;
                arrayList.add(columnWrapper.getKey());
            }
            this.decoder = new CriterionDecoder(this.criterion, this.table, arrayList);
        }
        return this.decoder;
    }

    private void clearDecoder() {
        this.setDecoder(null);
    }

    void setDecoder(CriterionDecoder criterionDecoder) {
        this.decoder = criterionDecoder;
        this.statementInfo = null;
    }

    public Session getSession() {
        return this.session;
    }

    public MetaTable getTableModel() {
        return this.table;
    }

    public List<ColumnWrapper> getColumns() {
        return this.columns != null ? this.columns : this.getDefaultColumns();
    }

    protected List<ColumnWrapper> getDefaultColumns() {
        return MetaTable.COLUMNS.getList((Ujo)this.table);
    }

    public ColumnWrapper[] getColumnArray() {
        List<ColumnWrapper> list = this.getColumns();
        ColumnWrapper[] columnWrapperArray = list.toArray(new ColumnWrapper[list.size()]);
        return columnWrapperArray;
    }

    @Override
    public UjoIterator<UJO> iterator() {
        UjoIterator ujoIterator = UjoIterator.of(this);
        return ujoIterator;
    }

    @Deprecated
    public final UjoIterator<UJO> iterate() {
        return this.iterator();
    }

    public List<UJO> list() {
        return ((UjoIterator)this.iterator()).toList();
    }

    public <T> Map<T, UJO> map() {
        return this.map(this.table.getFirstPK().getKey(), new HashMap(128));
    }

    public <T> Map<T, UJO> map(Key<UJO, T> key, Map<T, UJO> map) {
        Iterator iterator = ((UjoIterator)this.iterator()).iterator();
        while (iterator.hasNext()) {
            OrmUjo ormUjo = (OrmUjo)iterator.next();
            map.put(key.of((Ujo)ormUjo), ormUjo);
        }
        return map;
    }

    public List<UJO> list(int n) {
        switch (n) {
            case 0: {
                return this.list();
            }
            case 1: {
                return OrmTools.loadLazyValuesAsBatch(this);
            }
        }
        throw new IllegalArgumentException("The method supports only two values 0 and 1 in the current release");
    }

    public UJO uniqueResult() throws NoSuchElementException {
        Iterator iterator = this.iterator();
        if (!((UjoIterator)iterator).hasNext()) {
            return null;
        }
        OrmUjo ormUjo = (OrmUjo)((UjoIterator)iterator).next();
        if (((UjoIterator)iterator).hasNext()) {
            ((UjoIterator)iterator).close();
            throw new NoSuchElementException("Result is not unique for: " + this.criterion);
        }
        return (UJO)ormUjo;
    }

    public boolean exists() {
        int n = this.limit;
        this.limit = 1;
        Iterator iterator = this.iterator();
        boolean bl = ((UjoIterator)iterator).hasNext();
        ((UjoIterator)iterator).close();
        this.limit = n;
        return bl;
    }

    public final List<Key<UJO, ?>> getOrderBy() {
        return this.orderBy;
    }

    public final Key<UJO, ?>[] getOrderAsArray() {
        return this.orderBy.toArray(new Key[this.orderBy.size()]);
    }

    @Deprecated
    public Query<UJO> setOrder(Key ... keyArray) {
        return this.orderByMany(keyArray);
    }

    public Query<UJO> orderBy(Key<UJO, ?> key) {
        return this.orderByMany(key);
    }

    public Query<UJO> orderBy(Key<UJO, ?> key, Key<UJO, ?> key2) {
        return this.orderByMany(key, key2);
    }

    public Query<UJO> orderBy(Key<UJO, ?> key, Key<UJO, ?> key2, Key<UJO, ?> key3) {
        return this.orderByMany(key, key2, key3);
    }

    public final Query<UJO> orderByMany(Key ... keyArray) {
        this.clearDecoder();
        this.orderBy = new ArrayList(Math.max(keyArray.length, 4));
        for (Key key : keyArray) {
            this.orderBy.add(key);
        }
        return this;
    }

    public Query<UJO> addColumn(Key<UJO, ?> key) throws IllegalArgumentException {
        ColumnWrapper columnWrapper;
        this.clearDecoder();
        MetaColumn metaColumn = (MetaColumn)this.getHandler().findColumnModel(this.getLastProperty(key));
        if (metaColumn == null) {
            throw new IllegalArgumentException("Column " + key.getFullName() + " was not foud in the meta-model");
        }
        ColumnWrapper columnWrapper2 = columnWrapper = key.isComposite() ? new ColumnWrapperImpl(metaColumn, key) : metaColumn;
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnWrapper>(this.getDefaultColumns());
        }
        this.addMissingColumn(columnWrapper, true, true);
        return this;
    }

    public Query<UJO> setColumn(Key<UJO, ?> key) throws IllegalArgumentException {
        return this.setColumns(false, key);
    }

    public final Query<UJO> setColumns(boolean bl, Key ... keyArray) throws IllegalArgumentException {
        return this.setColumns(bl, true, keyArray);
    }

    public final Query<UJO> setColumns(Collection<ColumnWrapper> collection) throws IllegalArgumentException {
        this.clearDecoder();
        this.columns = new ArrayList<ColumnWrapper>(collection);
        return this;
    }

    public final Query<UJO> setColumns(boolean bl, boolean bl2, Key<UJO, ?> ... keyArray) throws IllegalArgumentException {
        this.clearDecoder();
        if (keyArray.length > 1) {
            Arrays.sort(keyArray, INNER_KEY_COMPARATOR);
        }
        this.columns = new ArrayList(keyArray.length + 3);
        OrmHandler ormHandler = this.getHandler();
        for (Key<UJO, ?> key : keyArray) {
            MetaColumn metaColumn = (MetaColumn)ormHandler.findColumnModel(this.getLastProperty(key), true);
            ColumnWrapper columnWrapper = key.isComposite() ? new ColumnWrapperImpl(metaColumn, key) : metaColumn;
            this.addMissingColumn(columnWrapper, bl2, false);
        }
        if (bl) {
            this.addMissingColumn(this.table.getFirstPK(), false, true);
        }
        return this;
    }

    protected void addMissingColumn(ColumnWrapper columnWrapper, boolean bl, boolean bl2) {
        int n = columnWrapper.hashCode();
        MetaColumn metaColumn = columnWrapper.getModel();
        if (bl2 && !metaColumn.isForeignKey()) {
            for (ColumnWrapper columnWrapper2 : this.columns) {
                if (columnWrapper2.hashCode() != n || !columnWrapper.equals(columnWrapper2)) continue;
                return;
            }
        }
        if (bl) {
            if (metaColumn.isForeignKey()) {
                for (ColumnWrapper columnWrapper2 : metaColumn.getForeignTable().getColumns()) {
                    CompositeKey compositeKey = columnWrapper.getKey().add(columnWrapper2.getKey());
                    ColumnWrapperImpl columnWrapperImpl = new ColumnWrapperImpl(columnWrapper2.getModel(), (Key)compositeKey);
                    this.addMissingColumn(columnWrapperImpl, false, true);
                }
            } else {
                this.columns.add(columnWrapper);
            }
        } else {
            this.columns.add(columnWrapper);
        }
    }

    private Key getLastProperty(Key<UJO, ?> key) {
        return key.isComposite() ? ((CompositeKey)key).getLastKey() : key;
    }

    public Query<UJO> orderBy(Collection<Key<UJO, ?>> collection) {
        this.clearDecoder();
        if (collection == null) {
            return this.orderByMany(new Key[0]);
        }
        this.orderBy.clear();
        this.orderBy.addAll(collection);
        return this;
    }

    public Query<UJO> addOrderBy(Key<UJO, ?> ... keyArray) {
        this.clearDecoder();
        for (Key<UJO, ?> key : keyArray) {
            this.orderBy.add(key);
        }
        return this;
    }

    public Query<UJO> addOrderBy(Key<UJO, ?> key) {
        this.clearDecoder();
        this.orderBy.add(key);
        return this;
    }

    public ColumnWrapper readOrderColumn(int n) throws IllegalUjormException {
        Key<UJO, ?> key = this.orderBy.get(n);
        Object t = this.session.getHandler().findColumnModel(key);
        if (t instanceof MetaColumn) {
            return key.isComposite() ? new ColumnWrapperImpl((MetaColumn)t, key) : (MetaColumn)t;
        }
        String string = String.format("The key '%s.%s' is not persistent table column", this.table.getType().getSimpleName(), key);
        throw new IllegalUjormException(string);
    }

    public boolean addOuterJoin(Key<UJO, ? extends OrmTable> key) throws IllegalArgumentException {
        ColumnWrapper columnWrapper;
        if (this.outerJoins == null) {
            this.outerJoins = new HashSet<ColumnWrapper>();
        }
        MetaColumn metaColumn = (MetaColumn)this.getHandler().findColumnModel(key, true);
        ColumnWrapper columnWrapper2 = columnWrapper = key.isComposite() ? new ColumnWrapperImpl(metaColumn, key) : metaColumn;
        if (metaColumn.isMandatory()) {
            LOGGER.log(UjoLogger.WARN, "The relation is required: " + key);
        }
        return this.outerJoins.add(columnWrapper);
    }

    public Set<ColumnWrapper> getOuterJoins() {
        return this.outerJoins != null ? this.outerJoins : Collections.emptySet();
    }

    public boolean isOffset() {
        return this.offset > 0L;
    }

    public final long getOffset() {
        return this.offset;
    }

    public Query<UJO> setOffset(int n) {
        this.offset = n;
        return this;
    }

    public final boolean isLimit() {
        return this.limit > 0;
    }

    public final int getLimit() {
        return this.limit;
    }

    public Query<UJO> setLimit(int n) {
        this.limit = n;
        return this;
    }

    public Query<UJO> setLimit(int n, long l) {
        this.limit = n;
        this.offset = l;
        return this;
    }

    @Deprecated
    public final Query<UJO> setMaxRows(int n) {
        return this.setLimit(n);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Query<UJO> setFetchSize(int n) {
        this.fetchSize = n;
        return this;
    }

    public PreparedStatement getStatement() {
        return this.session.getStatement(this).getPreparedStatement();
    }

    public String getStatementInfo() {
        return this.statementInfo;
    }

    void setStatementInfo(String string) {
        this.statementInfo = string;
    }

    public boolean isLockRequest() {
        return this.lockRequest;
    }

    public Query<UJO> setLockRequest(boolean bl) {
        this.lockRequest = bl;
        return this;
    }

    public Query<UJO> setLockRequest() {
        return this.setLockRequest(true);
    }

    public String toString() {
        if (this.statementInfo != null) {
            return this.statementInfo;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        if (this.table != null) {
            stringBuilder.append('(').append(this.table.getType().getSimpleName()).append(") ");
        }
        if (this.criterion != null) {
            stringBuilder.append(" criterion: ");
            stringBuilder.append(this.criterion);
        }
        if (this.orderBy != null && this.orderBy.size() > 0) {
            stringBuilder.append(" | ordered by: ");
            for (Key<UJO, ?> key : this.orderBy) {
                stringBuilder.append((CharSequence)key).append(' ').append(key.isAscending() ? "ASC" : "DESC").append(", ");
            }
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : super.toString();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Query<UJO> setDistinct(boolean bl) {
        this.distinct = bl;
        return this;
    }

    public Query<UJO> setDistinct() {
        return this.setDistinct(true);
    }

    public SqlParameters getSqlParameters() {
        return this.sqlParameters;
    }

    public Query<UJO> setSqlParameters(SqlParameters sqlParameters) throws IllegalArgumentException {
        this.sqlParameters = sqlParameters;
        return this;
    }

    public Query<UJO> setSqlParameters(Object ... objectArray) throws IllegalArgumentException {
        return this.setSqlParameters(new SqlParameters(objectArray));
    }
}

