/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.SeqTableModel;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.SqlNameProvider;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaTable;

public class SqlDialectEx {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(SqlDialectEx.class);
    protected final SqlDialect dialect;

    public SqlDialectEx(SqlDialect sqlDialect) {
        this.dialect = sqlDialect;
    }

    public Appendable printDropIndex(MetaIndex metaIndex, Appendable appendable) throws IOException {
        appendable.append("DROP INDEX ");
        appendable.append((CharSequence)MetaIndex.NAME.of((Ujo)metaIndex));
        appendable.append(" ON ");
        this.dialect.printFullTableName((MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex), appendable);
        return appendable;
    }

    public Appendable printPrimaryKey(MetaColumn metaColumn, StringBuilder stringBuilder) throws Exception {
        stringBuilder.append("ALTER TABLE ");
        this.dialect.printFullTableName(metaColumn.getTable(), stringBuilder);
        stringBuilder.append(" ADD ");
        this.printPrimaryKeyConstraint(metaColumn.getTable(), Arrays.asList(metaColumn), stringBuilder);
        return stringBuilder;
    }

    public String buildConstraintName(MetaColumn metaColumn, MetaTable metaTable) {
        String string = metaColumn.getConstraintName();
        if (this.dialect.isFilled(string)) {
            return string;
        }
        return this.getNameProvider().buildDefaultConstraintName(metaTable, metaColumn);
    }

    public String buildPrimaryKeyOverColumn(MetaTable metaTable, List<MetaColumn> list) throws IOException {
        String string = "";
        String string2 = "";
        for (MetaColumn metaColumn : list) {
            String string3 = metaColumn.getName();
            string = string + string2;
            string = string + string3;
            string2 = ",";
        }
        return string;
    }

    public Appendable printUniqueConstraint(List<MetaColumn> list, StringBuilder stringBuilder) throws IOException {
        return this.printUniqueConstraint(stringBuilder, list.toArray(new MetaColumn[0]));
    }

    public Appendable printUniqueConstraint(StringBuilder stringBuilder, MetaColumn ... metaColumnArray) throws IOException {
        assert (metaColumnArray.length > 0);
        MetaTable metaTable = metaColumnArray[0].getTable();
        stringBuilder.append("ALTER TABLE ");
        this.dialect.printFullTableName(metaTable, stringBuilder);
        stringBuilder.append(" ADD CONSTRAINT ");
        stringBuilder.append(this.getNameProvider().getUniqueConstraintName(metaColumnArray));
        stringBuilder.append(" UNIQUE (");
        String string = "";
        for (MetaColumn metaColumn : metaColumnArray) {
            stringBuilder.append(string);
            this.dialect.printQuotedName(metaColumn.getName(), stringBuilder);
            string = ",";
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    protected void printPrimaryKeyConstraint(MetaTable metaTable, List<MetaColumn> list, Appendable appendable) throws IOException {
        appendable.append(" CONSTRAINT ");
        String string = this.getNameProvider().buildPrimaryKeyName(metaTable, list);
        appendable.append(string);
        appendable.append(" PRIMARY KEY ");
        String string2 = this.buildPrimaryKeyOverColumn(metaTable, list);
        appendable.append("(");
        this.dialect.printQuotedName(string2, appendable);
        appendable.append(")");
    }

    public Appendable printSequenceNextValueWithValues(UjoSequencer ujoSequencer, long l, Appendable appendable) throws IOException {
        appendable.append("UPDATE ");
        this.dialect.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" SET ");
        this.dialect.printQuotedNameAlways(this.dialect.getSeqTableModel().getSequence(), appendable);
        appendable.append("=" + l);
        appendable.append(" WHERE ");
        this.dialect.printQuotedNameAlways(this.dialect.getSeqTableModel().getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    public Appendable printSequenceListAllId(UjoSequencer ujoSequencer, Appendable appendable) throws IOException {
        SeqTableModel seqTableModel = this.dialect.getSeqTableModel();
        appendable.append("SELECT ");
        this.dialect.printQuotedNameAlways(seqTableModel.getId(), appendable);
        appendable.append(" FROM ");
        this.dialect.printSequenceTableName(ujoSequencer, appendable);
        return appendable;
    }

    protected final SqlNameProvider getNameProvider() throws IllegalStateException {
        return this.dialect.getNameProvider();
    }
}

