/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.annot.Transient;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.ITypeService;
import org.ujorm.orm.InitializationBatch;
import org.ujorm.orm.SqlNameProvider;
import org.ujorm.orm.TypeService;
import org.ujorm.orm.ao.CachePolicy;
import org.ujorm.orm.ao.CheckReport;
import org.ujorm.orm.ao.CommentPolicy;
import org.ujorm.orm.ao.IndexModelBuilder;
import org.ujorm.orm.ao.LazyLoading;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.metaModel.MetaDbService;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.metaModel.MoreParams;

public final class MetaParams
extends AbstractMetaModel {
    private static final Class<MetaParams> CLASS = MetaParams.class;
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(CLASS);
    private static final String INSTANCE_FAILED_MSG = "Instance of the class failed: ";
    private static final KeyFactory<MetaParams> f = KeyFactory.CamelBuilder.get(CLASS);
    public static final Key<MetaParams, CachePolicy> CACHE_POLICY = f.newKey("cachePolicy", (Object)CachePolicy.PROTECTED_CACHE);
    public static final Key<MetaParams, String> TABLE_ALIAS_PREFIX = f.newKey("tableAliasPrefix", (Object)"");
    public static final Key<MetaParams, String> TABLE_ALIAS_SUFFIX = f.newKey("tableAliasSuffix", (Object)"");
    public static final Key<MetaParams, Integer> SEQUENCE_CACHE = f.newKey("sequenceCache", (Object)100);
    public static final Key<MetaParams, LazyLoading> LAZY_LOADING = f.newKey("lazyLoading", (Object)LazyLoading.ALLOWED_USING_OPEN_SESSION);
    public static final Key<MetaParams, Orm2ddlPolicy> ORM2DLL_POLICY = f.newKey("orm2ddlPolicy", (Object)Orm2ddlPolicy.CREATE_OR_UPDATE_DDL);
    public static final Key<MetaParams, CommentPolicy> COMMENT_POLICY = f.newKey("commentPolicy", (Object)CommentPolicy.ON_ANY_CHANGE);
    public static final Key<MetaParams, File> SAVE_CONFIG_TO_FILE = f.newKey("saveConfigToFile");
    public static final Key<MetaParams, Class<? extends InitializationBatch>> INITIALIZATION_BATCH = f.newClassKey("initializationBatch", InitializationBatch.class);
    public static final Key<MetaParams, Class<? extends ITypeService>> TYPE_SERVICE = f.newClassKey("typeService", TypeService.class);
    public static final Key<MetaParams, Class<? extends IndexModelBuilder>> INDEX_MODEL_BUILDER = f.newClassKey("indexModelBuilder", IndexModelBuilder.class);
    public static final Key<MetaParams, Class<? extends MetaDbService>> META_DB_SERVICE = f.newClassKey("metaDbService", MetaDbService.class);
    public static final Key<MetaParams, Class<? extends SqlNameProvider>> SQL_NAME_PROVIDER = f.newClassKey("sqlNameProvider", SqlNameProvider.class);
    public static final Key<MetaParams, CheckReport> CHECK_KEYWORDS = f.newKey("checkKeywords", (Object)CheckReport.EXCEPTION);
    public static final Key<MetaParams, Integer> MAX_ITEM_COUNT_4_IN = f.newKey("maxItemCountForIN", (Object)500);
    public static final Key<MetaParams, Boolean> SEQUENCE_SCHEMA_SYMBOL = f.newKey("sequenceSchemaSymbol", (Object)false);
    public static final Key<MetaParams, Boolean> INHERITANCE_MODE = f.newKey("inheritanceMode", (Object)true);
    public static final Key<MetaParams, Integer> INSERT_MULTIROW_ITEM_LIMIT = f.newKey("insertMultirowItemLimit", (Object)100);
    public static final Key<MetaParams, MoreParams> MORE_PARAMS = f.newKey("moreParams");
    public static final Key<MetaParams, Boolean> LOG_METAMODEL_INFO = f.newKey("logMetamodelInfo", (Object)true);
    public static final Key<MetaParams, Boolean> LOG_SQL_MULTI_INSERT = f.newKey("logSqlMultiInsert", (Object)false);
    public static final Key<MetaParams, Boolean> LOGBACK_LOGGING_SUPPORT = f.newKey("logbackLoggingSupport", (Object)false);
    public static final Key<MetaParams, Integer> LOG_VALUE_LENGTH_LIMIT = f.newKey("logValueLengthLimit", (Object)128);
    @Transient
    public static final Key<MetaParams, Object> APPL_CONTEXT = f.newKey("applContext");
    public static final Key<MetaParams, Boolean> EXTENTED_INDEX_NAME_STRATEGY;
    private final Map<Class, ITypeService> typeServices = new HashMap<Class, ITypeService>(2);
    private InitializationBatch batch;

    public MetaParams() {
        MORE_PARAMS.setValue((Ujo)this, (Object)new MoreParams());
    }

    public void writeValue(Key key, Object object) {
        int n;
        if (SEQUENCE_CACHE == key && (n = ((Integer)object).intValue()) < 1) {
            object = 1;
            String string = "The smallest possible value of key '" + key + "' is 1, not " + n;
            LOGGER.log(UjoLogger.WARN, string);
        }
        super.writeValue(key, object);
    }

    public <T extends ITypeService> T getConverter(Class<T> clazz) {
        ITypeService iTypeService;
        if (clazz == null) {
            clazz = (Class)TYPE_SERVICE.of((Ujo)this);
        }
        if ((iTypeService = this.typeServices.get(clazz)) == null) {
            try {
                iTypeService = (ITypeService)clazz.newInstance();
                this.typeServices.put(clazz, iTypeService);
            }
            catch (ReflectiveOperationException | RuntimeException exception) {
                return (T)((ITypeService)this.throwInstantiationException(clazz, exception));
            }
        }
        return (T)iTypeService;
    }

    public <UJO extends MetaParams, VALUE> MetaParams set(Key<UJO, VALUE> key, VALUE VALUE) {
        key.setValue((Ujo)this, VALUE);
        return this;
    }

    public MetaParams setApplContext(Object object) {
        APPL_CONTEXT.setValue((Ujo)this, object);
        return this;
    }

    public MoreParams more() {
        return (MoreParams)((Object)MORE_PARAMS.of((Ujo)this));
    }

    public boolean isQuotedSqlNames() {
        return CheckReport.QUOTE_SQL_NAMES == CHECK_KEYWORDS.of((Ujo)this);
    }

    public void setQuotedSqlNames(boolean bl) {
        CHECK_KEYWORDS.setValue((Ujo)this, (Object)(bl ? CheckReport.QUOTE_SQL_NAMES : null));
    }

    public void set(Key<MetaParams, Class<? extends InitializationBatch>> key, InitializationBatch initializationBatch) {
        this.checkReadOnly(true);
        this.batch = initializationBatch;
    }

    public InitializationBatch getInitializationBatch() throws IllegalStateException {
        if (INITIALIZATION_BATCH.isDefault((Ujo)this)) {
            return this.batch;
        }
        try {
            return (InitializationBatch)((Class)INITIALIZATION_BATCH.of((Ujo)this)).newInstance();
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            return (InitializationBatch)this.throwInstantiationException((Class)INITIALIZATION_BATCH.of((Ujo)this), exception);
        }
    }

    public IndexModelBuilder getIndexModelBuilder(MetaTable metaTable) throws IllegalStateException {
        try {
            IndexModelBuilder indexModelBuilder = (IndexModelBuilder)((Class)INDEX_MODEL_BUILDER.of((Ujo)this)).newInstance();
            indexModelBuilder.init(metaTable);
            return indexModelBuilder;
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            return (IndexModelBuilder)this.throwInstantiationException((Class)INDEX_MODEL_BUILDER.of((Ujo)this), exception);
        }
    }

    private <T> T throwInstantiationException(Class<?> clazz, Exception exception) throws IllegalUjormException {
        throw new IllegalUjormException(INSTANCE_FAILED_MSG + clazz, (Throwable)exception);
    }

    static {
        f.lock();
        EXTENTED_INDEX_NAME_STRATEGY = MORE_PARAMS.add(MoreParams.EXTENTED_INDEX_NAME_STRATEGY);
    }
}

