/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.orm.TypeService;
import org.ujorm.orm.metaModel.MetaColumn;

public class TypeServiceForOlderJdbc
extends TypeService {
    @Override
    public void setValue(@Nonnull MetaColumn metaColumn, @Nonnull PreparedStatement preparedStatement, @Nullable Object object, int n) throws SQLException {
        if (object != null) {
            switch (metaColumn.getTypeCode()) {
                case '\u0019': {
                    preparedStatement.setDate(n, Date.valueOf((LocalDate)object));
                    return;
                }
                case '\u001a': {
                    preparedStatement.setTime(n, Time.valueOf((LocalTime)object));
                    return;
                }
                case '\u001b': {
                    preparedStatement.setTimestamp(n, Timestamp.valueOf((LocalDateTime)object));
                    return;
                }
                case '\u001c': {
                    throw new IllegalStateException("Unsupported type: " + metaColumn.getTypeCode());
                }
            }
        }
        super.setValue(metaColumn, preparedStatement, object, n);
    }

    @Override
    public Object getValue(@Nonnull MetaColumn metaColumn, @Nonnull CallableStatement callableStatement, int n) throws SQLException {
        switch (metaColumn.getTypeCode()) {
            case '\u0019': {
                Date date = callableStatement.getDate(n);
                return callableStatement.wasNull() ? null : date.toLocalDate();
            }
            case '\u001a': {
                Time time = callableStatement.getTime(n);
                return callableStatement.wasNull() ? null : time.toLocalTime();
            }
            case '\u001b': {
                Timestamp timestamp = callableStatement.getTimestamp(n);
                return callableStatement.wasNull() ? null : timestamp.toLocalDateTime();
            }
            case '\u001c': {
                throw new IllegalStateException("Unsupported type: " + metaColumn.getType());
            }
        }
        return super.getValue(metaColumn, callableStatement, n);
    }

    @Override
    public Object getValue(@Nonnull MetaColumn metaColumn, @Nonnull ResultSet resultSet, int n) throws SQLException {
        switch (metaColumn.getTypeCode()) {
            case '\u0019': {
                Date date = resultSet.getDate(n);
                return resultSet.wasNull() ? null : date.toLocalDate();
            }
            case '\u001a': {
                Time time = resultSet.getTime(n);
                return resultSet.wasNull() ? null : time.toLocalTime();
            }
            case '\u001b': {
                Timestamp timestamp = resultSet.getTimestamp(n);
                return resultSet.wasNull() ? null : timestamp.toLocalDateTime();
            }
            case '\u001c': {
                throw new IllegalStateException("Unsupported type: " + metaColumn.getType());
            }
        }
        return super.getValue(metaColumn, resultSet, n);
    }
}

