/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.impl.TableWrapperImpl;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.metaModel.MoreParams;
import org.ujorm.tools.Assert;

public class MySqlDialect
extends SqlDialect {
    public static final int VARCHAR_MAX_LENGTH = 21845;

    @Override
    public String getJdbcUrl() {
        return "jdbc:mysql://127.0.0.1:3306/db1";
    }

    @Override
    public String getJdbcDriver() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public boolean isCatalog() {
        return true;
    }

    @Override
    public Appendable printDelete(CriterionDecoder criterionDecoder, Appendable appendable) throws IOException {
        appendable.append("DELETE ");
        this.printQuotedName(criterionDecoder.getBaseTable().getAlias(), appendable);
        appendable.append(" FROM ");
        TableWrapper[] tableWrapperArray = criterionDecoder.getTablesSorted();
        if (tableWrapperArray.length == 1) {
            tableWrapperArray[0] = new TableWrapperImpl(criterionDecoder.getBaseTable(), "");
        }
        for (int i = 0; i < tableWrapperArray.length; ++i) {
            if (i > 0) {
                appendable.append(", ");
            }
            this.printTableAliasDefinition(tableWrapperArray[i], appendable);
        }
        return this.printWhere(criterionDecoder, tableWrapperArray, appendable);
    }

    @Override
    public Appendable printUpdate(List<MetaColumn> list, CriterionDecoder criterionDecoder, Appendable appendable) throws IOException {
        int n;
        TableWrapper[] tableWrapperArray = criterionDecoder.getTablesSorted();
        if (tableWrapperArray.length == 1) {
            tableWrapperArray[0] = new TableWrapperImpl(criterionDecoder.getBaseTable(), "");
        }
        appendable.append("UPDATE ");
        for (n = 0; n < tableWrapperArray.length; ++n) {
            if (n > 0) {
                appendable.append(", ");
            }
            this.printTableAliasDefinition(tableWrapperArray[n], appendable);
        }
        appendable.append("\n\tSET ");
        for (n = 0; n < list.size(); ++n) {
            MetaColumn metaColumn = list.get(n);
            Assert.isFalse((boolean)metaColumn.isPrimaryKey(), (Object[])new Object[]{"Primary key can not be changed: ", metaColumn});
            appendable.append(n == 0 ? "" : ", ");
            appendable.append(metaColumn.getColumnAlias());
            appendable.append("=?");
        }
        return this.printWhere(criterionDecoder, tableWrapperArray, appendable);
    }

    protected Appendable printWhere(CriterionDecoder criterionDecoder, TableWrapper[] tableWrapperArray, Appendable appendable) throws IOException {
        appendable.append(" WHERE ");
        String string = criterionDecoder.getWhere();
        if (tableWrapperArray.length == 1) {
            String string2 = this.printFullTableName(criterionDecoder.getBaseTable(), new StringBuilder(64)).toString();
            String string3 = this.printQuotedName(criterionDecoder.getBaseTable().getAlias(), new StringBuilder(64)).toString();
            string = string.replace(string3 + '.', string2 + '.');
        }
        appendable.append(string);
        return appendable;
    }

    @Override
    public Appendable printSequenceTable(MetaDatabase metaDatabase, Appendable appendable) throws IOException {
        return super.printSequenceTable(metaDatabase, appendable).append(' ').append(this.getEngine(null));
    }

    @Override
    public Appendable printTable(MetaTable metaTable, Appendable appendable) throws IOException {
        return super.printTable(metaTable, appendable).append(' ').append(this.getEngine(metaTable));
    }

    protected String getEngine(MetaTable metaTable) {
        String string = (String)MetaParams.MORE_PARAMS.add(MoreParams.DIALECT_MYSQL_ENGINE_TYPE).of((Ujo)this.ormHandler.getParameters());
        return string;
    }

    @Override
    protected String getColumnType(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case TIMESTAMP: {
                return "DATETIME";
            }
            case CLOB: {
                return "LONGTEXT";
            }
            case BLOB: {
                return "LONGBLOB";
            }
            case VARCHAR: {
                return metaColumn.getMaxLength() > 21845 ? "TEXT" : super.getColumnType(metaColumn);
            }
        }
        return super.getColumnType(metaColumn);
    }

    @Override
    public Appendable printComment(MetaTable metaTable, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" COMMENT = '");
        this.escape((CharSequence)MetaTable.COMMENT.of((Ujo)metaTable), appendable);
        appendable.append("'");
        return appendable;
    }

    @Override
    public Appendable printComment(MetaColumn metaColumn, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaColumn.getTable(), appendable);
        appendable.append(" MODIFY COLUMN ");
        if (metaColumn.isPrimaryKey()) {
            String string = " PRIMARY KEY";
            String string2 = this.printColumnDeclaration(metaColumn, null, new StringBuilder()).toString();
            appendable.append(string2.replaceAll(string, " "));
        } else if (metaColumn.isForeignKey()) {
            this.printFKColumnsDeclaration(metaColumn, appendable);
        } else {
            this.printColumnDeclaration(metaColumn, null, appendable);
        }
        appendable.append(" COMMENT '");
        this.escape((CharSequence)MetaColumn.COMMENT.of((Ujo)metaColumn), appendable);
        appendable.append("'");
        return appendable;
    }

    @Override
    public Appendable printQuotedNameAlways(CharSequence charSequence, Appendable appendable) throws IOException {
        appendable.append('`');
        appendable.append(charSequence);
        appendable.append('`');
        return appendable;
    }

    @Override
    public Appendable printNextSequence(String string, MetaTable metaTable, Appendable appendable) throws IOException {
        appendable.append("SELECT AUTO_INCREMENT ");
        appendable.append("FROM information_schema.TABLES WHERE TABLE_SCHEMA = '");
        appendable.append((CharSequence)MetaTable.SCHEMA.of((Ujo)metaTable));
        appendable.append("' AND TABLE_NAME = '");
        appendable.append((CharSequence)MetaTable.NAME.of((Ujo)metaTable));
        appendable.append("'");
        return appendable;
    }
}

