/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.UjoAction;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.annot.Transient;
import org.ujorm.core.annot.XmlAttribute;
import org.ujorm.extensions.StringWrapper;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.BytesWrapper;
import org.ujorm.orm.ColumnSet;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.DbType;
import org.ujorm.orm.JdbcStatement;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.annot.Db;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.ao.UjoStatement;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDbService;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.utility.OrmTools;
import org.ujorm.tools.Assert;

public final class MetaDatabase
extends AbstractMetaModel
implements Comparable<MetaDatabase> {
    private static final Class<MetaDatabase> CLASS = MetaDatabase.class;
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(CLASS);
    private static final boolean ADD_DB_MODEL = true;
    private static final KeyFactory<MetaDatabase> fa = KeyFactory.CamelBuilder.get(CLASS);
    @XmlAttribute
    public static final Key<MetaDatabase, String> ID = fa.newKey("id", (Object)"");
    public static final Key<MetaDatabase, String> SCHEMA = fa.newKey("schema", (Object)"");
    public static final Key<MetaDatabase, Boolean> READ_ONLY = fa.newKey("readOnly", (Object)false);
    public static final Key<MetaDatabase, Class<? extends SqlDialect>> DIALECT = fa.newKey("dialect");
    public static final Key<MetaDatabase, String> JDBC_URL = fa.newKey("jdbcUrl", (Object)"");
    public static final Key<MetaDatabase, String> JDBC_DRIVER = fa.newKey("jdbcDriver", (Object)"");
    public static final Key<MetaDatabase, String> USER = fa.newKey("user", (Object)"");
    public static final Key<MetaDatabase, String> PASSWORD = fa.newKey("password", (Object)"");
    public static final ListKey<MetaDatabase, String> JNDI = fa.newListKey("jndi");
    public static final Key<MetaDatabase, Class<? extends UjoSequencer>> SEQUENCER = fa.newClassKey("sequencer", UjoSequencer.class);
    public static final Key<MetaDatabase, Orm2ddlPolicy> ORM2DLL_POLICY = fa.newKey("orm2ddlPolicy", (Object)Orm2ddlPolicy.INHERITED);
    public static final ListKey<MetaDatabase, MetaTable> TABLES = fa.newListKey("table");
    public static final ListKey<MetaDatabase, MetaProcedure> PROCEDURES = fa.newListKey("procedure");
    @Transient
    public static final Key<MetaDatabase, Integer> ORDER = fa.newKey("order", (Object)0);
    @Transient
    public static final Key<MetaDatabase, OrmUjo> ROOT = fa.newKey("root");
    private OrmHandler ormHandler;
    private SqlDialect dialect;

    public MetaDatabase() {
    }

    public MetaDatabase(OrmHandler ormHandler, OrmUjo ormUjo, MetaDatabase metaDatabase, Integer n) {
        Object object;
        Object object22;
        Db db;
        this.ormHandler = ormHandler;
        ROOT.setValue((Ujo)this, (Object)ormUjo);
        ORDER.setValue((Ujo)this, (Object)n);
        if (metaDatabase != null) {
            this.changeDefault(this, SCHEMA, SCHEMA.of((Ujo)metaDatabase));
            this.changeDefault(this, READ_ONLY, READ_ONLY.of((Ujo)metaDatabase));
            this.changeDefault(this, ORM2DLL_POLICY, ORM2DLL_POLICY.of((Ujo)metaDatabase));
            this.changeDefault(this, DIALECT, DIALECT.of((Ujo)metaDatabase));
            this.changeDefault(this, JDBC_URL, JDBC_URL.of((Ujo)metaDatabase));
            this.changeDefault(this, JDBC_DRIVER, JDBC_DRIVER.of((Ujo)metaDatabase));
            this.changeDefault(this, USER, USER.of((Ujo)metaDatabase));
            this.changeDefault(this, PASSWORD, PASSWORD.of((Ujo)metaDatabase));
            this.changeDefault(this, JNDI, JNDI.of((Ujo)metaDatabase));
            this.changeDefault(this, SEQUENCER, SEQUENCER.of((Ujo)metaDatabase));
        }
        if ((db = ormUjo.getClass().getAnnotation(Db.class)) != null) {
            this.changeDefault(this, SCHEMA, db.schema());
            this.changeDefault(this, READ_ONLY, db.readOnly());
            this.changeDefault(this, ORM2DLL_POLICY, db.orm2ddlPolicy());
            this.changeDefault(this, DIALECT, db.dialect());
            this.changeDefault(this, JDBC_URL, db.jdbcUrl());
            this.changeDefault(this, JDBC_DRIVER, db.jdbcDriver());
            this.changeDefault(this, USER, db.user());
            this.changeDefault(this, PASSWORD, db.password());
            this.changeDefault(this, JNDI, Arrays.asList(db.jndi()));
            this.changeDefault(this, SEQUENCER, db.sequencer());
        }
        this.changeDefault(this, ID, ormUjo.getClass().getSimpleName());
        this.changeDefault(this, JDBC_URL, this.getDialect().getJdbcUrl());
        this.changeDefault(this, JDBC_DRIVER, this.getDialect().getJdbcDriver());
        this.changeDefault(this, ORM2DLL_POLICY, MetaParams.ORM2DLL_POLICY.of((Ujo)this.getParams()));
        this.changeDefault(this, ORM2DLL_POLICY, MetaParams.ORM2DLL_POLICY.getDefault());
        for (Object object22 : ormUjo.readKeys()) {
            AbstractMetaModel abstractMetaModel;
            MetaTable metaTable;
            if (object22.isTypeOf(ColumnSet.class)) continue;
            if (object22 instanceof RelationToMany) {
                object = (RelationToMany)((Object)object22);
                metaTable = metaDatabase != null ? metaDatabase.findTable(object.getName()) : null;
                abstractMetaModel = new MetaTable(this, (RelationToMany<?, ?>)((Object)object), metaTable);
                TABLES.addItem((Ujo)this, (Object)abstractMetaModel);
                ormHandler.addTableModel((MetaTable)abstractMetaModel);
                continue;
            }
            if (!object22.isTypeOf(DbProcedure.class)) continue;
            object = object22;
            metaTable = metaDatabase != null ? metaDatabase.findProcedure(object.getName()) : null;
            abstractMetaModel = new MetaProcedure(this, (Key)object, (MetaProcedure)((Object)metaTable));
            PROCEDURES.addItem((Ujo)this, (Object)abstractMetaModel);
            ormHandler.addProcedureModel((MetaProcedure)abstractMetaModel);
        }
        String string = (String)SCHEMA.of((Ujo)this);
        object22 = new RelationToMany((String)(OrmTools.hasLength(string) ? string : RelationToMany.class.getSimpleName()), ormUjo.getClass());
        object = new MetaTable(this, (RelationToMany<?, ?>)((Object)object22), null);
        ((MetaTable)object).setNotPersistent();
        TABLES.addItem((Ujo)this, object);
        ormHandler.addTableModel((MetaTable)object);
    }

    public MetaDbService createService() throws IllegalUjormException {
        try {
            return this.getParams().get(MetaParams.META_DB_SERVICE).newInstance();
        }
        catch (OutOfMemoryError | ReflectiveOperationException | RuntimeException throwable) {
            throw new IllegalUjormException("Can't create an instance of: " + MetaDbService.class, throwable);
        }
    }

    public SqlDialect getDialect() {
        if (this.dialect == null) {
            try {
                this.dialect = (SqlDialect)((Class)DIALECT.of((Ujo)this)).newInstance();
                this.dialect.setHandler(this.ormHandler);
            }
            catch (ReflectiveOperationException | RuntimeException exception) {
                throw new IllegalUjormException("Can't create an instance of " + this.dialect, (Throwable)exception);
            }
        }
        return this.dialect;
    }

    public void changeDbType(MetaColumn metaColumn) {
        Class clazz = metaColumn.getDbTypeClass();
        if (Void.class == clazz) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.NULL);
        } else if (String.class == clazz || StringWrapper.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.VARCHAR);
        } else if (Integer.class == clazz || Color.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.INTEGER);
        } else if (Short.class == clazz) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.SMALLINT);
        } else if (Float.class == clazz) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.REAL);
        } else if (Long.class == clazz || BigInteger.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BIGINT);
        } else if (Double.class == clazz || BigDecimal.class == clazz) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.DECIMAL);
        } else if (Date.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.DATE);
        } else if (java.util.Date.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.TIMESTAMP);
        } else if (OffsetDateTime.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.TIMESTAMP_WITH_TIMEZONE);
        } else if (LocalDate.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.DATE);
        } else if (LocalTime.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.TIME);
        } else if (Byte.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.CHAR);
        } else if (Character.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.CHAR);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BOOLEAN);
        } else if (UUID.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.UUID);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.SMALLINT);
        } else if (Blob.class.isAssignableFrom(clazz) || BytesWrapper.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BLOB);
        } else if (Clob.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.CLOB);
        } else if (OrmUjo.class.isAssignableFrom(clazz)) {
            // empty if block
        }
    }

    public void changeDbLength(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case DECIMAL: {
                this.changeDefault(metaColumn, MetaColumn.MAX_LENGTH, 8);
                this.changeDefault(metaColumn, MetaColumn.PRECISION, 2);
                break;
            }
            case VARCHAR: 
            case VARCHAR_IGNORECASE: {
                if (!MetaColumn.MAX_LENGTH.isDefault((Ujo)metaColumn)) break;
                boolean bl = metaColumn.getType().isEnum();
                MetaColumn.MAX_LENGTH.setValue((Ujo)metaColumn, (Object)(bl ? this.maxEnumLenght4Db(metaColumn) : 128));
                break;
            }
        }
    }

    private int maxEnumLenght4Db(MetaColumn metaColumn) throws IllegalUjormException {
        try {
            int n = 1;
            UjoStatement ujoStatement = new UjoStatement();
            for (Object t : metaColumn.getType().getEnumConstants()) {
                metaColumn.getConverter().setValue(metaColumn, ujoStatement, t, 1);
                Object object = ujoStatement.getValue();
                if (!(object instanceof String)) continue;
                n = Math.max(n, ((String)object).length());
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new IllegalUjormException(sQLException.getMessage(), (Throwable)sQLException);
        }
    }

    protected int[] getDbItemCount() {
        int n = 0;
        int n2 = 0;
        for (MetaTable metaTable : TABLES.getList((Ujo)this)) {
            if (!metaTable.isTable()) continue;
            ++n;
            n2 += metaTable.getColumns().size();
        }
        return new int[]{n, n2};
    }

    public void create(Session session) {
        this.createService().create(this, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Connection connection, JdbcStatement jdbcStatement, ResultSet resultSet, boolean bl) throws IllegalUjormException {
        try {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            finally {
                try {
                    if (jdbcStatement != null) {
                        jdbcStatement.close();
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
        }
        catch (OutOfMemoryError | RuntimeException | SQLException throwable) {
            String string = "Can't close a SQL object";
            if (bl) {
                throw new IllegalUjormException(string, throwable);
            }
            LOGGER.log(UjoLogger.ERROR, string, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Connection connection, Statement statement, ResultSet resultSet, boolean bl) throws IllegalUjormException {
        try {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
        }
        catch (OutOfMemoryError | RuntimeException | SQLException throwable) {
            if (bl) {
                throw new IllegalUjormException("Can't close a SQL object", throwable);
            }
            LOGGER.log(UjoLogger.ERROR, "Can't close a SQL object", throwable);
        }
    }

    public OrmHandler getOrmHandler() {
        return this.ormHandler;
    }

    public MetaParams getParams() {
        return this.ormHandler.getParameters();
    }

    public String getId() {
        return (String)ID.of((Ujo)this);
    }

    public Connection createConnection() throws Exception {
        Connection connection = this.dialect.createConnection(this);
        if (connection.getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        return connection;
    }

    public Connection createInternalConnection() throws Exception {
        Connection connection;
        List list = (List)JNDI.of((Ujo)this);
        if (!list.isEmpty()) {
            LOGGER.log(UjoLogger.DEBUG, "JNDI: {}", (Object)list);
            InitialContext initialContext = this.dialect.createJndiInitialContext(this);
            int n = list.size() - 1;
            for (int i = 0; i < n; ++i) {
                initialContext = (InitialContext)initialContext.lookup((String)list.get(i));
                Assert.notNull((Object)initialContext, (Object[])new Object[]{"JNDI problem: InitialContext was not found for the: {}", list.get(i)});
            }
            DataSource dataSource = (DataSource)initialContext.lookup((String)list.get(n));
            Assert.notNull((Object)dataSource, (Object[])new Object[]{"JNDI problem: database connection was not found for the: {}", list});
            connection = dataSource.getConnection();
        } else {
            Class<?> clazz = Class.forName((String)JDBC_DRIVER.of((Ujo)this));
            LOGGER.log(UjoLogger.TRACE, "Database driver {} is loaded.", clazz);
            connection = DriverManager.getConnection((String)JDBC_URL.of((Ujo)this), (String)USER.of((Ujo)this), (String)PASSWORD.of((Ujo)this));
        }
        return connection;
    }

    public boolean equals(Object object) {
        if (object instanceof MetaDatabase) {
            MetaDatabase metaDatabase = (MetaDatabase)object;
            int n = (Integer)ORDER.of((Ujo)this);
            int n2 = (Integer)ORDER.of((Ujo)metaDatabase);
            String string = (String)JDBC_URL.of((Ujo)this);
            String string2 = (String)JDBC_URL.of((Ujo)metaDatabase);
            return n == n2 && string.equals(string2);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + (Integer)ORDER.of((Ujo)this);
        n = 59 * n + ((String)JDBC_URL.of((Ujo)this)).hashCode();
        return n;
    }

    public Session getDefaultSession() {
        return this.ormHandler.getDefaultSession();
    }

    public Set<String> getSchemas(List<MetaTable> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (MetaTable metaTable : list) {
            String string;
            if (!metaTable.isTable() || !OrmTools.hasLength(string = (String)MetaTable.SCHEMA.of((Ujo)metaTable))) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Nullable
    MetaTable findTable(String string) {
        if (OrmTools.hasLength(string)) {
            for (MetaTable metaTable : TABLES.getList((Ujo)this)) {
                if (!MetaTable.ID.equals((Ujo)metaTable, (Object)string)) continue;
                return metaTable;
            }
        }
        return null;
    }

    @Nullable
    MetaProcedure findProcedure(String string) {
        if (OrmTools.hasLength(string)) {
            for (MetaProcedure metaProcedure : PROCEDURES.getList((Ujo)this)) {
                if (!MetaProcedure.ID.equals((Ujo)metaProcedure, (Object)string)) continue;
                return metaProcedure;
            }
        }
        return null;
    }

    public boolean isSequenceTableRequired() {
        for (MetaTable metaTable : (List)TABLES.of((Ujo)this)) {
            if (!metaTable.isTable() || !metaTable.getSequencer().isSequenceTableRequired()) continue;
            return true;
        }
        return false;
    }

    protected UjoSequencer createSequencer(MetaTable metaTable) throws IllegalUjormException {
        UjoSequencer ujoSequencer;
        Class clazz = (Class)SEQUENCER.of((Ujo)this);
        if (clazz == UjoSequencer.class) {
            ujoSequencer = new UjoSequencer(metaTable);
        } else {
            try {
                Constructor constructor = clazz.getConstructor(MetaTable.class);
                ujoSequencer = (UjoSequencer)constructor.newInstance(metaTable);
            }
            catch (ReflectiveOperationException | RuntimeException exception) {
                throw new IllegalUjormException("Can't create sequencer for " + clazz, (Throwable)exception);
            }
        }
        return ujoSequencer;
    }

    public List<MetaIndex> getIndexList() {
        ArrayList<MetaIndex> arrayList = new ArrayList<MetaIndex>(32);
        for (MetaTable metaTable : (List)TABLES.of((Ujo)this)) {
            arrayList.addAll(metaTable.getIndexCollection());
        }
        return arrayList;
    }

    public String toString() {
        String string = (String)ID.of((Ujo)this) + '[' + TABLES.getItemCount((Ujo)this) + ']';
        return string;
    }

    @Override
    public int compareTo(MetaDatabase metaDatabase) {
        Integer n = (Integer)ORDER.of((Ujo)this);
        Integer n2 = (Integer)ORDER.of((Ujo)metaDatabase);
        return n.compareTo(n2);
    }

    @Override
    public boolean readAuthorization(UjoAction ujoAction, Key key, Object object) {
        switch (ujoAction.getType()) {
            case 2: {
                return key != PASSWORD;
            }
        }
        return super.readAuthorization(ujoAction, key, object);
    }

    static {
        fa.lock();
    }
}

