/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.core;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.ujorm.CompositeKey;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoIterator;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.metaModel.MetaColumn;

final class ResultSetIterator<T extends OrmUjo>
extends UjoIterator<T>
implements Closeable {
    private final Query query;
    private final ColumnWrapper[] queryColumns;
    private final ResultSet rs;
    private PreparedStatement statement;
    private final boolean view;
    private long count = -1L;
    private boolean initState = true;
    private boolean cursorReady = false;
    private boolean hasNext = true;

    public ResultSetIterator(Query query) throws IllegalUjormException {
        try {
            this.query = query;
            this.queryColumns = query.getColumnArray();
            this.statement = query.getStatement();
            this.rs = this.statement.executeQuery();
            this.view = query.getTableModel().isSelectModel();
        }
        catch (SQLException sQLException) {
            this.close();
            throw new IllegalUjormException("ILLEGAL SQL: " + query, (Throwable)sQLException);
        }
    }

    @Override
    public boolean hasNext() throws IllegalUjormException {
        if (!this.cursorReady) {
            try {
                this.cursorReady = true;
                this.hasNext = this.rs.next();
                if (!this.hasNext) {
                    this.close();
                }
            }
            catch (SQLException sQLException) {
                throw new IllegalUjormException("A hasNext() reading exception", (Throwable)sQLException);
            }
        }
        return this.hasNext;
    }

    @Override
    public void close() throws IllegalUjormException {
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException sQLException) {
                throw new IllegalUjormException("Can't close statement: " + this.statement, (Throwable)sQLException);
            }
        }
    }

    @Override
    public T next() throws NoSuchElementException, IllegalUjormException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Query: " + this.query.toString());
        }
        try {
            this.cursorReady = false;
            OrmUjo ormUjo = this.query.getTableModel().createBO();
            int n = this.queryColumns.length;
            for (int i = 0; i < n; ++i) {
                ColumnWrapper columnWrapper = this.queryColumns[i];
                MetaColumn metaColumn = columnWrapper.getModel();
                int n2 = this.view ? this.rs.findColumn((String)MetaColumn.NAME.of((Ujo)metaColumn)) : i + 1;
                Object j = metaColumn.getConverter().getValue(metaColumn, this.rs, n2);
                if (columnWrapper.isCompositeKey()) {
                    Ujo ujo = ((CompositeKey)columnWrapper.getKey()).getSemiValue((Ujo)ormUjo, true);
                    metaColumn.setValue(ujo, j);
                    continue;
                }
                metaColumn.setValue(ormUjo, j);
            }
            ormUjo.writeSession(this.query.getSession());
            if (this.initState) {
                this.initState = false;
            }
            return (T)ormUjo;
        }
        catch (OutOfMemoryError | ReflectiveOperationException | RuntimeException | SQLException throwable) {
            throw new IllegalUjormException("Query: " + this.query, throwable);
        }
    }

    @Override
    public long count() {
        if (this.count < 0L) {
            this.count = !this.hasNext() && this.initState ? 0L : this.query.getCount();
        }
        return this.count;
    }

    @Override
    public boolean skip(int n) {
        while (n > 0 && this.hasNext()) {
            this.cursorReady = false;
            --n;
        }
        return n == 0;
    }
}

