/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.implementation.orm.OrmProperty;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Check;

public class NativeDbSequencer
extends UjoSequencer {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(OrmProperty.class);

    public NativeDbSequencer(MetaTable metaTable) {
        super(metaTable);
    }

    @Override
    public synchronized long nextValue(Session session) {
        String string = (String)MetaTable.SEQUENCE.of((Ujo)this.table);
        if (Check.hasLength((CharSequence)string)) {
            try {
                ResultSet resultSet = session.getFirstConnection().createStatement().executeQuery(this.createNextSequence(string));
                if (resultSet.next()) {
                    return resultSet.getLong(1);
                }
                throw new IllegalUjormException("No value for sequence: " + string);
            }
            catch (IOException | RuntimeException | SQLException exception) {
                String string2 = "Sequence error for name: " + string;
                LOGGER.log(UjoLogger.ERROR, string2, (Throwable)exception);
                throw new IllegalUjormException(string2, (Throwable)exception);
            }
        }
        return super.nextValue(session);
    }

    public String createNextSequence(String string) throws IOException {
        return ((MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table)).getDialect().printNextSequence(string, this.table, new StringBuilder(128)).toString();
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException("Reset is unsupported for the table " + this.getTableName());
    }
}

