/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.ao;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.orm.SqlNameProvider;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;

public class IndexModelBuilder {
    protected MetaTable metaTable;
    protected SqlNameProvider nameProvider;
    protected Map<String, MetaIndex> mapIndex;

    public void init(MetaTable metaTable) throws IllegalUjormException {
        Assert.isNull((Object)this.metaTable, (Object[])new Object[]{"The class is initialized by {}", metaTable});
        this.metaTable = metaTable;
        this.nameProvider = metaTable.getDatabase().getDialect().getNameProvider();
        this.mapIndex = new HashMap<String, MetaIndex>();
    }

    protected void addIndex(String string, MetaColumn metaColumn, boolean bl) {
        String string2;
        MetaIndex metaIndex;
        if (string == null || string.isEmpty()) {
            return;
        }
        if ("AUTO".equals(string)) {
            String string3 = string = bl ? this.nameProvider.getUniqueConstraintName(metaColumn) : this.nameProvider.getIndexName(metaColumn);
        }
        if ((metaIndex = this.mapIndex.get(string2 = string.toUpperCase())) == null) {
            metaIndex = new MetaIndex(string, this.metaTable);
            this.mapIndex.put(string2, metaIndex);
        }
        if (!bl) {
            MetaIndex.UNIQUE.setValue((Ujo)metaIndex, (Object)false);
        }
        if (metaColumn != MetaIndex.COLUMNS.getLastItem((Ujo)metaIndex)) {
            MetaIndex.COLUMNS.addItem((Ujo)metaIndex, (Object)metaColumn);
        }
    }

    public Collection<MetaIndex> getIndexModels() {
        this.addColumnsToIndex();
        return this.mapIndex.values();
    }

    protected void addColumnsToIndex() {
        boolean bl = this.isExtendedIndexStrategy();
        for (MetaColumn metaColumn : MetaTable.COLUMNS.getList((Ujo)this.metaTable)) {
            for (String string : (List)MetaColumn.UNIQUE_INDEX.of((Ujo)metaColumn)) {
                this.addIndex(string, metaColumn, true);
            }
            for (String string : (List)MetaColumn.INDEX.of((Ujo)metaColumn)) {
                this.addIndex(string, metaColumn, false);
            }
            if (!bl || !metaColumn.isForeignKey()) continue;
            this.addIndex("AUTO", metaColumn, false);
        }
    }

    protected Boolean isExtendedIndexStrategy() {
        return (Boolean)MetaParams.EXTENTED_INDEX_NAME_STRATEGY.of((Ujo)this.metaTable.getDatabase().getOrmHandler().getParameters());
    }
}

