/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.implementation.orm;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.UjoAction;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.UjoManager;
import org.ujorm.extensions.Property;
import org.ujorm.implementation.orm.OrmProperty;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.implementation.quick.QuickUjo;
import org.ujorm.orm.ExtendedOrmUjo;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.LowerCaseKeyFactory;
import org.ujorm.orm.OrmKeyFactory;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;

public abstract class OrmTable<U extends OrmTable>
extends QuickUjo
implements ExtendedOrmUjo<U> {
    static final Key[] EMPTY = new Key[0];
    private transient Session session;
    private transient Set<Key> changes = null;

    @Override
    public Session readSession() {
        return this.session;
    }

    @Override
    public void writeSession(Session session) {
        this.session = session;
    }

    public void writeValue(Key<?, ?> key, Object object) {
        if (this.session != null) {
            if (this.changes == null) {
                this.changes = new HashSet<Key>(8);
            }
            this.changes.add(key);
        }
        super.writeValue(key, object);
    }

    @Override
    public Key[] readChangedProperties(boolean bl) {
        Key[] keyArray;
        Key[] keyArray2 = keyArray = this.changes == null || this.changes.isEmpty() ? EMPTY : this.changes.toArray(new Key[this.changes.size()]);
        if (bl) {
            this.changes = null;
        }
        return keyArray;
    }

    public final <UJO extends U, VALUE> VALUE get(Key<UJO, VALUE> key) {
        Object object = key.of((Ujo)this);
        return (VALUE)object;
    }

    public final <UJO extends U, VALUE> U set(Key<UJO, VALUE> key, VALUE VALUE) {
        UjoManager.assertAssign(key, VALUE);
        key.setValue((Ujo)this, VALUE);
        return (U)this;
    }

    public boolean readAuthorization(@Nonnull UjoAction ujoAction, @Nonnull Key key, @Nullable Object object) {
        switch (ujoAction.getType()) {
            case 22: {
                return !(key instanceof RelationToMany);
            }
        }
        return super.readAuthorization(ujoAction, key, object);
    }

    @Override
    public <UJO extends U> ForeignKey readFK(Key<UJO, ? extends OrmUjo> key) throws IllegalStateException {
        Object object = super.readValue(key);
        if (object == null || object instanceof ForeignKey) {
            return (ForeignKey)object;
        }
        if (this.session != null) {
            OrmUjo ormUjo = object instanceof OrmUjo ? (OrmUjo)object : this;
            return this.session.readFK(ormUjo, key);
        }
        throw new NullPointerException("Can't get FK by the key '" + key.getFullName() + "' due a missing Session");
    }

    protected static <UJO extends Ujo, FACTORY extends KeyFactory<UJO>> FACTORY newCamelFactory(Class<? extends UJO> clazz) {
        return (FACTORY)((Object)new OrmKeyFactory<UJO>(clazz, true));
    }

    @Deprecated
    protected static <UJO extends Ujo, FACTORY extends KeyFactory<UJO>> FACTORY newSnakeCaseFactory(Class<? extends UJO> clazz) {
        return OrmTable.newLowerCaseFactory(clazz);
    }

    protected static <UJO extends Ujo, FACTORY extends KeyFactory<UJO>> FACTORY newLowerCaseFactory(Class<? extends UJO> clazz) {
        return (FACTORY)((Object)new LowerCaseKeyFactory<UJO>(clazz));
    }

    protected static <UJO extends Ujo, FACTORY extends KeyFactory<UJO>> FACTORY newFactory(Class<? extends UJO> clazz) {
        return (FACTORY)((Object)new OrmKeyFactory<UJO>(clazz, false));
    }

    @Deprecated
    protected static <UJO extends ExtendedOrmUjo, ITEM extends ExtendedOrmUjo> RelationToMany<UJO, ITEM> newRelation(String string, Class<ITEM> clazz) {
        return new RelationToMany(string, clazz, -1, false);
    }

    protected static <UJO extends ExtendedOrmUjo, ITEM extends ExtendedOrmUjo> RelationToMany<UJO, ITEM> newRelation(String string) {
        return new RelationToMany(string, null, -1, false);
    }

    @Deprecated
    protected static <UJO extends ExtendedOrmUjo, ITEM extends ExtendedOrmUjo> RelationToMany<UJO, ITEM> newRelation(Class<ITEM> clazz) {
        return OrmTable.newRelation(null, clazz);
    }

    protected static <UJO extends ExtendedOrmUjo, ITEM extends ExtendedOrmUjo> RelationToMany<UJO, ITEM> newRelation() {
        return OrmTable.newRelation(null, null);
    }

    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newKey() {
        return new OrmProperty(-1);
    }

    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newKey(String string) {
        return new OrmProperty(-1, string, null, null);
    }

    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newKey(String string, VALUE VALUE) {
        return new OrmProperty(-1, string, VALUE, null);
    }

    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newKeyDefault(VALUE VALUE) {
        return new OrmProperty(-1, null, VALUE, null);
    }

    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newKey(String string, Class<VALUE> clazz, VALUE VALUE, int n, boolean bl) {
        return new OrmProperty(n, string, VALUE, null);
    }

    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newKey(VALUE VALUE) {
        return OrmTable.newKey(null, null, VALUE, -1, false);
    }

    public static <UJO extends QuickUjo, VALUE> Property<UJO, VALUE> newKey(Key key) {
        return new OrmProperty(-1, key.getName(), key.getDefault(), null);
    }

    @Deprecated
    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newProperty(String string, Class<VALUE> clazz) {
        return OrmTable.newProperty(string, clazz, null, -1, false);
    }

    @Deprecated
    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newProperty(String string) {
        return OrmTable.newProperty(string, null, null, -1, false);
    }

    @Deprecated
    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newProperty(String string, VALUE VALUE) {
        return OrmTable.newProperty(string, null, VALUE, -1, false);
    }

    @Deprecated
    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newProperty(Class<VALUE> clazz) {
        return OrmTable.newProperty(null, clazz, null, -1, false);
    }

    @Deprecated
    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newProperty(String string, Class<VALUE> clazz, VALUE VALUE, int n, boolean bl) {
        return new OrmProperty(n, string, VALUE, null);
    }

    @Deprecated
    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newProperty(VALUE VALUE) {
        return OrmTable.newProperty(null, null, VALUE, -1, false);
    }

    @Deprecated
    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newProperty(Class<VALUE> clazz, VALUE VALUE) {
        return OrmTable.newProperty(null, null, VALUE, -1, false);
    }

    @Deprecated
    protected static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newProperty() {
        return OrmTable.newProperty(null, null, null, -1, false);
    }
}

