/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;

public class UjoSequencer {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(UjoSequencer.class);
    public static final int SEQ_LIMIT = 1;
    public static final int SEQ_STEP = 2;
    public static final int SEQ_MAX_VALUE = 3;
    protected final MetaTable table;
    protected long sequence = 0L;
    protected long seqLimit = 0L;
    protected long maxValue = 0L;

    public UjoSequencer(MetaTable metaTable) {
        this.table = metaTable;
    }

    public synchronized long nextValue(Session session) {
        if (this.sequence < this.seqLimit) {
            return ++this.sequence;
        }
        MetaDatabase metaDatabase = this.table.getDatabase();
        Connection connection = null;
        String string = null;
        StringBuilder stringBuilder = new StringBuilder(64);
        try {
            String string2;
            int n;
            connection = session.getSeqConnection(metaDatabase);
            String string3 = metaDatabase.getDialect().printFullTableName(this.getTable(), true, stringBuilder).toString();
            stringBuilder.setLength(0);
            string = metaDatabase.getDialect().printSequenceNextValue(this, stringBuilder).toString();
            if (LOGGER.isLoggable(UjoLogger.TRACE)) {
                LOGGER.log(UjoLogger.TRACE, "{}; [{}]", new Object[]{string, string3});
            }
            if ((n = this.executeSql(connection, string, string3)) == 0) {
                stringBuilder.setLength(0);
                string = metaDatabase.getDialect().printSequenceInit(this, stringBuilder).toString();
                if (LOGGER.isLoggable(UjoLogger.TRACE)) {
                    LOGGER.log(UjoLogger.TRACE, "{}; [{}]", new Object[]{string, string3});
                }
                this.executeSql(connection, string, string3);
            }
            long[] lArray = this.getCurrentDBSequence(connection, stringBuilder);
            this.seqLimit = lArray[1];
            int n2 = (int)lArray[2];
            this.maxValue = lArray[3];
            this.sequence = this.seqLimit - (long)n2 + 1L;
            if (LOGGER.isLoggable(UjoLogger.INFO)) {
                string2 = this.getClass().getSimpleName() + ": tableName=" + string3 + ", seqLimit=" + this.seqLimit + ", step=" + n2 + ", maxValue=" + this.maxValue + ", sequence=" + this.sequence;
                LOGGER.log(UjoLogger.INFO, string2);
            }
            if (this.maxValue != 0L) {
                if (this.seqLimit > this.maxValue) {
                    this.seqLimit = this.maxValue;
                    Assert.isTrue((this.sequence <= this.maxValue ? 1 : 0) != 0, (Object[])new Object[]{"The sequence '{}' needs to raise the maximum value: {}", string3, this.maxValue});
                    stringBuilder.setLength(0);
                    string = metaDatabase.getDialect().printSequenceNextValue(this, stringBuilder).toString();
                    if (LOGGER.isLoggable(UjoLogger.INFO)) {
                        LOGGER.log(UjoLogger.INFO, "{}; [{}]", new Object[]{string, string3});
                    }
                    this.executeSql(connection, string, string3);
                }
                if (this.maxValue > Long.MAX_VALUE - (long)n2) {
                    string2 = "The sequence attribute '" + string3 + ".maxValue' is too hight, the recommended maximal value is: " + (Long.MAX_VALUE - (long)n2) + " (Long.MAX_VALUE-step)";
                    LOGGER.log(UjoLogger.WARN, string2);
                }
            }
            connection.commit();
        }
        catch (IOException | OutOfMemoryError | RuntimeException | SQLException throwable) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    LOGGER.log(UjoLogger.WARN, "Rollback fails");
                }
            }
            IllegalStateException illegalStateException = throwable instanceof IllegalStateException ? (IllegalStateException)throwable : new IllegalUjormException("ILLEGAL SQL: " + string, throwable);
            throw illegalStateException;
        }
        return this.sequence;
    }

    public String getDatabaseSchema() {
        return (String)MetaDatabase.SCHEMA.of((Ujo)this.getDatabase());
    }

    public int getIncrement() {
        int n = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)this.table.getDatabase().getParams());
        return n;
    }

    public int getInitDbCache() {
        return 1;
    }

    public MetaDatabase getDatabase() {
        return (MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table);
    }

    public MetaTable getTable() {
        return this.table;
    }

    protected String getTableName() {
        try {
            SqlDialect sqlDialect = this.table.getDatabase().getDialect();
            return sqlDialect.printFullTableName(this.getTable(), true, new StringBuilder()).toString();
        }
        catch (IOException iOException) {
            throw new IllegalUjormException("TableName failed", (Throwable)iOException);
        }
    }

    public boolean isSequenceTableRequired() {
        return true;
    }

    public synchronized void reset() {
        this.sequence = 0L;
        this.seqLimit = 0L;
        this.maxValue = 0L;
        LOGGER.log(UjoLogger.INFO, this.getClass().getSimpleName() + ": reset the sequencer for the table " + this.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public long[] getCurrentDBSequence(Connection connection, StringBuilder stringBuilder) throws SQLException, IOException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            long[] lArray;
            if (stringBuilder != null) {
                stringBuilder.setLength(0);
            } else {
                stringBuilder = new StringBuilder(64);
            }
            MetaDatabase metaDatabase = this.table.getDatabase();
            String string = metaDatabase.getDialect().printFullTableName(this.getTable(), true, stringBuilder).toString();
            stringBuilder.setLength(0);
            metaDatabase.getDialect().printSequenceCurrentValue(this, stringBuilder);
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(stringBuilder.toString());
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                long[] lArray2 = new long[4];
                lArray2[1] = resultSet.getLong(1);
                lArray2[2] = resultSet.getLong(2);
                lArray2[3] = resultSet.getLong(3);
                lArray = lArray2;
            }
            catch (Throwable throwable) {
                MetaDatabase.close(null, preparedStatement, resultSet, true);
                throw throwable;
            }
            MetaDatabase.close(null, preparedStatement, resultSet, true);
            return lArray;
        }
        long[] lArray = null;
        MetaDatabase.close(null, preparedStatement, resultSet, true);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeSql(Connection connection, String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, string2);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        finally {
            MetaDatabase.close(null, preparedStatement, null, true);
        }
    }
}

