/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoIterator;
import org.ujorm.criterion.Criterion;
import org.ujorm.implementation.orm.OrmTable;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlParameters;
import org.ujorm.orm.impl.ColumnWrapperImpl;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.utility.OrmTools;
import org.ujorm.tools.Assert;

public class Query<UJO extends OrmUjo>
implements Iterable<UJO> {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(Query.class);
    protected static final String GENERATED_ALIAS_PREFIX = "ujorm_alias_";
    @Nonnull
    private final MetaTable table;
    @Nullable
    private ArrayList<ColumnWrapper> columns;
    @Nullable
    private Session session;
    private Criterion<UJO> criterion;
    private boolean distinct;
    private CriterionDecoder decoder;
    @Nullable
    private String sqlStatement;
    private List<Key<UJO, ?>> orderBy;
    private Set<ColumnWrapper> outerJoins;
    private long offset = 0L;
    private int limit = -1;
    private int fetchSize = -1;
    private boolean lockRequest;
    @Nullable
    private SqlParameters sqlParameters;
    static final Comparator<Key> INNER_KEY_COMPARATOR = new Comparator<Key>(){

        @Override
        public int compare(Key key, Key key2) {
            if (!key.isComposite()) {
                return key2.isComposite() ? -1 : 0;
            }
            if (key2.isComposite()) {
                int n;
                int n2 = ((CompositeKey)key).getCompositeCount();
                return n2 == (n = ((CompositeKey)key2).getCompositeCount()) ? 0 : (n2 < n ? -1 : 1);
            }
            return 1;
        }
    };

    public Query(@Nonnull MetaTable metaTable, @Nullable Criterion<UJO> criterion, @Nullable Session session) {
        Assert.notNull((Object)metaTable, (Object[])new Object[]{"table"});
        this.table = metaTable;
        this.columns = null;
        this.criterion = criterion;
        this.session = session;
        this.orderByMany(new Key[0]);
    }

    public Query(@Nonnull MetaTable metaTable, @Nullable Criterion<UJO> criterion) {
        this(metaTable, criterion, null);
    }

    @Nonnull
    private OrmHandler getHandler() {
        OrmHandler ormHandler = null;
        if (this.table != null) {
            ormHandler = this.table.getDatabase().getOrmHandler();
        } else if (this.session != null) {
            ormHandler = this.session.getHandler();
        }
        Assert.notNull((Object)ormHandler, (Object[])new Object[]{"The base class must be assigned first!"});
        assert (ormHandler != null);
        return ormHandler;
    }

    @Nonnull
    public Query<UJO> setSession(@Nonnull Session session) {
        Assert.notNull((Object)session, (Object[])new Object[]{"session"});
        this.session = session;
        return this;
    }

    public long getLimitedCount() {
        long l = this.getCount();
        if (this.isOffset() && (l -= this.offset) < 0L) {
            l = 0L;
        }
        if (this.limit >= 0 && (long)this.limit < l) {
            l = this.limit;
        }
        return l;
    }

    public long getCount() {
        long l = this.session.getRowCount(this);
        return l;
    }

    public <ITEM> void setParameter(@Nonnull Key<UJO, ITEM> key, @Nonnull ITEM ITEM) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void addCriterion(@Nonnull Criterion<UJO> criterion) throws IllegalArgumentException {
        Assert.notNull(criterion, (Object[])new Object[]{"Argument must not be {}", criterion});
        this.criterion = this.criterion != null ? this.criterion.and(criterion) : criterion;
        this.clearDecoder();
    }

    @Nonnull
    public Query<UJO> setCriterion(@Nullable Criterion<UJO> criterion) {
        this.criterion = criterion != null ? criterion : Criterion.where((boolean)true);
        this.clearDecoder();
        return this;
    }

    public Criterion<UJO> getCriterion() {
        return this.criterion;
    }

    @Nonnull
    public final CriterionDecoder getDecoder() {
        if (this.decoder == null) {
            ArrayList<Key> arrayList = new ArrayList<Key>(16);
            for (Key<UJO, ?> object : this.orderBy) {
                if (!object.isComposite()) continue;
                arrayList.add(object);
            }
            for (ColumnWrapper columnWrapper : this.getColumns()) {
                if (!columnWrapper.isCompositeKey()) continue;
                arrayList.add(columnWrapper.getKey());
            }
            this.decoder = new CriterionDecoder(this.criterion, this.table, arrayList);
        }
        return this.decoder;
    }

    private void clearDecoder() {
        this.setDecoder(null);
    }

    void setDecoder(CriterionDecoder criterionDecoder) {
        this.decoder = criterionDecoder;
        this.sqlStatement = null;
    }

    public Session getSession() {
        return this.session;
    }

    public MetaTable getTableModel() {
        return this.table;
    }

    public List<ColumnWrapper> getColumns() {
        return this.columns != null ? this.columns : this.getDefaultColumns();
    }

    @Nonnull
    protected List<ColumnWrapper> getDefaultColumns() {
        return MetaTable.COLUMNS.getList((Ujo)this.table);
    }

    @Nonnull
    public ColumnWrapper[] getColumnArray() {
        List<ColumnWrapper> list = this.getColumns();
        ColumnWrapper[] columnWrapperArray = list.toArray(new ColumnWrapper[list.size()]);
        return columnWrapperArray;
    }

    @Override
    public UjoIterator<UJO> iterator() {
        UjoIterator ujoIterator = UjoIterator.of(this);
        return ujoIterator;
    }

    @Deprecated
    public final UjoIterator<UJO> iterate() {
        return this.iterator();
    }

    public List<UJO> list() {
        return ((UjoIterator)this.iterator()).toList();
    }

    public <T> Map<T, UJO> map() {
        return this.map(this.table.getFirstPK().getKey(), new HashMap(128));
    }

    public <T> Map<T, UJO> map(@Nonnull Key<UJO, T> key, @Nonnull Map<T, UJO> map) {
        Iterator iterator = ((UjoIterator)this.iterator()).iterator();
        while (iterator.hasNext()) {
            OrmUjo ormUjo = (OrmUjo)iterator.next();
            map.put(key.of((Ujo)ormUjo), ormUjo);
        }
        return map;
    }

    public List<UJO> list(int n) {
        switch (n) {
            case 0: {
                return this.list();
            }
            case 1: {
                return OrmTools.loadLazyValuesAsBatch(this);
            }
        }
        throw new IllegalArgumentException("The method supports only two values 0 and 1 in the current release");
    }

    @Nullable
    public UJO uniqueResult() throws NoSuchElementException {
        try (Iterator iterator = this.iterator();){
            if (!((UjoIterator)iterator).hasNext()) {
                UJO UJO = null;
                return UJO;
            }
            OrmUjo ormUjo = (OrmUjo)((UjoIterator)iterator).next();
            if (((UjoIterator)iterator).hasNext()) {
                throw new NoSuchElementException("Result is not unique for: " + this.criterion);
            }
            OrmUjo ormUjo2 = ormUjo;
            return (UJO)ormUjo2;
        }
    }

    public boolean exists() {
        int n = this.limit;
        this.limit = 1;
        try (Iterator iterator = this.iterator();){
            boolean bl = ((UjoIterator)iterator).hasNext();
            this.limit = n;
            boolean bl2 = bl;
            return bl2;
        }
    }

    public final List<Key<UJO, ?>> getOrderBy() {
        return this.orderBy;
    }

    public final Key<UJO, ?>[] getOrderAsArray() {
        return this.orderBy.toArray(new Key[this.orderBy.size()]);
    }

    @Deprecated
    public Query<UJO> setOrder(Key ... keyArray) {
        return this.orderByMany(keyArray);
    }

    public Query<UJO> orderBy(Key<UJO, ?> key) {
        return this.orderByMany(key);
    }

    public Query<UJO> orderBy(@Nonnull Key<UJO, ?> key, @Nonnull Key<UJO, ?> key2) {
        return this.orderByMany(key, key2);
    }

    public Query<UJO> orderBy(@Nonnull Key<UJO, ?> key, @Nonnull Key<UJO, ?> key2, @Nonnull Key<UJO, ?> key3) {
        return this.orderByMany(key, key2, key3);
    }

    @Nonnull
    public final Query<UJO> orderByMany(Key ... keyArray) {
        this.clearDecoder();
        this.orderBy = new ArrayList(Math.max(keyArray.length, 4));
        for (Key key : keyArray) {
            this.orderBy.add(key);
        }
        return this;
    }

    @Nonnull
    public Query<UJO> fetchAll() throws IllegalArgumentException {
        this.clearDecoder();
        List list = MetaTable.COLUMNS.getList((Ujo)this.table);
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(this.getTableModel().getClass());
        if (this.columns == null) {
            this.columns = new ArrayList(list.size());
        } else {
            this.columns.clear();
        }
        int n = 1;
        for (MetaColumn metaColumn : MetaTable.COLUMNS.getList((Ujo)this.table)) {
            if (metaColumn.isForeignKey()) {
                ColumnWrapper columnWrapper;
                boolean bl = hashSet.add(metaColumn.getType());
                if (bl) {
                    columnWrapper = metaColumn;
                } else {
                    ++n;
                    columnWrapper = new ColumnWrapperImpl(metaColumn, GENERATED_ALIAS_PREFIX + n);
                }
                ColumnWrapper columnWrapper2 = columnWrapper;
                this.addMissingColumn(columnWrapper2, true, false, metaColumn.isOptionalRelation());
                continue;
            }
            this.columns.add(metaColumn);
        }
        return this;
    }

    @Nonnull
    public Query<UJO> addColumn(@Nonnull Key<UJO, ?> key) throws IllegalArgumentException {
        ColumnWrapper columnWrapper;
        this.clearDecoder();
        MetaColumn metaColumn = (MetaColumn)this.getHandler().findColumnModel(this.getLastProperty(key));
        Assert.notNull((Object)metaColumn, (Object[])new Object[]{"Column {} was not foud in the meta-model", key.getFullName()});
        ColumnWrapper columnWrapper2 = columnWrapper = key.isComposite() ? new ColumnWrapperImpl(metaColumn, key) : metaColumn;
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnWrapper>(this.getDefaultColumns());
        }
        this.addMissingColumn(columnWrapper, true, true, metaColumn.isOptionalRelation());
        return this;
    }

    public Query<UJO> setColumn(@Nonnull Key<UJO, ?> key) throws IllegalArgumentException {
        return this.setColumns(false, key);
    }

    public final Query<UJO> setColumns(boolean bl, Key ... keyArray) throws IllegalArgumentException {
        return this.setColumns(bl, true, keyArray);
    }

    @Nonnull
    public final Query<UJO> setColumns(@Nonnull Collection<ColumnWrapper> collection) throws IllegalArgumentException {
        this.clearDecoder();
        this.columns = new ArrayList<ColumnWrapper>(collection);
        return this;
    }

    @Nonnull
    public final Query<UJO> setColumns(boolean bl, boolean bl2, Key<UJO, ?> ... keyArray) throws IllegalArgumentException {
        this.clearDecoder();
        if (keyArray.length > 1) {
            Arrays.sort(keyArray, INNER_KEY_COMPARATOR);
        }
        this.columns = new ArrayList(keyArray.length + 3);
        OrmHandler ormHandler = this.getHandler();
        for (Key<UJO, ?> key : keyArray) {
            MetaColumn metaColumn = (MetaColumn)ormHandler.findColumnModel(this.getLastProperty(key), true);
            ColumnWrapper columnWrapper = key.isComposite() ? new ColumnWrapperImpl(metaColumn, key) : metaColumn;
            this.addMissingColumn(columnWrapper, bl2, false, metaColumn.isOptionalRelation());
        }
        if (bl) {
            this.addMissingColumn(this.table.getFirstPK(), false, true, false);
        }
        return this;
    }

    protected void addMissingColumn(@Nonnull ColumnWrapper columnWrapper, boolean bl, boolean bl2, boolean bl3) {
        Key key = columnWrapper.getKey();
        MetaColumn metaColumn = columnWrapper.getModel();
        if (bl3) {
            this.addOuterJoin(key);
        }
        if (bl2 && !metaColumn.isForeignKey()) {
            int n = columnWrapper.hashCode();
            for (ColumnWrapper columnWrapper2 : this.columns) {
                if (columnWrapper2.hashCode() != n || !columnWrapper.equals(columnWrapper2)) continue;
                return;
            }
        }
        if (bl) {
            if (metaColumn.isForeignKey()) {
                for (ColumnWrapper columnWrapper3 : metaColumn.getForeignTable().getColumns()) {
                    ColumnWrapper columnWrapper2;
                    columnWrapper2 = key.add(columnWrapper3.getKey());
                    ColumnWrapperImpl columnWrapperImpl = new ColumnWrapperImpl(columnWrapper3.getModel(), (Key)columnWrapper2);
                    this.addMissingColumn(columnWrapperImpl, false, true, false);
                }
            } else {
                this.columns.add(columnWrapper);
            }
        } else {
            this.columns.add(columnWrapper);
        }
    }

    private Key getLastProperty(@Nonnull Key<UJO, ?> key) {
        return key.isComposite() ? ((CompositeKey)key).getLastKey() : key;
    }

    @Nonnull
    public Query<UJO> orderBy(@Nullable Collection<Key<UJO, ?>> collection) {
        this.clearDecoder();
        if (collection == null) {
            return this.orderByMany(new Key[0]);
        }
        this.orderBy.clear();
        this.orderBy.addAll(collection);
        return this;
    }

    @Nonnull
    public Query<UJO> addOrderBy(Key<UJO, ?> ... keyArray) {
        this.clearDecoder();
        for (Key<UJO, ?> key : keyArray) {
            this.orderBy.add(key);
        }
        return this;
    }

    @Nonnull
    public Query<UJO> addOrderBy(@Nonnull Key<UJO, ?> key) {
        this.clearDecoder();
        this.orderBy.add(key);
        return this;
    }

    public ColumnWrapper readOrderColumn(int n) throws IllegalArgumentException {
        Key<UJO, ?> key = this.orderBy.get(n);
        Object t = this.session.getHandler().findColumnModel(key);
        Assert.isTrue((boolean)(t instanceof MetaColumn), (Object[])new Object[]{"The key '{}.{}' is not persistent table column", this.table.getType().getSimpleName(), key});
        return key.isComposite() ? new ColumnWrapperImpl((MetaColumn)t, key) : (MetaColumn)t;
    }

    @Nonnull
    public Query<UJO> addInnerJoin(@Nonnull Key<UJO, ? extends OrmTable> key) throws IllegalArgumentException {
        return this.modifyJoin(false, key);
    }

    @Nonnull
    public Query<UJO> addOuterJoin(@Nonnull Key<UJO, ? extends OrmTable> key) throws IllegalArgumentException {
        return this.modifyJoin(true, key);
    }

    @Nonnull
    protected Query<UJO> modifyJoin(boolean bl, @Nonnull Key<UJO, ? extends OrmTable> key) throws IllegalArgumentException {
        ColumnWrapper columnWrapper;
        this.sqlStatement = null;
        if (this.outerJoins == null) {
            this.outerJoins = new HashSet<ColumnWrapper>();
        }
        MetaColumn metaColumn = (MetaColumn)this.getHandler().findColumnModel(key, true);
        ColumnWrapper columnWrapper2 = columnWrapper = key.isComposite() ? new ColumnWrapperImpl(metaColumn, key) : metaColumn;
        if (bl) {
            this.outerJoins.add(columnWrapper);
            if (metaColumn.isMandatory()) {
                LOGGER.log(UjoLogger.WARN, "The relation is required: {}", key);
            }
        } else {
            this.outerJoins.remove(columnWrapper);
        }
        return this;
    }

    public Set<ColumnWrapper> getOuterJoins() {
        return this.outerJoins != null ? this.outerJoins : Collections.emptySet();
    }

    public boolean isOffset() {
        return this.offset > 0L;
    }

    public final long getOffset() {
        return this.offset;
    }

    @Nonnull
    public Query<UJO> setOffset(int n) {
        this.offset = n;
        this.sqlStatement = null;
        return this;
    }

    public final boolean isLimit() {
        return this.limit > 0;
    }

    public final int getLimit() {
        return this.limit;
    }

    @Nonnull
    public Query<UJO> setLimit(int n) {
        this.limit = n;
        this.sqlStatement = null;
        return this;
    }

    @Nonnull
    public Query<UJO> setLimit(int n, long l) {
        this.limit = n;
        this.offset = l;
        this.sqlStatement = null;
        return this;
    }

    @Deprecated
    public final Query<UJO> setMaxRows(int n) {
        return this.setLimit(n);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    @Nonnull
    public Query<UJO> setFetchSize(int n) {
        this.fetchSize = n;
        this.sqlStatement = null;
        return this;
    }

    @Nonnull
    public PreparedStatement getStatement() {
        return this.session.getStatement(this).getPreparedStatement();
    }

    @Nonnull
    public String getSqlStatement(boolean bl) {
        if (bl || this.sqlStatement == null) {
            try {
                MetaDatabase metaDatabase = this.table.getDatabase();
                this.sqlStatement = metaDatabase.getDialect().printSelect(this.table, this, false, new StringBuilder(360)).toString();
            }
            catch (IOException iOException) {
                throw new IllegalUjormException(this.table.getType().getName(), (Throwable)iOException);
            }
        }
        return this.sqlStatement;
    }

    public boolean isLockRequest() {
        return this.lockRequest;
    }

    @Nonnull
    public Query<UJO> setLockRequest(boolean bl) {
        this.lockRequest = bl;
        this.sqlStatement = null;
        return this;
    }

    public Query<UJO> setLockRequest() {
        return this.setLockRequest(true);
    }

    @Nonnull
    public String toString() {
        return this.getSqlStatement(false);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Nonnull
    public Query<UJO> setDistinct(boolean bl) {
        this.distinct = bl;
        this.sqlStatement = null;
        return this;
    }

    public Query<UJO> setDistinct() {
        return this.setDistinct(true);
    }

    @Nullable
    public SqlParameters getSqlParameters() {
        return this.sqlParameters;
    }

    @Nonnull
    public Query<UJO> setSqlParameters(@Nullable SqlParameters sqlParameters) throws IllegalArgumentException {
        this.sqlParameters = sqlParameters;
        return this;
    }

    public Query<UJO> setSqlParameters(Object ... objectArray) throws IllegalArgumentException {
        return this.setSqlParameters(new SqlParameters(objectArray));
    }
}

