/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.implementation.orm.OrmProperty;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Check;

public class NativeDbSequencer
extends UjoSequencer {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(OrmProperty.class);

    public NativeDbSequencer(MetaTable metaTable) {
        super(metaTable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized long nextValue(Session session) {
        String string = (String)MetaTable.SEQUENCE.of((Ujo)this.table);
        if (!Check.hasLength((CharSequence)string)) return super.nextValue(session);
        try (Statement statement = session.getFirstConnection().createStatement();){
            Throwable throwable;
            ResultSet resultSet;
            block25: {
                long l;
                block26: {
                    resultSet = statement.executeQuery(this.createNextSequence(string));
                    throwable = null;
                    if (!resultSet.next()) break block25;
                    l = resultSet.getLong(1);
                    if (resultSet == null) return l;
                    if (throwable == null) break block26;
                    try {
                        resultSet.close();
                        return l;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return l;
                    }
                }
                resultSet.close();
                return l;
            }
            try {
                try {
                    throw new IllegalUjormException("No value for sequence: " + string);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (resultSet == null) throw throwable4;
                if (throwable == null) {
                    resultSet.close();
                    throw throwable4;
                }
                try {
                    resultSet.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException | RuntimeException | SQLException exception) {
            String string2 = "Sequence error for name: " + string;
            LOGGER.log(UjoLogger.ERROR, string2, (Throwable)exception);
            throw new IllegalUjormException(string2, (Throwable)exception);
        }
    }

    public String createNextSequence(String string) throws IOException {
        return this.table.getDatabase().getDialect().printNextSequence(string, this.table, new StringBuilder(128)).toString();
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException("Reset is unsupported for the table " + this.getTableName());
    }
}

