/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.UjoDecorator;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoManager;
import org.ujorm.core.UjoManagerXML;
import org.ujorm.extensions.NativeUjoDecorator;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.InitializationBatch;
import org.ujorm.orm.OrmHandlerProvider;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaRoot;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.template.AliasTable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;

@Immutable
public class OrmHandler
implements OrmHandlerProvider {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(OrmHandler.class);
    private final MetaRoot databases = new MetaRoot();
    private MetaRoot configuration;
    private Session defaultSession;
    private final HashMap<Key, MetaRelation2Many> propertyMap = new HashMap();
    private final HashMap<Class, MetaTable> entityMap = new HashMap();
    private final HashMap<Class, MetaProcedure> procedureMap = new HashMap();

    public OrmHandler() {
    }

    public <UJO extends OrmUjo> OrmHandler(Class<UJO> clazz) {
        this();
        this.loadDatabase(clazz);
    }

    public <UJO extends OrmUjo> OrmHandler(Class<UJO> ... classArray) {
        this();
        this.loadDatabase(classArray);
    }

    public Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.createSession();
        }
        return this.defaultSession;
    }

    public Session getSession() {
        return this.getDefaultSession();
    }

    public Session createSession() {
        return new Session(this);
    }

    public boolean config(String string) throws IllegalUjormException {
        try {
            if (string.startsWith("~")) {
                String string2 = System.getProperty("user.home") + string.substring(1);
                return this.config(new File(string2).toURI().toURL(), true);
            }
            return this.config(new URL(string), true);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalUjormException("Configuration file is not valid " + string, (Throwable)malformedURLException);
        }
    }

    public void config(MetaParams metaParams) throws IllegalArgumentException {
        MetaRoot.PARAMETERS.setValue((Ujo)this.databases, (Object)metaParams);
    }

    public void config(MetaRoot metaRoot) throws IllegalArgumentException {
        this.configuration = metaRoot;
        MetaParams metaParams = (MetaParams)((Object)MetaRoot.PARAMETERS.of((Ujo)this.configuration));
        if (metaParams != null) {
            this.config(metaParams);
        }
    }

    public boolean config(URL uRL, boolean bl) throws IllegalUjormException {
        try {
            MetaRoot metaRoot = (MetaRoot)UjoManagerXML.getInstance().parseXML((InputStream)new BufferedInputStream(uRL.openStream()), MetaRoot.class, (Object)this);
            this.config(metaRoot);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            if (bl) {
                throw new IllegalUjormException("Configuration file is not valid ", (Throwable)exception);
            }
            return false;
        }
    }

    public boolean isPersistent(Key key) {
        boolean bl = key.isTypeOf(List.class) || UjoManager.getInstance().isTransient(key);
        return !bl;
    }

    private <UJO extends OrmUjo> MetaDatabase loadDatabaseInternal(UjoDecorator<UJO> ujoDecorator) {
        String string = ((OrmUjo)ujoDecorator.getDomain()).getClass().getSimpleName();
        MetaDatabase metaDatabase = this.configuration != null ? this.configuration.removeDb(string) : null;
        MetaDatabase metaDatabase2 = new MetaDatabase(this, ujoDecorator, metaDatabase, this.databases.getDatabaseCount());
        this.databases.add(metaDatabase2);
        return metaDatabase2;
    }

    public final <UJO extends OrmUjo> void loadDatabase(Class<UJO> clazz) {
        this.loadDatabase(NativeUjoDecorator.of(clazz));
    }

    public final synchronized <UJO extends OrmUjo> void loadDatabase(Class<UJO> ... classArray) {
        UjoDecorator[] ujoDecoratorArray = new UjoDecorator[classArray.length];
        for (int i = classArray.length - 1; i >= 0; --i) {
            ujoDecoratorArray[i] = NativeUjoDecorator.of(classArray[i]);
        }
        this.loadDatabase(ujoDecoratorArray);
    }

    public final synchronized <UJO extends OrmUjo> void loadDatabase(UjoDecorator<UJO> ... ujoDecoratorArray) {
        block13: {
            File file;
            Assert.isFalse((boolean)this.isReadOnly(), (Object[])new Object[]{"The meta-model is locked and can\u00b4t be changed."});
            Assert.hasLength((Object[])ujoDecoratorArray, (Object[])new Object[]{"databaseModel is required"});
            for (UjoDecorator<UJO> object2 : ujoDecoratorArray) {
                this.loadDatabaseInternal(object2);
            }
            MetaParams metaParams = this.getParameters();
            Object object3 = this.propertyMap.values().iterator();
            while (object3.hasNext()) {
                MetaRelation2Many metaRelation2Many = object3.next();
                if (!metaRelation2Many.isColumn()) continue;
                ((MetaColumn)metaRelation2Many).initTypeCode();
            }
            this.databases.lock();
            Object object = object3 = (Boolean)MetaParams.LOG_METAMODEL_INFO.of(metaParams) != false ? UjoLogger.INFO : UjoLogger.DEBUG;
            if (LOGGER.isLoggable((Level)object3)) {
                String string = "DATABASE META-MODEL:\n" + this.getConfig();
                LOGGER.log((Level)object3, string);
            }
            if ((file = (File)MetaParams.SAVE_CONFIG_TO_FILE.of((Ujo)this.getParameters())) != null) {
                try {
                    this.databases.print(file);
                }
                catch (IOException iOException) {
                    throw new IllegalUjormException("Can't create configuration " + file, (Throwable)iOException);
                }
            }
            for (MetaDatabase metaDatabase : this.getDatabases()) {
                metaDatabase.create(this.getDefaultSession());
            }
            InitializationBatch initializationBatch = metaParams.getInitializationBatch();
            if (initializationBatch != null) {
                Session session;
                Session session2 = null;
                try {
                    session = this.createSession();
                    LOGGER.log(UjoLogger.INFO, "The initializaton batch is running: {}", (Object)initializationBatch.getClass().getName());
                    initializationBatch.run(session);
                    session.commit();
                    session.close();
                    if (session == null) break block13;
                    session.rollback();
                }
                catch (Exception exception) {
                    try {
                        String string = "The batch failed: " + initializationBatch.getClass().getName();
                        LOGGER.log(UjoLogger.ERROR, string, (Throwable)exception);
                        throw new IllegalUjormException(string, (Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        if (session2 != null) {
                            session2.rollback();
                            session2.close();
                        }
                        throw throwable;
                    }
                }
                session.close();
            }
        }
    }

    public boolean isReadOnly() {
        List<MetaDatabase> list = this.getDatabases();
        boolean bl = Check.hasLength(list) ? list.get(0).readOnly() : false;
        return bl;
    }

    @Nonnull
    public MetaRoot getDatabaseModel() {
        return this.databases;
    }

    public void addProcedureModel(@Nonnull MetaProcedure metaProcedure) {
        this.procedureMap.put(((Key)MetaProcedure.DB_PROPERTY.of((Ujo)metaProcedure)).getType(), metaProcedure);
    }

    public void addTableModel(@Nonnull MetaTable metaTable) {
        this.entityMap.put(metaTable.getType(), metaTable);
    }

    public void addColumnModel(@Nonnull MetaRelation2Many metaRelation2Many) {
        Key key = metaRelation2Many.getKey();
        Object t = this.findColumnModel(key);
        if (t == null) {
            this.propertyMap.put(key, metaRelation2Many);
        } else {
            Class<OrmUjo> clazz = ((MetaRelation2Many)((Object)t)).getTableClass();
            Class<OrmUjo> clazz2 = metaRelation2Many.getTableClass();
            if (clazz2.isAssignableFrom(clazz)) {
                this.propertyMap.put(key, metaRelation2Many);
            }
        }
    }

    @Deprecated
    public <T extends Annotation> T findAnnotation(Key<?, ?> key, Class<T> clazz) {
        return (T)UjoManager.findAnnotation(key, clazz);
    }

    public final <T extends MetaRelation2Many> T findColumnModel(Key key) {
        return this.findColumnModel(key, false);
    }

    public <T extends MetaRelation2Many> T findColumnModel(Key key, boolean bl) throws IllegalUjormException {
        if (key != null && key.isComposite()) {
            key = ((CompositeKey)key).getLastKey();
        }
        MetaRelation2Many metaRelation2Many = this.propertyMap.get(key);
        if (bl && metaRelation2Many == null) {
            String string = key != null ? key.getFullName() : String.valueOf(key);
            throw new IllegalUjormException("The key " + string + " have got no meta-model.");
        }
        return (T)((Object)metaRelation2Many);
    }

    @Nonnull
    public final TableWrapper findTableModel(Key key) throws IllegalStateException {
        if (key instanceof CompositeKey) {
            CompositeKey compositeKey = (CompositeKey)key;
            Key key2 = compositeKey.getLastKey();
            String string = compositeKey.getAlias(compositeKey.getKeyCount() - 1);
            return this.findTableModel(key2.getDomainType()).addAlias(string);
        }
        return this.findTableModel(key.getDomainType());
    }

    @Nonnull
    public final MetaTable findTableModel(Class<? extends OrmUjo> clazz) throws IllegalStateException {
        return this.findTableModel(clazz, true);
    }

    @Nonnull
    public MetaTable findTableModel(Class<? extends OrmUjo> clazz, boolean bl) throws IllegalUjormException {
        MetaTable metaTable = this.entityMap.get(clazz);
        Assert.isFalse((metaTable == null && bl ? 1 : 0) != 0, (Object[])new Object[]{"An entity mapping bug: the {} is not mapped to the Database.", clazz});
        return metaTable;
    }

    @Nonnull
    public MetaProcedure findProcedureModel(Class<? extends DbProcedure> clazz) throws IllegalUjormException {
        MetaProcedure metaProcedure = this.procedureMap.get(clazz);
        Assert.notNull((Object)((Object)metaProcedure), (Object[])new Object[]{"An procedure mapping bug: the {} is not mapped to the Database.", clazz});
        return metaProcedure;
    }

    @Nonnull
    public MetaParams getParameters() {
        return (MetaParams)((Object)MetaRoot.PARAMETERS.of((Ujo)this.databases));
    }

    public boolean isDatabaseLoaded() {
        int n = MetaRoot.DATABASES.getItemCount((Ujo)this.databases);
        return n > 0;
    }

    @Nonnull
    public List<MetaDatabase> getDatabases() {
        return MetaRoot.DATABASES.getList((Ujo)this.databases);
    }

    public List<Key> findPropertiesByType(Class clazz) {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        for (Key key : this.propertyMap.keySet()) {
            if (!key.isTypeOf(clazz)) continue;
            arrayList.add(key);
        }
        return arrayList;
    }

    public String getConfig() {
        return this.databases.toString();
    }

    @Override
    @Nonnull
    public OrmHandler getOrmHandler() {
        return this;
    }

    public <UJO extends OrmUjo> AliasTable<UJO> tableOf(Class<UJO> clazz, String string) {
        return AliasTable.of(clazz, string, this);
    }

    public <UJO extends OrmUjo> AliasTable<UJO> tableOf(Class<UJO> clazz) {
        return AliasTable.of(clazz, this);
    }

    @Deprecated
    public <UJO extends OrmUjo> AliasTable<UJO> alias(Class<UJO> clazz, String string) {
        return this.tableOf(clazz, string);
    }
}

