/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.impl;

import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.metaModel.MetaColumn;

public class ColumnWrapperImpl
implements ColumnWrapper {
    private MetaColumn column;
    private String tableAlias;
    private Key key;

    public ColumnWrapperImpl(MetaColumn metaColumn, String string) {
        this(metaColumn, string, metaColumn.getKey());
    }

    public ColumnWrapperImpl(MetaColumn metaColumn, Key key) {
        this(metaColumn, key.isComposite() ? ColumnWrapperImpl.getAlias((CompositeKey)key) : null, key);
    }

    public ColumnWrapperImpl(MetaColumn metaColumn, String string, Key key) {
        assert (metaColumn != null) : "The MetaColumn is required";
        this.column = metaColumn;
        this.tableAlias = string != null ? string : metaColumn.getTableAlias();
        this.key = key != null ? key : metaColumn.getKey();
    }

    private static String getAlias(CompositeKey compositeKey) {
        int n = compositeKey.getKeyCount();
        return n > 1 ? compositeKey.getAlias(n - 2) : null;
    }

    @Override
    public MetaColumn getModel() {
        return this.column;
    }

    @Override
    public String getName() {
        return this.column.getName();
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public TableWrapper buildTableWrapper() {
        return this.column.getTable().addAlias(this.tableAlias);
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public boolean isCompositeKey() {
        return this.key.isComposite();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ColumnWrapper) {
            ColumnWrapper columnWrapper = (ColumnWrapper)object;
            Key key = columnWrapper.getKey();
            Key key2 = this.getKey();
            boolean bl = key2.getName().equals(key.getName()) && key2.getDomainType() == key.getDomainType() && this.getTableAlias().equals(columnWrapper.getTableAlias());
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().getName().hashCode();
    }

    public String toString() {
        return this.key.getFullName();
    }
}

