/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.ujorm.Ujo;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;

public class PostgreSqlDialect
extends SqlDialect {
    @Override
    public String getJdbcUrl() {
        return "";
    }

    @Override
    public String getJdbcDriver() {
        return "org.postgresql.Driver";
    }

    @Override
    public Appendable printCreateSchema(String string, Appendable appendable) throws IOException {
        appendable.append("CREATE SCHEMA ");
        appendable.append(string);
        return appendable;
    }

    @Override
    protected String getColumnType(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case CLOB: {
                if (metaColumn.isTypeOf(String.class)) {
                    return "TEXT";
                }
            }
            case BLOB: 
            case BINARY: {
                return "BYTEA";
            }
        }
        return super.getColumnType(metaColumn);
    }

    @Override
    public Appendable printIndex(MetaIndex metaIndex, Appendable appendable) throws IOException {
        super.printIndex(metaIndex, appendable);
        if (((Boolean)MetaIndex.UNIQUE.of((Ujo)metaIndex)).booleanValue()) {
            this.printIndexCondition(metaIndex, appendable);
        }
        return appendable;
    }

    public Appendable printIndexCondition(MetaIndex metaIndex, Appendable appendable) throws IOException {
        String string = " WHERE ";
        for (MetaColumn metaColumn : MetaIndex.COLUMNS.getList((Ujo)metaIndex)) {
            if (metaColumn.hasDefaultValue()) continue;
            appendable.append(string);
            this.printColumnName(metaColumn, appendable);
            appendable.append(" IS NOT NULL");
            string = " AND ";
        }
        return appendable;
    }

    @Override
    public void printOffset(Query query, Appendable appendable) throws IOException {
        if (query.isOffset()) {
            appendable.append(" OFFSET " + query.getOffset());
        }
    }

    @Override
    public Appendable printDelete(CriterionDecoder criterionDecoder, Appendable appendable) throws IOException {
        appendable.append("DELETE FROM ");
        TableWrapper[] tableWrapperArray = criterionDecoder.getTablesSorted();
        for (int i = 0; i < tableWrapperArray.length; ++i) {
            if (i > 0) {
                appendable.append(i == 1 ? " USING " : ", ");
            }
            this.printTableAliasDefinition(tableWrapperArray[i], appendable);
        }
        String string = criterionDecoder.getWhere();
        if (string.length() > 0) {
            appendable.append(" WHERE ");
            appendable.append(string);
        }
        return appendable;
    }

    @Override
    @Nonnull
    public String getCriterionTemplate(@Nonnull ValueCriterion valueCriterion) {
        switch (valueCriterion.getOperator()) {
            case STARTS_CASE_INSENSITIVE: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "{0} ILIKE {1}";
            }
        }
        return super.getCriterionTemplate(valueCriterion);
    }
}

