/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.Validator;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.UjoManager;
import org.ujorm.extensions.ValueWrapper;
import org.ujorm.implementation.orm.RelationToOne;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.DbType;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.ITypeService;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.TypeService;
import org.ujorm.orm.annot.Column;
import org.ujorm.orm.annot.Comment;
import org.ujorm.orm.ao.QuoteEnum;
import org.ujorm.orm.ao.UjoStatement;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.MsgFormatter;
import org.ujorm.validator.ValidatorUtils;

@Immutable
public final class MetaColumn
extends MetaRelation2Many
implements ColumnWrapper {
    private static final Class<MetaColumn> CLASS = MetaColumn.class;
    public static final String AUTO_INDEX_NAME = "AUTO";
    private static final KeyFactory<MetaColumn> fa = KeyFactory.CamelBuilder.get(CLASS);
    public static final Key<MetaColumn, Boolean> PRIMARY_KEY = fa.newKey("primaryKey", (Object)false);
    public static final Key<MetaColumn, QuoteEnum> QUOTED = fa.newKey("quoted", (Object)QuoteEnum.BY_CONFIG);
    public static final Key<MetaColumn, DbType> DB_TYPE = fa.newKey("dbType", (Object)DbType.NULL);
    public static final Key<MetaColumn, Boolean> MANDATORY = fa.newKey("mandatory", (Object)false);
    public static final Key<MetaColumn, Integer> MAX_LENGTH = fa.newKey("maxLength", (Object)-1);
    public static final Key<MetaColumn, Integer> PRECISION = fa.newKey("precision", (Object)-1);
    public static final Key<MetaColumn, String> DEFAULT_VALUE = fa.newKey("default", (Object)"");
    public static final ListKey<MetaColumn, String> INDEX = fa.newListKey("index");
    public static final ListKey<MetaColumn, String> UNIQUE_INDEX = fa.newListKey("uniqueIndex");
    public static final Key<MetaColumn, String> CONSTRAINT_NAME = fa.newKey("constraintName", (Object)"");
    public static final Key<MetaColumn, Class<? extends ITypeService>> CONVERTER = fa.newClassKey("converter", ITypeService.class);
    public static final Key<MetaColumn, String> COMMENT = fa.newKey("comment", (Object)"");
    private List<MetaColumn> relatedModel;
    private String[] foreignNames = null;
    private static final String[] EMPTY_NAMES;
    private char typeCode;
    private final boolean foreignKey;
    private final boolean isValueWrapper;
    private final ITypeService converter;

    public MetaColumn() {
        this(null);
    }

    public MetaColumn(ITypeService iTypeService) {
        this.converter = iTypeService;
        this.foreignKey = false;
        this.isValueWrapper = false;
    }

    public MetaColumn(@Nonnull MetaTable metaTable, @Nonnull Key key, @Nullable MetaColumn metaColumn) {
        super(metaTable, key, metaColumn);
        Comment comment;
        Validator validator;
        Column column;
        this.foreignKey = this.isTypeOf(OrmUjo.class);
        this.isValueWrapper = this.isTypeOf(ValueWrapper.class);
        UjoManager.getInstance();
        Field field = UjoManager.getPropertyField(metaTable.getType(), (Key)key);
        Column column2 = column = field != null ? field.getAnnotation(Column.class) : null;
        if (metaColumn != null) {
            this.changeDefault(this, PRIMARY_KEY, PRIMARY_KEY.of((Ujo)metaColumn));
            this.changeDefault(this, MANDATORY, MANDATORY.of((Ujo)metaColumn));
            this.changeDefault(this, MAX_LENGTH, MAX_LENGTH.of((Ujo)metaColumn));
            this.changeDefault(this, PRECISION, PRECISION.of((Ujo)metaColumn));
            this.changeDefault(this, DB_TYPE, DB_TYPE.of((Ujo)metaColumn));
            this.changeDefault(this, INDEX, INDEX.of((Ujo)metaColumn));
            this.changeDefault(this, UNIQUE_INDEX, UNIQUE_INDEX.of((Ujo)metaColumn));
            this.changeDefault(this, COMMENT, COMMENT.of((Ujo)metaColumn));
            this.changeDefault(this, CONVERTER, CONVERTER.of((Ujo)metaColumn));
            this.changeDefault(this, QUOTED, QUOTED.of((Ujo)metaColumn));
        }
        if (column != null) {
            this.changeDefault(this, PRIMARY_KEY, column.pk());
            this.changeDefault(this, MANDATORY, column.mandatory());
            this.changeDefault(this, MAX_LENGTH, column.length());
            this.changeDefault(this, PRECISION, column.precision());
            this.changeDefault(this, DB_TYPE, column.type());
            this.changeDefault(this, INDEX, MetaColumn.toList(column.index()));
            this.changeDefault(this, UNIQUE_INDEX, MetaColumn.toList(column.uniqueIndex()));
            this.changeDefault(this, CONSTRAINT_NAME, column.constraintName());
            this.changeDefault(this, CONVERTER, column.converter());
            this.changeDefault(this, QUOTED, column.quoted());
        }
        if ((validator = key.getValidator()) != null) {
            this.changeDefault(this, MANDATORY, ValidatorUtils.isMandatoryValidator((Validator)validator));
            this.changeDefault(this, MAX_LENGTH, ValidatorUtils.getMaxLength((Validator)validator));
        }
        if (field != null && (comment = field.getAnnotation(Comment.class)) != null) {
            this.changeDefault(this, COMMENT, comment.value());
        }
        comment = CONVERTER.isDefault((Ujo)this) ? null : (Class)CONVERTER.of((Ujo)this);
        this.converter = this.getHandler().getParameters().getConverter(comment);
        if (DB_TYPE.isDefault((Ujo)this)) {
            metaTable.getDatabase().changeDbType(this);
        }
        if (MAX_LENGTH.isDefault((Ujo)this)) {
            metaTable.getDatabase().changeDbLength(this);
        }
        if (QUOTED.isDefault((Ujo)this)) {
            switch (this.getHandler().getParameters().get(MetaParams.QUOTATION_POLICY)) {
                case QUOTE_SQL_NAMES: {
                    QUOTED.setValue((Ujo)this, (Object)QuoteEnum.YES);
                    break;
                }
                case QUOTE_ONLY_SQL_KEYWORDS: {
                    QUOTED.setValue((Ujo)this, (Object)QuoteEnum.BY_CONFIG);
                }
                default: {
                    QUOTED.setValue((Ujo)this, (Object)QuoteEnum.NO);
                }
            }
        }
    }

    private static final List<String> toList(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return Collections.emptyList();
        }
        if (stringArray.length == 1 && Check.isEmpty((CharSequence)stringArray[0])) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    @Override
    public boolean isColumn() {
        return true;
    }

    @Override
    public final boolean isForeignKey() {
        return this.foreignKey;
    }

    @Override
    public final boolean isValueWrapper() {
        return this.isValueWrapper;
    }

    public final boolean isPrimaryKey() {
        return (Boolean)PRIMARY_KEY.of((Ujo)this);
    }

    public final boolean isOptionalRelation() {
        return this.foreignKey && (Boolean)MANDATORY.of((Ujo)this) == false;
    }

    public final boolean isCommented() {
        return !COMMENT.isDefault((Ujo)this);
    }

    public final String getComment() {
        return (String)COMMENT.of((Ujo)this);
    }

    public final int getMaxLength() {
        return (Integer)MAX_LENGTH.of((Ujo)this);
    }

    public final int getPrecision() {
        return (Integer)PRECISION.of((Ujo)this);
    }

    public final boolean isMandatory() {
        return (Boolean)MANDATORY.of((Ujo)this);
    }

    public MetaTable getForeignTable() {
        return this.getForeignColumns().get(0).getTable();
    }

    public List<MetaColumn> getForeignColumns() {
        if (this.relatedModel == null) {
            this.relatedModel = this.createForeignColumns();
        }
        return this.relatedModel;
    }

    private List<MetaColumn> createForeignColumns() throws IllegalUjormException {
        ArrayList<MetaColumn> arrayList;
        if (this.getKey() instanceof RelationToOne) {
            RelationToOne relationToOne = (RelationToOne)((Object)TABLE_KEY.of((Ujo)this));
            MetaColumn metaColumn = (MetaColumn)this.getHandler().findColumnModel(relationToOne.getRelatedKey(), true);
            arrayList = new ArrayList<MetaColumn>(1);
            arrayList.add(metaColumn);
        } else {
            MetaTable metaTable = this.getHandler().findTableModel(this.getType());
            if (metaTable != null) {
                MetaPKey metaPKey = (MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable));
                arrayList = MetaPKey.COLUMNS.getList((Ujo)metaPKey);
            } else {
                arrayList = Collections.emptyList();
            }
        }
        Assert.hasLength(arrayList, (Object[])new Object[]{"The relation column {} have no foreign keys", this});
        return arrayList;
    }

    private String[] getForeignColumnNames() {
        if (this.foreignNames == null) {
            if (this.isForeignKey()) {
                List<MetaColumn> list = this.getForeignColumns();
                StringTokenizer stringTokenizer = new StringTokenizer(list.size() == 1 ? this.getName() : "", ", ");
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (MetaColumn metaColumn : list) {
                    String string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "fk_" + (String)NAME.of((Ujo)this) + "_" + (String)NAME.of((Ujo)metaColumn);
                    arrayList.add(string);
                }
                this.foreignNames = arrayList.toArray(new String[arrayList.size()]);
            } else {
                this.foreignNames = EMPTY_NAMES;
            }
        }
        return this.foreignNames;
    }

    public final String getForeignColumnName(int n) {
        return this.getForeignColumnNames()[n];
    }

    public Object getValue(OrmUjo ormUjo) {
        Key key = super.getKey();
        Object object = key.of((Ujo)ormUjo);
        return object;
    }

    public void setValueRaw(@Nonnull Ujo ujo, @Nullable Object object) {
        if (this.isValueWrapper) {
            this.setValue(ujo, ValueWrapper.getInstance((Class)this.getType(), (Object)object));
        } else {
            this.setValue(ujo, object);
        }
    }

    public void setValue(@Nonnull Ujo ujo, @Nullable Object object) {
        Key key = super.getKey();
        if (this.isForeignKey() && object != null && !(object instanceof OrmUjo)) {
            object = new ForeignKey(object);
        }
        key.setValue(ujo, object);
    }

    public Class getType() {
        return ((Key)TABLE_KEY.of((Ujo)this)).getType();
    }

    @Override
    public final String getName() {
        return (String)NAME.of((Ujo)this);
    }

    public String getFullName() {
        try {
            StringBuilder stringBuilder = new StringBuilder(32);
            MetaTable metaTable = (MetaTable)TABLE.of((Ujo)this);
            metaTable.getDatabase().getDialect().printFullTableName(metaTable, stringBuilder);
            stringBuilder.append('.');
            stringBuilder.append(this.getName());
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalUjormException(iOException.getMessage(), (Throwable)iOException);
        }
    }

    public String getColumnAlias() {
        try {
            String string = ((MetaTable)TABLE.of((Ujo)this)).getDatabase().getDialect().printColumnAlias(this, new StringBuilder(32)).toString();
            return string;
        }
        catch (IOException iOException) {
            throw new IllegalUjormException(iOException.getMessage(), (Throwable)iOException);
        }
    }

    public void printForeignColumnFullName(int n, Appendable appendable) throws IOException {
        SqlDialect sqlDialect = ((MetaTable)TABLE.of((Ujo)this)).getDatabase().getDialect();
        sqlDialect.printQuotedName(this.getTableAlias(), QuoteEnum.BY_CONFIG, appendable);
        appendable.append('.');
        sqlDialect.printQuotedName(this.getForeignColumnNames()[n], QuoteEnum.BY_CONFIG, appendable);
    }

    public char getTypeCode() {
        return this.typeCode;
    }

    public boolean hasDefaultValue() {
        Object object = super.getKey().getDefault();
        boolean bl = object instanceof String ? ((String)object).length() > 0 : object != null;
        return bl;
    }

    public Object getJdbcFriendlyDefaultValue() {
        Object object = new UjoStatement().getDefaultValue(this);
        return object;
    }

    public Class getDialectClass() {
        Class<? extends SqlDialect> clazz = ((MetaTable)TABLE.of((Ujo)this)).getDatabase().get(MetaDatabase.DIALECT);
        return clazz;
    }

    public String getDialectName() {
        return this.getDialectClass().getSimpleName();
    }

    public void initTypeCode() {
        List<MetaColumn> list;
        this.checkReadOnly(true);
        this.typeCode = TypeService.getTypeCode(this);
        if (this.isForeignKey() && (list = this.getForeignColumns()).size() > 0) {
            DB_TYPE.setValue((Ujo)this, DB_TYPE.of((Ujo)list.get(0)));
        }
    }

    public boolean isVoid() {
        return this.isTypeOf(Void.class);
    }

    public String getConstraintName() {
        return (String)CONSTRAINT_NAME.of((Ujo)this);
    }

    public ITypeService getConverter() {
        return this.converter;
    }

    public Class getDbTypeClass() {
        if (!this.readOnly()) {
            if (this.isForeignKey()) {
                return this.getType();
            }
            this.initTypeCode();
        }
        return this.converter.getDbTypeClass(this);
    }

    @Override
    public MetaColumn getModel() {
        return this;
    }

    @Override
    public TableWrapper buildTableWrapper() {
        return this.getTable().addAlias(this.getTableAlias());
    }

    public final ColumnWrapper addTableAlias(String string) {
        return string != null ? ColumnWrapper.forAlias(this, string) : this;
    }

    @Nonnull
    public MetaColumn findRelatedColumn(@Nonnull Session session) {
        if (!this.foreignKey) {
            String string = MsgFormatter.format((String)"The {} column is not relation", (Object[])new Object[]{this});
            throw new IllegalArgumentException(string);
        }
        Key key = (Key)TABLE_KEY.of((Ujo)this);
        if (key instanceof RelationToOne) {
            Key key2 = ((RelationToOne)key).getRelatedKey();
            return (MetaColumn)session.getHandler().findColumnModel(key2, true);
        }
        MetaTable metaTable = session.getHandler().findTableModel(key.getType(), true);
        return ((MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable))).getFirstColumn();
    }

    public boolean isQuoted() {
        switch ((QuoteEnum)((Object)QUOTED.of((Ujo)this))) {
            case YES: {
                return true;
            }
        }
        return false;
    }

    static {
        fa.lock();
        EMPTY_NAMES = new String[0];
    }
}

