/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ujorm.core.ResultSetIterator;
import org.ujorm.core.UjoIteratorImpl;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.tools.set.LoopingIterator;

public abstract class UjoIterator<T>
implements LoopingIterator<T> {
    public abstract boolean hasNext();

    public abstract T next() throws NoSuchElementException;

    public long count() {
        return -1L;
    }

    public UjoIterator<T> iterator() {
        return this;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean skip(int n) {
        while (n > 0 && this.hasNext()) {
            this.next();
            --n;
        }
        return n == 0;
    }

    public List<T> toList() throws IllegalStateException {
        ArrayList arrayList = new ArrayList(32);
        try (UjoIterator<T> ujoIterator = this.iterator();){
            UjoIterator<T> ujoIterator2 = ujoIterator.iterator();
            while (ujoIterator2.hasNext()) {
                Object e = ujoIterator2.next();
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public void close() {
    }

    public String toString() {
        return "size: " + this.count();
    }

    public static final <T> UjoIterator<T> of(Iterator<T> iterator) {
        return new UjoIteratorImpl<T>(iterator);
    }

    public static final <T> UjoIterator<T> of(Collection<T> collection) {
        return new UjoIteratorImpl<T>(collection.iterator(), collection.size());
    }

    public static final <T extends OrmUjo> UjoIterator<T> of(Query<T> query) {
        return new ResultSetIterator(query);
    }

    @Deprecated
    public static final <T> UjoIterator<T> getInstance(Iterator<T> iterator) {
        return new UjoIteratorImpl<T>(iterator);
    }

    @Deprecated
    public static final <T> UjoIterator<T> getInstance(Collection<T> collection) {
        return new UjoIteratorImpl<T>(collection.iterator(), collection.size());
    }

    @Deprecated
    public static final <T extends OrmUjo> UjoIterator<T> getInstance(Query<T> query) {
        return new ResultSetIterator(query);
    }
}

