/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.Ujo;
import org.ujorm.orm.SeqTableModel;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.jdbc.JdbcBuilder;

public class FixingTableSequences
implements Runnable {
    protected static final int COLUMN_ID = 1;
    protected static final int COLUMN_VALUE = 2;
    protected final Connection connection;
    protected final MetaDatabase db;
    protected final SqlDialect dialect;
    protected final SeqTableModel seqModel;
    protected final String sequenceTableName;

    public FixingTableSequences(@Nullable MetaDatabase metaDatabase, @Nonnull Connection connection) throws Exception {
        boolean bl = metaDatabase == null;
        this.db = metaDatabase;
        this.connection = bl ? null : connection;
        this.dialect = bl ? null : metaDatabase.getDialect();
        this.seqModel = bl ? null : this.dialect.getSeqTableModel();
        this.sequenceTableName = bl ? null : this.dialect.printSequenceTableName((String)MetaDatabase.SCHEMA.of((Ujo)metaDatabase), (Appendable)new StringBuilder()).toString();
    }

    @Override
    public void run() throws IllegalStateException {
        Assert.notNull((Object)this.db, (Object[])new Object[]{"Database model is required"});
        try {
            this.onBefore(this.connection);
            this.runInternal();
            this.onAfter(this.connection);
        }
        catch (IOException | SQLException exception) {
            throw new IllegalStateException(exception);
        }
    }

    protected void onBefore(@Nonnull Connection connection) throws SQLException, IOException {
    }

    protected void onAfter(@Nonnull Connection connection) throws SQLException, IOException {
    }

    protected void runInternal() throws SQLException, IOException {
        Object object;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        String string = "%" + this.dialect.getQuoteChar(true) + "%" + this.dialect.getQuoteChar(false);
        PreparedStatement preparedStatement = this.selectFromSequence(string, 1, true);
        Object object32 = null;
        try {
            object2 = preparedStatement.executeQuery();
            object = null;
            try {
                while (object2.next()) {
                    hashSet.add(object2.getString(1));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            object32 = throwable;
            throw throwable;
        }
        finally {
            if (preparedStatement != null) {
                if (object32 != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object32).addSuppressed(throwable);
                    }
                } else {
                    preparedStatement.close();
                }
            }
        }
        if (hashSet.isEmpty()) {
            return;
        }
        block22: for (Object object32 : MetaDatabase.TABLES.getList((Ujo)this.db)) {
            int n;
            if (!((MetaTable)object32).isTable()) continue;
            object2 = ((MetaTable)object32).getSequencer().getTableName();
            object = this.dialect.printFullTableName((MetaTable)object32, new StringBuilder(32)).toString();
            switch (this.db.getParams().get(MetaParams.QUOTATION_POLICY)) {
                default: {
                    continue block22;
                }
                case QUOTE_SQL_NAMES: 
                case QUOTE_ONLY_SQL_KEYWORDS: 
            }
            if (this.db.getParams().get(MetaParams.SEQUENCE_SCHEMA_SYMBOL).booleanValue() && (n = ((String)object).indexOf(46)) > 0) {
                object = "~" + ((String)object).substring(n);
            }
            if (((String)object2).equals(object) || !hashSet.contains(object)) continue;
            Long l = (Long)this.selectValueFromSequence((String)object2, 2);
            Long l2 = (Long)this.selectValueFromSequence((String)object, 2);
            Long l3 = this.max(l, l2);
            if (l == null) {
                this.insertSequence((String)object2, (MetaTable)object32);
                this.updateSequence((String)object2, l3);
            } else if (l < l3) {
                this.updateSequence((String)object2, l3);
            }
            if (l2 == null) continue;
            this.deleteSequence((String)object);
        }
    }

    public void insertSequence(String string, MetaTable metaTable) throws IOException, SQLException {
        String string2 = this.dialect.printSequenceInit(metaTable.getSequencer(), new StringBuilder()).toString();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
    }

    protected long max(@Nullable Long l, @Nullable Long l2) {
        if (l == null) {
            l = 0L;
        }
        if (l2 == null) {
            l2 = 0L;
        }
        return l > l2 ? l : l2;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    protected <T> T selectValueFromSequence(@Nonnull String var1_1, int var2_2) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected PreparedStatement selectFromSequence(@Nonnull String string, int n, boolean bl) throws SQLException, IOException {
        JdbcBuilder jdbcBuilder = new JdbcBuilder().write((CharSequence)"SELECT").column((CharSequence)this.dialect.getQuotedName(this.seqModel.getId())).column((CharSequence)this.dialect.getQuotedName(this.seqModel.getSequence())).write((CharSequence)"FROM").write((CharSequence)this.sequenceTableName).write((CharSequence)"WHERE").andCondition((CharSequence)this.dialect.getQuotedName(this.seqModel.getId()), bl ? "LIKE" : "=", (Object)string);
        return jdbcBuilder.prepareStatement(this.connection);
    }

    protected int updateSequence(@Nonnull String string, long l) throws SQLException, IOException {
        JdbcBuilder jdbcBuilder = new JdbcBuilder().write((CharSequence)"UPDATE").write((CharSequence)this.sequenceTableName).write((CharSequence)"SET").columnUpdate((CharSequence)this.dialect.getQuotedName(this.seqModel.getSequence()), (Object)l).write((CharSequence)"WHERE").andCondition((CharSequence)this.dialect.getQuotedName(this.seqModel.getId()), "=", (Object)string);
        return jdbcBuilder.executeUpdate(this.connection);
    }

    protected int deleteSequence(@Nonnull String string) throws SQLException, IOException {
        JdbcBuilder jdbcBuilder = new JdbcBuilder().write((CharSequence)"DELETE FROM").write((CharSequence)this.sequenceTableName).write((CharSequence)"WHERE").andCondition((CharSequence)this.dialect.getQuotedName(this.seqModel.getId()), "=", (Object)string);
        return jdbcBuilder.executeUpdate(this.connection);
    }
}

