/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.awt.Color;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.extensions.StringWrapper;
import org.ujorm.extensions.ValueWrapper;
import org.ujorm.orm.BytesWrapper;
import org.ujorm.orm.DbType;
import org.ujorm.orm.ITypeService;
import org.ujorm.orm.ao.UjoStatement;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.tools.msg.MsgFormatter;

public class TypeService
implements ITypeService<Object, Object> {
    public static final char UNDEFINED = '\u0000';
    public static final char BOOLEAN = '\u0001';
    public static final char BYTE = '\u0002';
    public static final char CHAR = '\u0003';
    public static final char SHORT = '\u0004';
    public static final char INT = '\u0005';
    public static final char LONG = '\u0006';
    public static final char FLOAT = '\u0007';
    public static final char DOUBLE = '\b';
    public static final char BIG_DECI = '\t';
    public static final char BIG_INTE = '\n';
    public static final char STRING = '\u000b';
    public static final char BYTES = '\f';
    public static final char DATE_UTIL = '\r';
    public static final char DATE_SQL = '\u000e';
    public static final char TIME_SQL = '\u000f';
    public static final char TIMESTAMP = '\u0010';
    public static final char BLOB = '\u0011';
    public static final char CLOB = '\u0012';
    public static final char EXPORT_ENUM = '\u0013';
    public static final char STRING_WRAP = '\u0014';
    public static final char BYTES_WRAP = '\u0015';
    public static final char ENUM = '\u0016';
    public static final char COLOR = '\u0017';
    public static final char UUID = '\u0018';
    public static final char LOCAL_DATE = '\u0019';
    public static final char LOCAL_TIME = '\u001a';
    public static final char LOCAL_DATE_TIME = '\u001b';
    public static final char OFFSET_DATE_TIME = '\u001c';
    private static final Class[] STR_ARGS = new Class[]{String.class};
    private static final Class[] BYTES_ARGS = new Class[]{byte[].class};

    public static char getTypeCode(@Nonnull MetaColumn metaColumn) {
        List<MetaColumn> list;
        Class clazz;
        Class clazz2 = metaColumn.getType();
        Class clazz3 = clazz = metaColumn.isValueWrapper() ? ValueWrapper.getInstance((Class)clazz2).readPersistentClass() : clazz2;
        if (StringWrapper.class.isAssignableFrom(clazz)) {
            return clazz.isEnum() ? (char)'\u0013' : '\u0014';
        }
        if (BytesWrapper.class.isAssignableFrom(clazz)) {
            return '\u0015';
        }
        if (clazz == String.class) {
            return '\u000b';
        }
        if (clazz == Boolean.class) {
            return '\u0001';
        }
        if (clazz == Byte.class) {
            return '\u0002';
        }
        if (clazz == Character.class) {
            return '\u0003';
        }
        if (clazz == Short.class) {
            return '\u0004';
        }
        if (clazz == Integer.class) {
            return '\u0005';
        }
        if (clazz == Long.class) {
            return '\u0006';
        }
        if (clazz == Float.class) {
            return '\u0007';
        }
        if (clazz == Double.class) {
            return '\b';
        }
        if (clazz == BigDecimal.class) {
            return '\t';
        }
        if (clazz == BigInteger.class) {
            return '\n';
        }
        if (clazz == byte[].class) {
            return '\f';
        }
        if (clazz == java.util.Date.class) {
            return '\r';
        }
        if (clazz == Date.class) {
            return '\u000e';
        }
        if (clazz == Time.class) {
            return '\u000f';
        }
        if (clazz == Timestamp.class) {
            return '\u0010';
        }
        if (clazz == LocalDate.class) {
            return '\u0019';
        }
        if (clazz == LocalTime.class) {
            return '\u001a';
        }
        if (clazz == LocalDateTime.class) {
            return '\u001b';
        }
        if (clazz == OffsetDateTime.class) {
            return '\u001c';
        }
        if (clazz == Blob.class) {
            return '\u0011';
        }
        if (clazz == Clob.class) {
            return '\u0012';
        }
        if (clazz.isEnum()) {
            return '\u0016';
        }
        if (clazz == Color.class) {
            return '\u0017';
        }
        if (clazz == UUID.class) {
            return '\u0018';
        }
        if (metaColumn.isForeignKey() && (list = metaColumn.getForeignColumns()).size() == 1) {
            return TypeService.getTypeCode(list.get(0));
        }
        return '\u0000';
    }

    @Override
    public Object getValue(@Nonnull MetaColumn metaColumn, @Nonnull ResultSet resultSet, int n) throws SQLException {
        Comparable<Boolean> comparable;
        switch (metaColumn.getTypeCode()) {
            case '\u0001': {
                comparable = resultSet.getBoolean(n);
                break;
            }
            case '\u0002': {
                comparable = resultSet.getByte(n);
                break;
            }
            case '\u0003': {
                String string = resultSet.getString(n);
                return string != null && string.length() > 0 ? Character.valueOf(string.charAt(0)) : null;
            }
            case '\u0004': {
                comparable = resultSet.getShort(n);
                break;
            }
            case '\u0005': {
                comparable = resultSet.getInt(n);
                break;
            }
            case '\u0006': {
                comparable = resultSet.getLong(n);
                break;
            }
            case '\u0007': {
                comparable = Float.valueOf(resultSet.getFloat(n));
                break;
            }
            case '\b': {
                comparable = resultSet.getDouble(n);
                break;
            }
            case '\t': {
                return resultSet.getBigDecimal(n);
            }
            case '\n': {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                return bigDecimal != null ? bigDecimal.toBigInteger() : null;
            }
            case '\u000b': {
                return resultSet.getString(n);
            }
            case '\f': {
                return resultSet.getBytes(n);
            }
            case '\r': {
                Timestamp timestamp = resultSet.getTimestamp(n);
                return timestamp != null ? new java.util.Date(timestamp.getTime()) : null;
            }
            case '\u000e': {
                return resultSet.getDate(n);
            }
            case '\u000f': {
                return resultSet.getTime(n);
            }
            case '\u0010': {
                return resultSet.getTimestamp(n);
            }
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': {
                return resultSet.getObject(n, metaColumn.getType());
            }
            case '\u0011': {
                return resultSet.getBlob(n);
            }
            case '\u0012': {
                return resultSet.getClob(n);
            }
            case '\u0016': {
                int n2 = resultSet.getInt(n);
                return n2 == 0 && resultSet.wasNull() ? null : metaColumn.getType().getEnumConstants()[n2];
            }
            case '\u0017': {
                int n3 = resultSet.getInt(n);
                return n3 == 0 && resultSet.wasNull() ? null : new Color(n3);
            }
            case '\u0014': {
                return this.createStringWrapper(resultSet.getString(n), metaColumn);
            }
            case '\u0015': {
                return this.createBytesWrapper(resultSet.getBytes(n), metaColumn);
            }
            case '\u0013': {
                return this.findEnum(resultSet.getString(n), metaColumn);
            }
            default: {
                return resultSet.getObject(n, metaColumn.getType());
            }
        }
        return resultSet.wasNull() ? null : comparable;
    }

    @Override
    public Object getValue(@Nonnull MetaColumn metaColumn, @Nonnull CallableStatement callableStatement, int n) throws SQLException {
        Comparable<Boolean> comparable;
        switch (metaColumn.getTypeCode()) {
            case '\u0001': {
                comparable = callableStatement.getBoolean(n);
                break;
            }
            case '\u0002': {
                comparable = callableStatement.getByte(n);
                break;
            }
            case '\u0003': {
                String string = callableStatement.getString(n);
                return string != null && string.length() > 0 ? Character.valueOf(string.charAt(0)) : null;
            }
            case '\u0004': {
                comparable = callableStatement.getShort(n);
                break;
            }
            case '\u0005': {
                comparable = callableStatement.getInt(n);
                break;
            }
            case '\u0006': {
                comparable = callableStatement.getLong(n);
                break;
            }
            case '\u0007': {
                comparable = Float.valueOf(callableStatement.getFloat(n));
                break;
            }
            case '\b': {
                comparable = callableStatement.getDouble(n);
                break;
            }
            case '\t': {
                return callableStatement.getBigDecimal(n);
            }
            case '\n': {
                BigDecimal bigDecimal = callableStatement.getBigDecimal(n);
                return bigDecimal != null ? bigDecimal.toBigInteger() : null;
            }
            case '\u000b': {
                return callableStatement.getString(n);
            }
            case '\f': {
                return callableStatement.getBytes(n);
            }
            case '\r': {
                Timestamp timestamp = callableStatement.getTimestamp(n);
                return timestamp != null ? new java.util.Date(timestamp.getTime()) : null;
            }
            case '\u000e': {
                return callableStatement.getDate(n);
            }
            case '\u000f': {
                return callableStatement.getTime(n);
            }
            case '\u0010': {
                return callableStatement.getTimestamp(n);
            }
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': {
                return callableStatement.getObject(n, metaColumn.getType());
            }
            case '\u0011': {
                return callableStatement.getBlob(n);
            }
            case '\u0012': {
                return callableStatement.getClob(n);
            }
            case '\u0016': {
                int n2 = callableStatement.getInt(n);
                return n2 == 0 && callableStatement.wasNull() ? null : metaColumn.getType().getEnumConstants()[n2];
            }
            case '\u0017': {
                int n3 = callableStatement.getInt(n);
                return n3 == 0 && callableStatement.wasNull() ? null : new Color(n3);
            }
            case '\u0014': {
                return this.createStringWrapper(callableStatement.getString(n), metaColumn);
            }
            case '\u0015': {
                return this.createBytesWrapper(callableStatement.getBytes(n), metaColumn);
            }
            case '\u0013': {
                return this.findEnum(callableStatement.getString(n), metaColumn);
            }
            default: {
                return callableStatement.getObject(n, metaColumn.getType());
            }
        }
        return callableStatement.wasNull() ? null : comparable;
    }

    @Override
    public void setValue(@Nonnull MetaColumn metaColumn, @Nonnull PreparedStatement preparedStatement, @Nullable Object object, int n) throws SQLException {
        if (object == null) {
            int n2 = ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))).getSqlType();
            preparedStatement.setNull(n, n2);
            return;
        }
        Object object2 = metaColumn.isValueWrapper() ? ((ValueWrapper)object).readPersistentValue() : object;
        switch (metaColumn.getTypeCode()) {
            case '\u0001': {
                preparedStatement.setBoolean(n, (Boolean)object2);
                break;
            }
            case '\u0002': {
                preparedStatement.setByte(n, (Byte)object2);
                break;
            }
            case '\u0003': {
                preparedStatement.setString(n, String.valueOf(object2));
                break;
            }
            case '\u0004': {
                preparedStatement.setShort(n, (Short)object2);
                break;
            }
            case '\u0005': {
                preparedStatement.setInt(n, (Integer)object2);
                break;
            }
            case '\u0006': {
                preparedStatement.setLong(n, (Long)object2);
                break;
            }
            case '\u0007': {
                preparedStatement.setFloat(n, ((Float)object2).floatValue());
                break;
            }
            case '\b': {
                preparedStatement.setDouble(n, (Double)object2);
                break;
            }
            case '\t': {
                preparedStatement.setBigDecimal(n, (BigDecimal)object2);
                break;
            }
            case '\n': {
                preparedStatement.setBigDecimal(n, new BigDecimal((BigInteger)object2));
                break;
            }
            case '\u000b': {
                preparedStatement.setString(n, (String)object2);
                break;
            }
            case '\f': {
                preparedStatement.setBytes(n, (byte[])object2);
                break;
            }
            case '\r': {
                preparedStatement.setTimestamp(n, new Timestamp(((java.util.Date)object2).getTime()));
                break;
            }
            case '\u000e': {
                preparedStatement.setDate(n, (Date)object2);
                break;
            }
            case '\u000f': {
                preparedStatement.setTime(n, (Time)object2);
                break;
            }
            case '\u0010': {
                preparedStatement.setTimestamp(n, (Timestamp)object2);
                break;
            }
            case '\u0011': {
                preparedStatement.setBlob(n, (Blob)object2);
                break;
            }
            case '\u0012': {
                preparedStatement.setClob(n, (Clob)object2);
                break;
            }
            case '\u0016': {
                preparedStatement.setInt(n, ((Enum)object2).ordinal());
                break;
            }
            case '\u0017': {
                preparedStatement.setInt(n, ((Color)object2).getRGB());
                break;
            }
            case '\u0013': 
            case '\u0014': {
                preparedStatement.setString(n, object2 != null ? ((StringWrapper)object2).exportToString() : null);
                break;
            }
            case '\u0015': {
                preparedStatement.setBytes(n, object2 != null ? ((BytesWrapper)object2).exportToBytes() : null);
                break;
            }
            default: {
                preparedStatement.setObject(n, object2, ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))).getSqlType());
            }
        }
    }

    private Object findEnum(@Nullable String string, @Nonnull MetaColumn metaColumn) throws IllegalUjormException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        for (Object t : metaColumn.getType().getEnumConstants()) {
            if (!string.equals(((StringWrapper)t).exportToString())) continue;
            return t;
        }
        String string2 = MsgFormatter.format((String)"No enum was found for the key {} type of {} using the value: '{}'.", (Object[])new Serializable[]{metaColumn, metaColumn.getType().getSimpleName(), string});
        throw new IllegalUjormException(string2);
    }

    private Object createStringWrapper(@Nullable String string, @Nonnull MetaColumn metaColumn) throws IllegalUjormException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            Object t = metaColumn.getType().getConstructor(STR_ARGS).newInstance(string);
            return t;
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            throw new IllegalUjormException("Bad value export " + metaColumn.getType() + "." + string, (Throwable)exception);
        }
    }

    private Object createBytesWrapper(@Nullable byte[] byArray, @Nonnull MetaColumn metaColumn) throws IllegalUjormException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            Object t = metaColumn.getType().getConstructor(BYTES_ARGS).newInstance(new Object[]{byArray});
            return t;
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            throw new IllegalUjormException("Bad value export " + metaColumn.getType() + "." + byArray, (Throwable)exception);
        }
    }

    @Override
    public Class getDbTypeClass(@Nonnull MetaColumn metaColumn) {
        Object object;
        assert (metaColumn.getConverter() == this) : "Invalid column for this service: " + metaColumn;
        switch (metaColumn.getTypeCode()) {
            case '\u0002': {
                return metaColumn.getType();
            }
            case '\u0003': {
                return metaColumn.getType();
            }
        }
        Class<?> clazz = metaColumn.getType();
        Class<?> clazz2 = metaColumn.isValueWrapper() ? ValueWrapper.getInstance((Class)clazz).readPersistentClass() : clazz;
        Object object2 = metaColumn.getKey().getDefault();
        if (object2 == null) {
            if (clazz2.isEnum()) {
                object2 = clazz2.getEnumConstants()[0];
            } else {
                return clazz2;
            }
        }
        if (!metaColumn.readOnly() && metaColumn.getTypeCode() == '\u0000') {
            metaColumn.initTypeCode();
        }
        if ((object = new UjoStatement().getDatabaseValue(metaColumn, object2)) instanceof Integer) {
            switch (metaColumn.getTypeCode()) {
                case '\u0016': {
                    return Short.class;
                }
            }
        }
        return object != null ? object.getClass() : clazz2;
    }
}

