/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.tools.Assert;

public class ColumnWrapperImpl
implements ColumnWrapper {
    private MetaColumn column;
    private String tableAlias;
    private Key key;

    public ColumnWrapperImpl(@Nonnull MetaColumn metaColumn, @Nullable String string) {
        this(metaColumn, string, metaColumn.getKey());
    }

    public ColumnWrapperImpl(@Nonnull MetaColumn metaColumn, @Nullable Key key) {
        this(metaColumn, key.isComposite() ? ColumnWrapperImpl.getAlias((CompositeKey)key) : null, key);
    }

    public ColumnWrapperImpl(@Nonnull MetaColumn metaColumn, @Nullable String string, @Nullable Key key) {
        this.column = (MetaColumn)Assert.notNull((Object)metaColumn, (Object[])new String[]{"column"});
        this.tableAlias = string != null ? string : metaColumn.getTableAlias();
        this.key = key != null ? key : metaColumn.getKey();
    }

    private static String getAlias(@Nullable CompositeKey compositeKey) {
        int n = compositeKey != null ? compositeKey.getKeyCount() : 0;
        return n > 1 ? compositeKey.getAlias(n - 2) : null;
    }

    @Override
    public MetaColumn getModel() {
        return this.column;
    }

    @Override
    public String getName() {
        return this.column.getName();
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public TableWrapper buildTableWrapper() {
        return this.column.getTable().addAlias(this.tableAlias);
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public boolean isCompositeKey() {
        return this.key.isComposite();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof ColumnWrapper) {
            ColumnWrapper columnWrapper = (ColumnWrapper)object;
            Key key = columnWrapper.getKey();
            Key key2 = this.getKey();
            boolean bl = key2.getName().equals(key.getName()) && key2.getDomainType() == key.getDomainType() && this.getTableAlias().equals(columnWrapper.getTableAlias());
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().getName().hashCode();
    }

    public String toString() {
        return this.key.getFullName();
    }
}

