/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoManager;
import org.ujorm.criterion.BinaryCriterion;
import org.ujorm.criterion.Criterion;
import org.ujorm.criterion.Operator;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.orm.AliasKey;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaTable;

public class CriterionDecoder {
    protected final OrmHandler handler;
    protected final SqlDialect dialect;
    protected final Criterion criterion;
    protected final List<Key> orderBy;
    protected final List<ValueCriterion> values;
    protected final List<ValueCriterion> nullValues;
    protected final Set<TableWrapper> tables;
    protected final MetaTable baseTable;
    final List<Relation> relations = new ArrayList<Relation>();
    protected final String where;

    public CriterionDecoder(Criterion criterion, MetaTable metaTable) {
        this(criterion, metaTable, null);
    }

    public CriterionDecoder(Criterion criterion, MetaTable metaTable, List<Key> list) {
        MetaDatabase metaDatabase = metaTable.getDatabase();
        this.baseTable = metaTable;
        this.criterion = criterion;
        this.dialect = metaDatabase.getDialect();
        this.orderBy = list;
        this.handler = metaDatabase.getOrmHandler();
        this.values = new ArrayList<ValueCriterion>();
        this.nullValues = new ArrayList<ValueCriterion>();
        this.tables = new LinkedHashSet<TableWrapper>();
        this.tables.add(metaTable);
        this.where = this.initWhere();
    }

    protected void unpack(Criterion criterion, StringBuilder stringBuilder) {
        if (criterion.isBinary()) {
            this.unpackBinary((BinaryCriterion)criterion, stringBuilder);
        } else {
            try {
                ValueCriterion valueCriterion = ((ValueCriterion)criterion).freeze();
                ValueCriterion valueCriterion2 = this.dialect.printCriterion(valueCriterion, stringBuilder);
                if (valueCriterion2 != null) {
                    this.values.add(valueCriterion2);
                } else {
                    this.nullValues.add(valueCriterion);
                }
            }
            catch (IOException | RuntimeException exception) {
                throw new IllegalUjormException("Unpack failed for criterion: " + criterion, (Throwable)exception);
            }
        }
    }

    private void unpackBinary(BinaryCriterion binaryCriterion, StringBuilder stringBuilder) {
        boolean bl = false;
        switch (binaryCriterion.getOperator()) {
            case OR: {
                bl = true;
            }
            case AND: {
                if (bl) {
                    stringBuilder.append(" (");
                }
                this.unpack(binaryCriterion.getLeftNode(), stringBuilder);
                stringBuilder.append(' ');
                stringBuilder.append(binaryCriterion.getOperator().name());
                stringBuilder.append(' ');
                this.unpack(binaryCriterion.getRightNode(), stringBuilder);
                if (!bl) break;
                stringBuilder.append(") ");
                break;
            }
            case NOT: {
                stringBuilder.append(' ');
                stringBuilder.append(binaryCriterion.getOperator().name());
                stringBuilder.append(" (");
                this.unpack(binaryCriterion.getRightNode(), stringBuilder);
                stringBuilder.append(") ");
                break;
            }
            default: {
                String string = "Operator is not supported in the SQL statement: " + binaryCriterion.getOperator();
                throw new UnsupportedOperationException(string);
            }
        }
    }

    public int getColumnCount() {
        return this.values.size();
    }

    public MetaColumn getColumn(int n) throws IllegalArgumentException {
        Key key = this.values.get(n).getLeftNode();
        MetaColumn metaColumn = (MetaColumn)this.handler.findColumnModel(key, true);
        return metaColumn;
    }

    public Operator getOperator(int n) {
        Operator operator = this.values.get(n).getOperator();
        return operator;
    }

    public Object getValue(int n) {
        Object object = this.values.get(n).getRightNode();
        return object;
    }

    public Object getValueExtended(int n) {
        ValueCriterion valueCriterion = this.values.get(n);
        Object object = valueCriterion.getRightNode();
        if (object == null) {
            return object;
        }
        if (valueCriterion.isInsensitive()) {
            object = object.toString().toLowerCase();
        }
        switch (valueCriterion.getOperator()) {
            case CONTAINS: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "%" + object + "%";
            }
            case STARTS: 
            case STARTS_CASE_INSENSITIVE: {
                return object + "%";
            }
            case ENDS: 
            case ENDS_CASE_INSENSITIVE: {
                return "%" + object;
            }
        }
        return object;
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    protected final String initWhere() {
        StringBuilder stringBuilder = new StringBuilder(64);
        this.writeConditions(stringBuilder);
        this.writeRelations(stringBuilder);
        return stringBuilder.toString();
    }

    public String getWhere() {
        return this.where;
    }

    public boolean isEmpty() {
        return this.getWhere().isEmpty();
    }

    public Key getBaseProperty() {
        Key key = null;
        for (ValueCriterion valueCriterion : this.values) {
            if (valueCriterion.getLeftNode() == null) continue;
            key = valueCriterion.getLeftNode();
            break;
        }
        while (UjoManager.isCompositeKey(key)) {
            key = ((CompositeKey)key).getKey(0);
        }
        return key;
    }

    protected void writeConditions(StringBuilder stringBuilder) {
        if (this.criterion != null) {
            this.unpack(this.criterion, stringBuilder);
        }
    }

    protected void writeRelations(StringBuilder stringBuilder) {
        if (this.criterion == null && this.orderBy == null) {
            return;
        }
        Collection<AliasKey> collection = this.getPropertyRelations();
        for (AliasKey aliasKey : collection) {
            try {
                ColumnWrapper columnWrapper = aliasKey.getColumn(this.handler);
                MetaTable metaTable = columnWrapper.getModel().getTable();
                ColumnWrapper columnWrapper2 = columnWrapper.getModel().getForeignColumns().get(0).addTableAlias(aliasKey.aliasTo);
                MetaTable metaTable2 = columnWrapper2.getModel().getTable();
                this.tables.add(metaTable.addAlias(aliasKey.getAliasFrom()));
                this.tables.add(metaTable2.addAlias(aliasKey.getAliasTo()));
                this.relations.add(new Relation(columnWrapper, columnWrapper2));
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalUjormException((Throwable)runtimeException);
            }
        }
    }

    protected Collection<AliasKey> getPropertyRelations() {
        LinkedHashSet<AliasKey> linkedHashSet = new LinkedHashSet<AliasKey>();
        ArrayList<ValueCriterion> arrayList = new ArrayList<ValueCriterion>(this.values.size() + this.nullValues.size());
        arrayList.addAll(this.values);
        arrayList.addAll(this.nullValues);
        for (ValueCriterion valueCriterion : arrayList) {
            Key key = valueCriterion.getLeftNode();
            if (key == null) continue;
            AliasKey.addRelations(key, linkedHashSet);
            Object object = valueCriterion.getRightNode();
            if (!(object instanceof CompositeKey)) continue;
            AliasKey.addRelations((CompositeKey)object, linkedHashSet);
        }
        if (this.orderBy != null) {
            for (Key key : this.orderBy) {
                AliasKey.addRelations((CompositeKey)key, linkedHashSet);
            }
        }
        return linkedHashSet;
    }

    public MetaTable getBaseTable() {
        return this.baseTable;
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public TableWrapper[] getTables() {
        return this.tables.toArray(new TableWrapper[this.tables.size()]);
    }

    public TableWrapper[] getTablesSorted() {
        TableWrapper[] tableWrapperArray = this.getTables();
        if (tableWrapperArray.length > 1 && tableWrapperArray[0] != this.baseTable) {
            for (int i = tableWrapperArray.length - 1; i >= 1; --i) {
                if (tableWrapperArray[i] != this.baseTable) continue;
                tableWrapperArray[i] = tableWrapperArray[0];
                tableWrapperArray[0] = this.baseTable;
            }
        }
        return tableWrapperArray;
    }

    public OrmHandler getHandler() {
        return this.handler;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public String toString() {
        return this.criterion != null ? this.criterion.toString() : null;
    }

    public static final class Relation {
        private final ColumnWrapper left;
        private final ColumnWrapper right;

        public Relation(ColumnWrapper columnWrapper, ColumnWrapper columnWrapper2) {
            this.left = columnWrapper;
            this.right = columnWrapper2;
        }

        public ColumnWrapper getLeft() {
            return this.left;
        }

        public ColumnWrapper getRight() {
            return this.right;
        }
    }
}

