/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.criterion.Criterion;
import org.ujorm.criterion.Operator;
import org.ujorm.criterion.TemplateValue;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.AliasKey;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SeqTableModel;
import org.ujorm.orm.SqlNameProvider;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.ao.CheckReport;
import org.ujorm.orm.ao.QuoteEnum;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaSelect;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;

public abstract class SqlDialect {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(SqlDialect.class);
    private final SeqTableModel pkTableModel = new SeqTableModel();
    protected static final String COMMON_SEQ_TABLE_KEY = "<ALL>";
    protected static final String NEW_LINE_SEPARATOR = "\n\t";
    private static final char QUOTE_CHARACTER = '\"';
    protected OrmHandler ormHandler;
    private SqlNameProvider nameProvider;
    private CheckReport quotingPolicy;

    public void setHandler(@NotNull OrmHandler ormHandler) {
        Assert.isNull((Object)this.ormHandler, (Object[])new String[]{"The OrmHandler is assigned yet."});
        this.ormHandler = ormHandler;
    }

    public abstract String getJdbcUrl();

    public abstract String getJdbcDriver();

    public Connection createConnection(@NotNull MetaDatabase metaDatabase) throws Exception {
        return metaDatabase.createInternalConnection();
    }

    public InitialContext createJndiInitialContext(@NotNull MetaDatabase metaDatabase) throws NamingException {
        return new InitialContext();
    }

    public boolean isCatalog() {
        return false;
    }

    public Appendable printCreateSchema(String string, @NotNull Appendable appendable) throws IOException {
        appendable.append("CREATE SCHEMA IF NOT EXISTS ");
        this.printQuotedName(string, QuoteEnum.BY_CONFIG, appendable);
        return appendable;
    }

    @Deprecated
    public Appendable printDefaultSchema(String string, @NotNull Appendable appendable) throws IOException {
        appendable.append("SET SCHEMA ");
        this.printQuotedName(string, QuoteEnum.BY_CONFIG, appendable);
        return appendable;
    }

    public Appendable printFullTableName(MetaTable metaTable, @NotNull Appendable appendable) throws IOException {
        return this.printFullTableName(metaTable, metaTable.get(MetaTable.QUOTED), appendable);
    }

    public Appendable printFullTableName(MetaTable metaTable, @NotNull QuoteEnum quoteEnum, @NotNull Appendable appendable) throws IOException {
        String string = (String)MetaTable.SCHEMA.of((Ujo)metaTable);
        String string2 = (String)MetaTable.NAME.of((Ujo)metaTable);
        if (Check.hasLength((CharSequence)string)) {
            this.printQuotedName(string, quoteEnum, appendable).append('.');
        }
        this.printQuotedName(string2, quoteEnum, appendable);
        return appendable;
    }

    public void printTableAliasDefinition(TableWrapper tableWrapper, @NotNull Appendable appendable) throws IOException {
        this.printFullTableName(tableWrapper.getModel(), appendable);
        String string = tableWrapper.getAlias();
        if (Check.hasLength((CharSequence)string)) {
            appendable.append(' ');
            this.printQuotedName(string, QuoteEnum.BY_CONFIG, appendable);
        }
    }

    public Appendable printColumnAlias(ColumnWrapper columnWrapper, @NotNull Appendable appendable) throws IOException {
        this.printQuotedName(columnWrapper.getTableAlias(), QuoteEnum.BY_CONFIG, appendable);
        appendable.append('.');
        this.printColumnName(columnWrapper, appendable);
        return appendable;
    }

    public Appendable printTable(MetaTable metaTable, @NotNull Appendable appendable) throws IOException {
        appendable.append("CREATE TABLE ");
        this.printFullTableName(metaTable, appendable);
        String string = NEW_LINE_SEPARATOR.concat("( ");
        for (MetaColumn metaColumn : MetaTable.COLUMNS.getList((Ujo)metaTable)) {
            appendable.append(string);
            string = "\n\t, ";
            if (metaColumn.isForeignKey()) {
                this.printFKColumnsDeclaration(metaColumn, appendable);
                continue;
            }
            this.printColumnDeclaration(metaColumn, appendable);
        }
        appendable.append(NEW_LINE_SEPARATOR).append(')');
        return appendable;
    }

    public Appendable printAlterTableAddColumn(MetaColumn metaColumn, @NotNull Appendable appendable) throws IOException {
        return this.printAlterTableColumn(metaColumn, true, appendable);
    }

    public Appendable printAlterTableColumn(MetaColumn metaColumn, boolean bl, @NotNull Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaColumn.getTable(), appendable);
        appendable.append(bl ? " ADD COLUMN " : " ALTER COLUMN ");
        if (metaColumn.isForeignKey()) {
            this.printFKColumnsDeclaration(metaColumn, appendable);
        } else {
            this.printColumnDeclaration(metaColumn, appendable);
        }
        if (metaColumn.hasDefaultValue()) {
            this.printDefaultValue(metaColumn, appendable);
        }
        return appendable;
    }

    public Appendable printDefaultValue(MetaColumn metaColumn, @NotNull Appendable appendable) throws IOException {
        Object object = metaColumn.getJdbcFriendlyDefaultValue();
        boolean bl = object != null;
        String string = "";
        if (object instanceof String) {
            bl = ((String)object).length() > 0;
            string = "'";
        } else if (object instanceof Date) {
            bl = true;
            string = "'";
        }
        if (bl) {
            appendable.append(" DEFAULT ");
            appendable.append(string);
            appendable.append(object.toString());
            appendable.append(string);
        }
        return appendable;
    }

    public Appendable printDefaultConstraint(MetaColumn metaColumn, StringBuilder stringBuilder) throws IOException {
        if (metaColumn.hasDefaultValue()) {
            MetaTable metaTable = metaColumn.getTable();
            stringBuilder.append("ALTER TABLE ");
            this.printFullTableName(metaTable, stringBuilder);
            stringBuilder.append(" ALTER COLUMN ");
            this.printColumnName(metaColumn, stringBuilder);
            stringBuilder.append(" SET ");
            this.printDefaultValue(metaColumn, stringBuilder);
        }
        return stringBuilder;
    }

    public Appendable printForeignKey(MetaColumn metaColumn, @NotNull Appendable appendable) throws IOException {
        int n;
        MetaTable metaTable = metaColumn.getTable();
        List<MetaColumn> list = metaColumn.getForeignColumns();
        MetaTable metaTable2 = list.get(0).getTable();
        int n2 = list.size();
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(NEW_LINE_SEPARATOR).append("ADD CONSTRAINT ");
        this.getNameProvider().printConstraintName(metaTable, metaColumn, appendable);
        appendable.append(" FOREIGN KEY ");
        for (n = 0; n < n2; ++n) {
            appendable.append(n == 0 ? "(" : ", ");
            this.printQuotedName(metaColumn.getForeignColumnName(n), metaColumn.get(MetaColumn.QUOTED), appendable);
        }
        appendable.append(')').append(NEW_LINE_SEPARATOR).append("REFERENCES ");
        this.printFullTableName(metaTable2, appendable);
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            appendable.append(n == 0 ? "(" : ", ");
            this.printColumnName(list.get(n), appendable);
        }
        appendable.append(')');
        return appendable;
    }

    public Appendable printIndex(MetaIndex metaIndex, @NotNull Appendable appendable) throws IOException {
        appendable.append("CREATE ");
        if (((Boolean)MetaIndex.UNIQUE.of((Ujo)metaIndex)).booleanValue()) {
            appendable.append("UNIQUE ");
        }
        appendable.append("INDEX ");
        appendable.append((CharSequence)MetaIndex.NAME.of((Ujo)metaIndex));
        appendable.append(" ON ");
        this.printFullTableName((MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex), appendable);
        String string = " (";
        for (MetaColumn metaColumn : MetaIndex.COLUMNS.getList((Ujo)metaIndex)) {
            appendable.append(string);
            this.printColumnName(metaColumn, appendable);
            string = ", ";
        }
        appendable.append(')');
        return appendable;
    }

    protected boolean isColumnLengthAllowed(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case INTEGER: 
            case SMALLINT: 
            case BIGINT: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIMEZONE: 
            case CLOB: 
            case BLOB: {
                return false;
            }
        }
        return !MetaColumn.MAX_LENGTH.isDefault((Ujo)metaColumn);
    }

    public Appendable printColumnDeclaration(@NotNull ColumnWrapper columnWrapper, @NotNull Appendable appendable) throws IOException {
        boolean bl;
        this.printColumnName(columnWrapper, appendable);
        MetaColumn metaColumn = columnWrapper.getModel();
        appendable.append(' ');
        appendable.append(this.getColumnType(metaColumn));
        if (this.isColumnLengthAllowed(metaColumn)) {
            appendable.append('(').append(((Integer)MetaColumn.MAX_LENGTH.of((Ujo)metaColumn)).toString());
            if (!MetaColumn.PRECISION.isDefault((Ujo)metaColumn)) {
                appendable.append(',').append(((Integer)MetaColumn.PRECISION.of((Ujo)metaColumn)).toString());
            }
            appendable.append(')');
        }
        if ((bl = columnWrapper instanceof MetaColumn) && ((Boolean)MetaColumn.MANDATORY.of((Ujo)metaColumn)).booleanValue()) {
            appendable.append(" NOT NULL");
        }
        if (bl && ((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)metaColumn)).booleanValue()) {
            appendable.append(" PRIMARY KEY");
        }
        return appendable;
    }

    protected String getColumnType(MetaColumn metaColumn) {
        String string = ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))).name();
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case TIMESTAMP_WITH_TIMEZONE: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        return string;
    }

    public Appendable printFKColumnsDeclaration(@NotNull MetaColumn metaColumn, @NotNull Appendable appendable) throws IOException {
        List<MetaColumn> list = metaColumn.getForeignColumns();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                appendable.append(COMMON_SEQ_TABLE_KEY).append(", ");
            }
            this.printColumnDeclaration(ColumnWrapper.forName(list.get(i), metaColumn.getForeignColumnName(i)), appendable);
            if (((Boolean)MetaColumn.MANDATORY.of((Ujo)metaColumn)).booleanValue()) {
                appendable.append(" NOT NULL");
            }
            if (!((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)metaColumn)).booleanValue()) continue;
            appendable.append(" PRIMARY KEY");
        }
        return appendable;
    }

    public Appendable printInsert(@NotNull OrmUjo ormUjo, @NotNull Appendable appendable) throws IOException {
        MetaTable metaTable = this.ormHandler.findTableModel(ormUjo.getClass());
        StringBuilder stringBuilder = new StringBuilder();
        appendable.append("INSERT INTO ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" (");
        this.printTableColumns(metaTable.getColumns(), stringBuilder, appendable);
        appendable.append(") VALUES (").append(stringBuilder).append(')');
        return appendable;
    }

    public Appendable printInsert(List<? extends OrmUjo> list, int n, int n2, @NotNull Appendable appendable) throws IOException {
        MetaTable metaTable = this.ormHandler.findTableModel(list.get(n).getClass());
        StringBuilder stringBuilder = new StringBuilder(32);
        appendable.append("INSERT INTO ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" (");
        this.printTableColumns(metaTable.getColumns(), stringBuilder, appendable);
        for (int i = n; i < n2; ++i) {
            appendable.append(i == n ? ") VALUES \n(" : "),\n(").append(stringBuilder);
        }
        appendable.append(')');
        return appendable;
    }

    public Appendable printInsertBySelect(@NotNull List<? extends OrmUjo> list, int n, int n2, @NotNull String string, @NotNull Appendable appendable) throws IOException {
        MetaTable metaTable = this.ormHandler.findTableModel(list.get(n).getClass());
        StringBuilder stringBuilder = new StringBuilder(32);
        appendable.append("INSERT INTO ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" (");
        this.printTableColumns(metaTable.getColumns(), stringBuilder, appendable);
        for (int i = n; i < n2; ++i) {
            appendable.append(i == n ? ")\nSELECT " : " UNION ALL\nSELECT ").append(stringBuilder);
            if (!Check.hasLength((CharSequence)string)) continue;
            appendable.append(' ').append(string);
        }
        return appendable;
    }

    public boolean isMultiRowInsertSupported() {
        return true;
    }

    public Appendable printUpdate(@NotNull List<MetaColumn> list, @NotNull CriterionDecoder criterionDecoder, @NotNull Appendable appendable) throws IOException {
        MetaTable metaTable = criterionDecoder.getBaseTable();
        appendable.append("UPDATE ");
        this.printTableAliasDefinition(metaTable, appendable);
        appendable.append(NEW_LINE_SEPARATOR).append("SET ");
        for (int i = 0; i < list.size(); ++i) {
            MetaColumn metaColumn = list.get(i);
            Assert.isFalse((boolean)metaColumn.isPrimaryKey(), (Object[])new Object[]{"Primary key can not be changed: {}", metaColumn});
            appendable.append(i == 0 ? "" : ", ");
            this.printColumnName(metaColumn, appendable);
            appendable.append("=?");
        }
        appendable.append(NEW_LINE_SEPARATOR).append("WHERE ");
        if (criterionDecoder.getTableCount() > 1) {
            this.printColumnName(metaTable.getFirstPK(), appendable);
            appendable.append(" IN (");
            this.printSelectTableBase(this.createSubQuery(criterionDecoder), false, appendable);
            appendable.append(')');
        } else {
            appendable.append(criterionDecoder.getWhere());
        }
        return appendable;
    }

    public Appendable printDelete(@NotNull CriterionDecoder criterionDecoder, @NotNull Appendable appendable) throws IOException {
        MetaTable metaTable = criterionDecoder.getBaseTable();
        appendable.append("DELETE FROM ");
        this.printTableAliasDefinition(metaTable, appendable);
        appendable.append(" WHERE ");
        if (criterionDecoder.getTableCount() > 1) {
            this.printColumnName(metaTable.getFirstPK(), appendable);
            appendable.append(" IN (");
            this.printSelectTableBase(this.createSubQuery(criterionDecoder), false, appendable);
            appendable.append(')');
        } else {
            appendable.append(criterionDecoder.getWhere());
        }
        return appendable;
    }

    protected Query createSubQuery(@NotNull CriterionDecoder criterionDecoder) {
        MetaTable metaTable = criterionDecoder.getBaseTable();
        Query query = new Query(metaTable, criterionDecoder.getCriterion());
        query.setDecoder(criterionDecoder);
        query.setColumns(true, new Key[0]);
        return query;
    }

    @NotNull
    public String getCriterionTemplate(@NotNull ValueCriterion valueCriterion) {
        switch (valueCriterion.getOperator()) {
            case EQ: {
                return "{0}={1}";
            }
            case NOT_EQ: {
                return "{0}<>{1}";
            }
            case GT: {
                return "{0}>{1}";
            }
            case GE: {
                return "{0}>={1}";
            }
            case LT: {
                return "{0}<{1}";
            }
            case LE: {
                return "{0}<={1}";
            }
            case EQUALS_CASE_INSENSITIVE: {
                return "LOWER({0})={1}";
            }
            case STARTS_CASE_INSENSITIVE: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "LOWER({0}) LIKE {1}";
            }
            case STARTS: 
            case ENDS: 
            case CONTAINS: {
                return "{0} LIKE {1}";
            }
            case IN: {
                return "{0} IN ({1})";
            }
            case NOT_IN: {
                return "NOT {0} IN ({1})";
            }
            case XFIXED: {
                return valueCriterion.evaluate((Ujo)null) ? "1=1" : "1=0";
            }
            case XSQL: {
                Object object = valueCriterion.getRightNode() instanceof TemplateValue ? ((TemplateValue)valueCriterion.getRightNode()).getTemplate() : valueCriterion.getRightNode();
                return "(" + object + ')';
            }
        }
        throw new UnsupportedOperationException("Unsupported: " + valueCriterion.getOperator());
    }

    public void printTableColumns(@NotNull Collection<? extends ColumnWrapper> collection, @Nullable Appendable appendable, @NotNull Appendable appendable2) throws IOException {
        String string = "";
        boolean bl = appendable == null;
        for (ColumnWrapper columnWrapper : collection) {
            MetaColumn metaColumn = columnWrapper.getModel();
            if (metaColumn.isForeignKey()) {
                for (int i = 0; i < metaColumn.getForeignColumns().size(); ++i) {
                    appendable2.append(string);
                    if (bl) {
                        this.printQuotedName(columnWrapper.getTableAlias(), QuoteEnum.BY_CONFIG, appendable2);
                        appendable2.append('.');
                    }
                    this.printQuotedName(metaColumn.getForeignColumnName(i), columnWrapper.getModel().get(MetaColumn.QUOTED), appendable2);
                    if (appendable != null) {
                        appendable.append(string);
                        appendable.append("?");
                    }
                    string = ", ";
                }
                continue;
            }
            if (!metaColumn.isColumn()) continue;
            appendable2.append(string);
            if (bl) {
                this.printColumnAlias(columnWrapper, appendable2);
            } else {
                this.printColumnName(metaColumn, appendable2);
            }
            if (appendable != null) {
                appendable.append(string);
                appendable.append("?");
            }
            string = ", ";
        }
    }

    @Nullable
    public ValueCriterion printCriterion(@NotNull ValueCriterion valueCriterion, @NotNull Appendable appendable) throws IOException {
        ColumnWrapper columnWrapper;
        Key key = valueCriterion.getLeftNode();
        Operator operator = valueCriterion.getOperator();
        Object object = valueCriterion.getRightNode();
        ColumnWrapper columnWrapper2 = columnWrapper = key != null ? AliasKey.getLastKey(key).getColumn(this.ormHandler) : null;
        if (object == null) {
            switch (operator) {
                case EQ: 
                case EQUALS_CASE_INSENSITIVE: {
                    this.printColumnAlias(columnWrapper, appendable);
                    appendable.append(" IS NULL");
                    return null;
                }
                case NOT_EQ: {
                    this.printColumnAlias(columnWrapper, appendable);
                    appendable.append(" IS NOT NULL");
                    return null;
                }
            }
            String string = MsgFormatter.format((CharSequence)"The NULL comparison by the {} operator is forbidden.", (Object[])new Operator[]{operator});
            throw new UnsupportedOperationException(string);
        }
        String string = this.getCriterionTemplate(valueCriterion);
        Assert.notNull((Object)string, (Object[])new Serializable[]{"Unsupported SQL operator: {}", operator});
        switch (operator) {
            case XFIXED: {
                appendable.append(string);
                break;
            }
            case XSQL: {
                if (object instanceof TemplateValue) {
                    Object object2 = ((TemplateValue)object).getRightVale();
                    ValueCriterion valueCriterion2 = (ValueCriterion)Criterion.where((Key)key, (Operator)Operator.EQ, (Object)object2);
                    return this.printCriterionValue(string, columnWrapper, valueCriterion2, appendable);
                }
                if (string.contains("{0}")) {
                    appendable.append(MessageFormat.format(string, this.getAliasColumnName(columnWrapper)));
                    break;
                }
                appendable.append(string);
                break;
            }
            default: {
                return this.printCriterionValue(string, columnWrapper, valueCriterion, appendable);
            }
        }
        return null;
    }

    @Nullable
    protected ValueCriterion printCriterionValue(@NotNull String string, @NotNull ColumnWrapper columnWrapper, @NotNull ValueCriterion valueCriterion, @NotNull Appendable appendable) throws IOException {
        ColumnWrapper columnWrapper2;
        Object object = valueCriterion.getRightNode();
        if (object instanceof Key) {
            Key key = (Key)object;
            columnWrapper2 = AliasKey.getLastKey(key).getColumn(this.ormHandler);
            if (columnWrapper2.getModel().isForeignKey()) {
                throw new UnsupportedOperationException("Foreign key is not supported yet");
            }
        } else {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                StringBuilder stringBuilder = new StringBuilder(2 * objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuilder.append(i > 0 ? ",?" : "?");
                }
                String string2 = MessageFormat.format(string, this.getAliasColumnName(columnWrapper), stringBuilder.toString());
                appendable.append(string2);
                return valueCriterion;
            }
            if (columnWrapper.getModel().isForeignKey()) {
                this.printForeignKey(valueCriterion, columnWrapper, string, appendable);
                return valueCriterion;
            }
            String string3 = MessageFormat.format(string, this.getAliasColumnName(columnWrapper), "?");
            appendable.append(string3);
            return valueCriterion;
        }
        appendable.append(MessageFormat.format(string, this.getAliasColumnName(columnWrapper), this.getAliasColumnName(columnWrapper2)));
        return null;
    }

    protected String getAliasColumnName(ColumnWrapper columnWrapper) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.printQuotedName(columnWrapper.getTableAlias(), QuoteEnum.BY_CONFIG, stringBuilder);
        stringBuilder.append('.');
        this.printColumnName(columnWrapper, stringBuilder);
        return ((Object)stringBuilder).toString();
    }

    public void printForeignKey(@NotNull ValueCriterion valueCriterion, @NotNull ColumnWrapper columnWrapper, @NotNull String string, @NotNull Appendable appendable) throws IOException {
        int n = columnWrapper.getModel().getForeignColumns().size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                appendable.append(' ');
                appendable.append(valueCriterion.getOperator().name());
                appendable.append(' ');
            }
            StringBuilder stringBuilder = new StringBuilder(256);
            String string2 = columnWrapper.getTableAlias();
            if (Check.hasLength((CharSequence)string2)) {
                this.printQuotedName(string2, QuoteEnum.BY_CONFIG, stringBuilder);
                stringBuilder.append('.');
            }
            this.printQuotedName(columnWrapper.getModel().getForeignColumnName(i), QuoteEnum.BY_CONFIG, stringBuilder);
            String string3 = MessageFormat.format(string, stringBuilder, "?");
            appendable.append(string3);
        }
    }

    public final Appendable printSelect(@NotNull TableWrapper tableWrapper, @NotNull Query query, boolean bl, @NotNull Appendable appendable) throws IOException {
        return tableWrapper.isView() ? this.printSelectView(tableWrapper, query, bl, appendable) : this.printSelectTable(query, bl, appendable);
    }

    protected Appendable printSelectView(@NotNull TableWrapper tableWrapper, @NotNull Query query, boolean bl, @NotNull Appendable appendable) throws IOException {
        String string = query.getSqlParameters() != null ? query.getSqlParameters().getSqlStatement() : null;
        MetaSelect metaSelect = string != null ? new MetaSelect(string, (String)MetaTable.SCHEMA.of((Ujo)tableWrapper.getModel())) : (MetaSelect)((Object)MetaTable.SELECT_MODEL.of((Ujo)tableWrapper.getModel()));
        String string2 = query.getDecoder().getWhere();
        List list = query.getOrderBy();
        for (Key key : metaSelect.readKeys()) {
            String string3 = (String)key.of((Ujo)metaSelect);
            if (key == MetaSelect.SELECT && bl) {
                appendable.append(key.toString());
                appendable.append("COUNT(*)");
                continue;
            }
            if (key == MetaSelect.WHERE && string3.length() + string2.length() > 0) {
                appendable.append(key.toString());
                appendable.append(string3);
                appendable.append(string3.length() == 0 || string2.length() == 0 ? "" : " AND ");
                appendable.append(string2);
                continue;
            }
            if (key == MetaSelect.ORDER && !bl && !list.isEmpty()) {
                this.printSelectOrder(query, appendable);
                continue;
            }
            if (key == MetaSelect.LIMIT && !bl && query.getLimit() > 0) {
                appendable.append(key.toString());
                appendable.append(String.valueOf(query.getLimit()));
                continue;
            }
            if (key == MetaSelect.OFFSET && !bl && query.getOffset() > 0L) {
                appendable.append(key.toString());
                appendable.append(String.valueOf(query.getOffset()));
                continue;
            }
            if (!Check.hasLength((CharSequence)string3)) continue;
            appendable.append(key.toString());
            appendable.append(string3);
        }
        return appendable;
    }

    protected Appendable printSelectTable(@NotNull Query query, boolean bl, @NotNull Appendable appendable) throws IOException {
        if (bl && query.isDistinct()) {
            appendable.append("SELECT COUNT(*) FROM (");
            this.printSelectTableBase(query, bl, appendable);
            appendable.append(NEW_LINE_SEPARATOR).append("GROUP BY ");
            this.printTableColumns(query.getColumns(), null, appendable);
            appendable.append(") ujorm_count_");
        } else {
            this.printSelectTableBase(query, bl, appendable);
        }
        return appendable;
    }

    protected void printSelectTableBase(@NotNull Query query, boolean bl, @NotNull Appendable appendable) throws IOException {
        appendable.append("SELECT ");
        if (bl != query.isDistinct()) {
            appendable.append(bl ? "COUNT(*)" : "DISTINCT ");
        }
        if (!bl || query.isDistinct()) {
            this.printTableColumns(query.getColumns(), null, appendable);
        }
        appendable.append(NEW_LINE_SEPARATOR).append("FROM ");
        if (query.getCriterion() != null) {
            CriterionDecoder criterionDecoder = query.getDecoder();
            this.printTableAliasDefinition(criterionDecoder.getBaseTable(), appendable);
            for (CriterionDecoder.Relation relation : criterionDecoder.getRelations()) {
                appendable.append(NEW_LINE_SEPARATOR);
                appendable.append(query.getOuterJoins().contains(relation.getLeft()) ? "LEFT OUTER" : "INNER");
                appendable.append(" JOIN ");
                this.printTableAliasDefinition(relation.getRight().buildTableWrapper(), appendable);
                appendable.append(" ON ");
                this.printColumnAlias(relation.getRight(), appendable);
                appendable.append('=');
                this.printColumnAlias(relation.getLeft(), appendable);
            }
            String string = criterionDecoder.getWhere();
            if (!string.isEmpty()) {
                appendable.append(NEW_LINE_SEPARATOR).append("WHERE ");
                appendable.append(string);
            }
        } else {
            this.printTableAliasDefinition(query.getTableModel(), appendable);
        }
        if (!bl) {
            if (!query.getOrderBy().isEmpty()) {
                this.printSelectOrder(query, appendable);
            }
            this.printLimitAndOffset(query, appendable);
            if (query.isLockRequest()) {
                appendable.append(' ');
                this.printLockForSelect(query, appendable);
            }
        }
    }

    protected Appendable printLockForSelect(@NotNull Query query, @NotNull Appendable appendable) throws IOException, UnsupportedOperationException {
        appendable.append("FOR UPDATE");
        return appendable;
    }

    protected void printSelectOrder(@NotNull Query query, @NotNull Appendable appendable) throws IOException {
        appendable.append(" ORDER BY ");
        List list = query.getOrderBy();
        for (int i = 0; i < list.size(); ++i) {
            ColumnWrapper columnWrapper = query.readOrderColumn(i);
            boolean bl = list.get(i).isAscending();
            if (i > 0) {
                appendable.append(", ");
            }
            this.printColumnAlias(columnWrapper, appendable);
            if (bl) continue;
            appendable.append(" DESC");
        }
    }

    public Appendable printCall(@NotNull MetaProcedure metaProcedure, @NotNull Appendable appendable) throws IOException {
        List list = (List)MetaProcedure.PARAMETERS.of((Ujo)metaProcedure);
        appendable.append('{').append(' ');
        if (!((MetaColumn)list.get(0)).isVoid()) {
            appendable.append("? =");
        }
        appendable.append(" call ");
        appendable.append(metaProcedure.getProcedureName());
        if (list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                appendable.append(i == 1 ? "(?" : ",?");
            }
            appendable.append(')');
        }
        appendable.append(' ').append('}');
        return appendable;
    }

    public void printLimitAndOffset(@NotNull Query query, @NotNull Appendable appendable) throws IOException {
        if (query.isLimit()) {
            appendable.append(" LIMIT ").append(String.valueOf(query.getLimit()));
        }
        if (query.isOffset()) {
            appendable.append(" OFFSET ").append(String.valueOf(query.getOffset()));
        }
    }

    protected Appendable printSequenceTableName(@NotNull UjoSequencer ujoSequencer, @NotNull Appendable appendable) throws IOException {
        return this.printSequenceTableName(ujoSequencer.getDatabaseSchema(), appendable);
    }

    public Appendable printSequenceTableName(@NotNull String string, @NotNull Appendable appendable) throws IOException {
        if (Check.hasLength((CharSequence)string)) {
            this.printQuotedName(string, QuoteEnum.BY_CONFIG, appendable);
            appendable.append('.');
        }
        this.printQuotedName(this.getSeqTableModel().getTableName(), QuoteEnum.BY_CONFIG, appendable);
        return appendable;
    }

    public Appendable printSequenceTable(@NotNull MetaDatabase metaDatabase, @NotNull Appendable appendable) throws IOException {
        Integer n = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)metaDatabase.getParams());
        MetaColumn metaColumn = new MetaColumn();
        MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BIGINT);
        appendable.append("CREATE TABLE ");
        this.printSequenceTableName((String)MetaDatabase.SCHEMA.of((Ujo)metaDatabase), appendable);
        appendable.append("" + NEW_LINE_SEPARATOR.concat("( ") + this.getQuotedName(this.getSeqTableModel().getId()) + " VARCHAR(96) NOT NULL PRIMARY KEY" + NEW_LINE_SEPARATOR.concat(", ") + this.getQuotedName(this.getSeqTableModel().getSequence()) + ' ' + this.getColumnType(metaColumn) + " DEFAULT " + n + " NOT NULL" + NEW_LINE_SEPARATOR.concat(", ") + this.getQuotedName(this.getSeqTableModel().getCache()) + " INT DEFAULT " + n + " NOT NULL" + NEW_LINE_SEPARATOR.concat(", ") + this.getQuotedName(this.getSeqTableModel().getMaxValue()) + ' ' + this.getColumnType(metaColumn) + " DEFAULT 0 NOT NULL" + NEW_LINE_SEPARATOR.concat(")"));
        return appendable;
    }

    public Appendable printSequenceInit(@NotNull UjoSequencer ujoSequencer, @NotNull Appendable appendable) throws IOException {
        Integer n = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)ujoSequencer.getDatabase().getParams());
        return this.printSequenceInitWithValues(ujoSequencer, n.intValue(), n, appendable);
    }

    public Appendable printSequenceInitWithValues(@NotNull UjoSequencer ujoSequencer, long l, int n, @NotNull Appendable appendable) throws IOException {
        appendable.append("INSERT INTO ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" (");
        this.printQuotedName(this.getSeqTableModel().getId(), appendable);
        appendable.append(',');
        this.printQuotedName(this.getSeqTableModel().getSequence(), appendable);
        appendable.append(',');
        this.printQuotedName(this.getSeqTableModel().getCache(), appendable);
        appendable.append(',');
        this.printQuotedName(this.getSeqTableModel().getMaxValue(), appendable);
        appendable.append(") VALUES (?," + l).append(',').append(Integer.toString(n)).append(",0)");
        return appendable;
    }

    public Appendable printSequenceNextValue(@NotNull UjoSequencer ujoSequencer, @NotNull Appendable appendable) throws IOException {
        appendable.append("UPDATE ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" SET ");
        this.printQuotedName(this.getSeqTableModel().getSequence(), appendable);
        appendable.append("=");
        this.printQuotedName(this.getSeqTableModel().getSequence(), appendable);
        appendable.append("+");
        this.printQuotedName(this.getSeqTableModel().getCache(), appendable);
        appendable.append(" WHERE ");
        this.printQuotedName(this.getSeqTableModel().getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    public Appendable printSetMaxSequence(@NotNull UjoSequencer ujoSequencer, @NotNull Appendable appendable) throws IOException {
        appendable.append("UPDATE ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" SET ");
        this.printQuotedName(this.getSeqTableModel().getSequence(), appendable);
        appendable.append("=");
        this.printQuotedName(this.getSeqTableModel().getMaxValue(), appendable);
        appendable.append(" WHERE ");
        this.printQuotedName(this.getSeqTableModel().getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    public Appendable printSequenceCurrentValue(@NotNull UjoSequencer ujoSequencer, @NotNull Appendable appendable) throws IOException {
        SeqTableModel seqTableModel = this.getSeqTableModel();
        appendable.append("SELECT ");
        this.printQuotedName(seqTableModel.getSequence(), appendable);
        appendable.append(", ");
        this.printQuotedName(seqTableModel.getCache(), appendable);
        appendable.append(", ");
        this.printQuotedName(seqTableModel.getMaxValue(), appendable);
        appendable.append(" FROM ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" WHERE ");
        this.printQuotedName(seqTableModel.getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    public Appendable printSequenceDeleteById(@NotNull UjoSequencer ujoSequencer, @NotNull String string, @NotNull Appendable appendable) throws IOException {
        SeqTableModel seqTableModel = this.getSeqTableModel();
        appendable.append("DELETE FROM ");
        this.printSequenceTableName(ujoSequencer, appendable);
        appendable.append(" WHERE ");
        this.printQuotedName(seqTableModel.getId(), appendable);
        appendable.append("=?");
        return appendable;
    }

    @Deprecated
    protected final boolean isFilled(CharSequence charSequence) {
        return Check.hasLength((CharSequence)charSequence);
    }

    public final void println(Appendable appendable) throws IOException {
        appendable.append('\n');
    }

    public Appendable printCommit(Appendable appendable) throws IOException {
        appendable.append("COMMIT");
        return appendable;
    }

    public Appendable printComment(@NotNull MetaTable metaTable, @NotNull Appendable appendable) throws IOException {
        appendable.append("COMMENT ON TABLE ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" IS '");
        this.escape((CharSequence)MetaTable.COMMENT.of((Ujo)metaTable), appendable);
        appendable.append("'");
        return appendable;
    }

    public Appendable printComment(@NotNull MetaColumn metaColumn, @NotNull Appendable appendable) throws IOException {
        appendable.append("COMMENT ON COLUMN ");
        this.printFullTableName((MetaTable)MetaColumn.TABLE.of((Ujo)metaColumn), appendable);
        appendable.append('.');
        appendable.append(metaColumn.getName());
        appendable.append(" IS '");
        this.escape((CharSequence)MetaColumn.COMMENT.of((Ujo)metaColumn), appendable);
        appendable.append("'");
        return appendable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeywordSet(@NotNull Connection connection) {
        HashSet<String> hashSet = new HashSet<String>(128);
        Reader reader = null;
        try {
            reader = new CharArrayReader(connection.getMetaData().getSQLKeywords().concat(",").toCharArray());
            this.assignKeywords(hashSet, reader);
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/ujorm/orm/sql-keywords.txt"), "UTF8"));
            this.assignKeywords(hashSet, reader);
        }
        catch (IOException | OutOfMemoryError | RuntimeException | SQLException throwable) {
            LOGGER.log(UjoLogger.WARN, "Can't read SQL keywords", throwable);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(UjoLogger.WARN, "Can't close reader", (Throwable)iOException);
                }
            }
        }
        hashSet.remove("");
        return hashSet;
    }

    private void assignKeywords(@NotNull Set<String> set, @NotNull Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != -1) {
            if (n == 44) {
                String string = stringBuilder.toString().trim().toUpperCase(Locale.ENGLISH);
                if (!string.startsWith("--")) {
                    set.add(string);
                }
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append((char)n);
        }
    }

    protected final void escape(@NotNull CharSequence charSequence, @NotNull Appendable appendable) throws IOException {
        block3: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\'': {
                    appendable.append("''");
                    continue block3;
                }
                default: {
                    appendable.append(c);
                }
            }
        }
    }

    public SeqTableModel getSeqTableModel() {
        return this.pkTableModel;
    }

    public void releaseSavepoint(@NotNull Connection connection, @NotNull Savepoint savepoint, boolean bl) throws SQLException {
        connection.releaseSavepoint(savepoint);
    }

    protected final Appendable printColumnName(@NotNull ColumnWrapper columnWrapper, @NotNull Appendable appendable) throws IOException {
        return this.printQuotedName(columnWrapper.getName(), columnWrapper.getModel().get(MetaColumn.QUOTED), appendable);
    }

    public Appendable printQuotedName(@NotNull CharSequence charSequence, @NotNull QuoteEnum quoteEnum, @NotNull Appendable appendable) throws IOException {
        block0 : switch (quoteEnum) {
            case BY_CONFIG: {
                switch (this.getQuotingPolicy()) {
                    case QUOTE_SQL_NAMES: {
                        this.printQuotedName(charSequence, appendable);
                        break block0;
                    }
                    case QUOTE_ONLY_SQL_KEYWORDS: {
                        if (this.ormHandler.getParameters().get(MetaParams.KEYWORD_SET).contains(charSequence.toString().toUpperCase(Locale.ENGLISH))) {
                            this.printQuotedName(charSequence, appendable);
                            break block0;
                        }
                        appendable.append(charSequence);
                        break block0;
                    }
                }
                appendable.append(charSequence);
                break;
            }
            case YES: {
                this.printQuotedName(charSequence, appendable);
                break;
            }
            case NO: {
                appendable.append(charSequence);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported policy: " + (Object)((Object)quoteEnum));
            }
        }
        return appendable;
    }

    public Appendable printQuotedName(@NotNull CharSequence charSequence, @NotNull Appendable appendable) throws IOException {
        appendable.append(this.getQuoteChar(true));
        appendable.append(charSequence);
        appendable.append(this.getQuoteChar(false));
        return appendable;
    }

    protected char getQuoteChar(boolean bl) {
        return '\"';
    }

    @NotNull
    protected CheckReport getQuotingPolicy() {
        if (this.quotingPolicy == null) {
            this.quotingPolicy = this.ormHandler.getParameters().getQuotationPolicy();
        }
        return this.quotingPolicy;
    }

    public final String getQuotedName(@NotNull CharSequence charSequence) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 4);
        this.printQuotedName(charSequence, stringBuilder);
        return stringBuilder.toString();
    }

    public SqlNameProvider getNameProvider() throws IllegalUjormException {
        if (this.nameProvider == null) {
            try {
                this.nameProvider = (SqlNameProvider)((Class)MetaParams.SQL_NAME_PROVIDER.of((Ujo)this.ormHandler.getParameters())).newInstance();
            }
            catch (ReflectiveOperationException | RuntimeException exception) {
                throw new IllegalUjormException("Can't create an instance of the " + (Object)((Object)this.ormHandler.getParameters()), (Throwable)exception);
            }
        }
        return this.nameProvider;
    }

    public Appendable printNextSequence(@NotNull String string, @NotNull MetaTable metaTable, @NotNull Appendable appendable) throws IOException {
        appendable.append("SELECT NEXTVAL('");
        appendable.append(string);
        appendable.append("')");
        return appendable;
    }
}

