/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.awt.Color;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.extensions.StringWrapper;
import org.ujorm.extensions.ValueWrapper;
import org.ujorm.orm.BytesWrapper;
import org.ujorm.orm.DbType;
import org.ujorm.orm.ITypeService;
import org.ujorm.orm.ao.UjoStatement;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;

public class TypeService
implements ITypeService<Object, Object> {
    public static final char UNDEFINED = '!';
    public static final char BOOLEAN = '\"';
    public static final char BYTE = '#';
    public static final char CHAR = '$';
    public static final char SHORT = '%';
    public static final char INT = '&';
    public static final char LONG = '\'';
    public static final char FLOAT = '(';
    public static final char DOUBLE = ')';
    public static final char BIG_DECI = '*';
    public static final char BIG_INTE = '+';
    public static final char STRING = ',';
    public static final char BYTES = '-';
    public static final char DATE_UTIL = '.';
    public static final char DATE_SQL = '/';
    public static final char TIME_SQL = '0';
    public static final char TIMESTAMP = '1';
    public static final char BLOB = '2';
    public static final char CLOB = '3';
    public static final char EXPORT_ENUM = '4';
    public static final char STRING_WRAP = '5';
    public static final char BYTES_WRAP = '6';
    public static final char ENUM = '7';
    public static final char COLOR = '8';
    public static final char UUID = '9';
    public static final char LOCAL_DATE = ':';
    public static final char LOCAL_TIME = ';';
    public static final char LOCAL_DATE_TIME = '<';
    public static final char OFFSET_DATE_TIME = '=';
    private static final Class[] STR_ARGS = new Class[]{String.class};
    private static final Class[] BYTES_ARGS = new Class[]{byte[].class};

    public static char getTypeCode(@NotNull MetaColumn metaColumn) {
        List<MetaColumn> list;
        Class clazz;
        Class clazz2 = metaColumn.getType();
        Class clazz3 = clazz = metaColumn.isValueWrapper() ? ValueWrapper.getInstance((Class)clazz2).readPersistentClass() : clazz2;
        if (StringWrapper.class.isAssignableFrom(clazz)) {
            return clazz.isEnum() ? (char)'4' : '5';
        }
        if (BytesWrapper.class.isAssignableFrom(clazz)) {
            return '6';
        }
        if (clazz == String.class) {
            return ',';
        }
        if (clazz == Boolean.class) {
            return '\"';
        }
        if (clazz == Byte.class) {
            return '#';
        }
        if (clazz == Character.class) {
            return '$';
        }
        if (clazz == Short.class) {
            return '%';
        }
        if (clazz == Integer.class) {
            return '&';
        }
        if (clazz == Long.class) {
            return '\'';
        }
        if (clazz == Float.class) {
            return '(';
        }
        if (clazz == Double.class) {
            return ')';
        }
        if (clazz == BigDecimal.class) {
            return '*';
        }
        if (clazz == BigInteger.class) {
            return '+';
        }
        if (clazz == byte[].class) {
            return '-';
        }
        if (clazz == java.util.Date.class) {
            return '.';
        }
        if (clazz == Date.class) {
            return '/';
        }
        if (clazz == Time.class) {
            return '0';
        }
        if (clazz == Timestamp.class) {
            return '1';
        }
        if (clazz == LocalDate.class) {
            return ':';
        }
        if (clazz == LocalTime.class) {
            return ';';
        }
        if (clazz == LocalDateTime.class) {
            return '<';
        }
        if (clazz == OffsetDateTime.class) {
            return '=';
        }
        if (clazz == Blob.class) {
            return '2';
        }
        if (clazz == Clob.class) {
            return '3';
        }
        if (clazz.isEnum()) {
            return '7';
        }
        if (clazz == Color.class) {
            return '8';
        }
        if (clazz == UUID.class) {
            return '9';
        }
        if (metaColumn.isForeignKey() && (list = metaColumn.getForeignColumns()).size() == 1) {
            return TypeService.getTypeCode(list.get(0));
        }
        return '!';
    }

    @Override
    public Object getValue(@NotNull MetaColumn metaColumn, @NotNull ResultSet resultSet, int n) throws SQLException {
        Comparable<Boolean> comparable;
        switch (metaColumn.getTypeCode()) {
            case '\"': {
                comparable = resultSet.getBoolean(n);
                break;
            }
            case '#': {
                comparable = resultSet.getByte(n);
                break;
            }
            case '$': {
                String string = resultSet.getString(n);
                return string != null && string.length() > 0 ? Character.valueOf(string.charAt(0)) : null;
            }
            case '%': {
                comparable = resultSet.getShort(n);
                break;
            }
            case '&': {
                comparable = resultSet.getInt(n);
                break;
            }
            case '\'': {
                comparable = resultSet.getLong(n);
                break;
            }
            case '(': {
                comparable = Float.valueOf(resultSet.getFloat(n));
                break;
            }
            case ')': {
                comparable = resultSet.getDouble(n);
                break;
            }
            case '*': {
                return resultSet.getBigDecimal(n);
            }
            case '+': {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                return bigDecimal != null ? bigDecimal.toBigInteger() : null;
            }
            case ',': {
                return resultSet.getString(n);
            }
            case '-': {
                return resultSet.getBytes(n);
            }
            case '.': {
                Timestamp timestamp = resultSet.getTimestamp(n);
                return timestamp != null ? new java.util.Date(timestamp.getTime()) : null;
            }
            case '/': {
                return resultSet.getDate(n);
            }
            case '0': {
                return resultSet.getTime(n);
            }
            case '1': {
                return resultSet.getTimestamp(n);
            }
            case ':': 
            case ';': 
            case '<': 
            case '=': {
                return resultSet.getObject(n, metaColumn.getType());
            }
            case '2': {
                return resultSet.getBlob(n);
            }
            case '3': {
                return resultSet.getClob(n);
            }
            case '7': {
                int n2 = resultSet.getInt(n);
                return n2 == 0 && resultSet.wasNull() ? null : metaColumn.getType().getEnumConstants()[n2];
            }
            case '8': {
                int n3 = resultSet.getInt(n);
                return n3 == 0 && resultSet.wasNull() ? null : new Color(n3);
            }
            case '5': {
                return this.createStringWrapper(resultSet.getString(n), metaColumn);
            }
            case '6': {
                return this.createBytesWrapper(resultSet.getBytes(n), metaColumn);
            }
            case '4': {
                return this.findEnum(resultSet.getString(n), metaColumn);
            }
            default: {
                Class clazz = metaColumn.isForeignKey() ? metaColumn.getForeignColumns().get(0).getType() : metaColumn.getType();
                return resultSet.getObject(n, clazz);
            }
        }
        return resultSet.wasNull() ? null : comparable;
    }

    @Override
    public Object getValue(@NotNull MetaColumn metaColumn, @NotNull CallableStatement callableStatement, int n) throws SQLException {
        Comparable<Boolean> comparable;
        switch (metaColumn.getTypeCode()) {
            case '\"': {
                comparable = callableStatement.getBoolean(n);
                break;
            }
            case '#': {
                comparable = callableStatement.getByte(n);
                break;
            }
            case '$': {
                String string = callableStatement.getString(n);
                return string != null && string.length() > 0 ? Character.valueOf(string.charAt(0)) : null;
            }
            case '%': {
                comparable = callableStatement.getShort(n);
                break;
            }
            case '&': {
                comparable = callableStatement.getInt(n);
                break;
            }
            case '\'': {
                comparable = callableStatement.getLong(n);
                break;
            }
            case '(': {
                comparable = Float.valueOf(callableStatement.getFloat(n));
                break;
            }
            case ')': {
                comparable = callableStatement.getDouble(n);
                break;
            }
            case '*': {
                return callableStatement.getBigDecimal(n);
            }
            case '+': {
                BigDecimal bigDecimal = callableStatement.getBigDecimal(n);
                return bigDecimal != null ? bigDecimal.toBigInteger() : null;
            }
            case ',': {
                return callableStatement.getString(n);
            }
            case '-': {
                return callableStatement.getBytes(n);
            }
            case '.': {
                Timestamp timestamp = callableStatement.getTimestamp(n);
                return timestamp != null ? new java.util.Date(timestamp.getTime()) : null;
            }
            case '/': {
                return callableStatement.getDate(n);
            }
            case '0': {
                return callableStatement.getTime(n);
            }
            case '1': {
                return callableStatement.getTimestamp(n);
            }
            case ':': 
            case ';': 
            case '<': 
            case '=': {
                return callableStatement.getObject(n, metaColumn.getType());
            }
            case '2': {
                return callableStatement.getBlob(n);
            }
            case '3': {
                return callableStatement.getClob(n);
            }
            case '7': {
                int n2 = callableStatement.getInt(n);
                return n2 == 0 && callableStatement.wasNull() ? null : metaColumn.getType().getEnumConstants()[n2];
            }
            case '8': {
                int n3 = callableStatement.getInt(n);
                return n3 == 0 && callableStatement.wasNull() ? null : new Color(n3);
            }
            case '5': {
                return this.createStringWrapper(callableStatement.getString(n), metaColumn);
            }
            case '6': {
                return this.createBytesWrapper(callableStatement.getBytes(n), metaColumn);
            }
            case '4': {
                return this.findEnum(callableStatement.getString(n), metaColumn);
            }
            default: {
                Class clazz = metaColumn.isForeignKey() ? metaColumn.getForeignColumns().get(0).getType() : metaColumn.getType();
                return callableStatement.getObject(n, clazz);
            }
        }
        return callableStatement.wasNull() ? null : comparable;
    }

    @Override
    public void setValue(@NotNull MetaColumn metaColumn, @NotNull PreparedStatement preparedStatement, @Nullable Object object, int n) throws SQLException {
        if (object == null) {
            int n2 = ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))).getSqlType();
            preparedStatement.setNull(n, n2);
            return;
        }
        Object object2 = metaColumn.isValueWrapper() ? ((ValueWrapper)object).readPersistentValue() : object;
        switch (metaColumn.getTypeCode()) {
            case '\"': {
                preparedStatement.setBoolean(n, (Boolean)object2);
                break;
            }
            case '#': {
                preparedStatement.setByte(n, (Byte)object2);
                break;
            }
            case '$': {
                preparedStatement.setString(n, String.valueOf(object2));
                break;
            }
            case '%': {
                preparedStatement.setShort(n, (Short)object2);
                break;
            }
            case '&': {
                preparedStatement.setInt(n, (Integer)object2);
                break;
            }
            case '\'': {
                preparedStatement.setLong(n, (Long)object2);
                break;
            }
            case '(': {
                preparedStatement.setFloat(n, ((Float)object2).floatValue());
                break;
            }
            case ')': {
                preparedStatement.setDouble(n, (Double)object2);
                break;
            }
            case '*': {
                preparedStatement.setBigDecimal(n, (BigDecimal)object2);
                break;
            }
            case '+': {
                preparedStatement.setBigDecimal(n, new BigDecimal((BigInteger)object2));
                break;
            }
            case ',': {
                preparedStatement.setString(n, (String)object2);
                break;
            }
            case '-': {
                preparedStatement.setBytes(n, (byte[])object2);
                break;
            }
            case '.': {
                preparedStatement.setTimestamp(n, new Timestamp(((java.util.Date)object2).getTime()));
                break;
            }
            case '/': {
                preparedStatement.setDate(n, (Date)object2);
                break;
            }
            case '0': {
                preparedStatement.setTime(n, (Time)object2);
                break;
            }
            case '1': {
                preparedStatement.setTimestamp(n, (Timestamp)object2);
                break;
            }
            case '2': {
                preparedStatement.setBlob(n, (Blob)object2);
                break;
            }
            case '3': {
                preparedStatement.setClob(n, (Clob)object2);
                break;
            }
            case '7': {
                preparedStatement.setInt(n, ((Enum)object2).ordinal());
                break;
            }
            case '8': {
                preparedStatement.setInt(n, ((Color)object2).getRGB());
                break;
            }
            case '4': 
            case '5': {
                preparedStatement.setString(n, object2 != null ? ((StringWrapper)object2).exportToString() : null);
                break;
            }
            case '6': {
                preparedStatement.setBytes(n, object2 != null ? ((BytesWrapper)object2).exportToBytes() : null);
                break;
            }
            default: {
                preparedStatement.setObject(n, object2, ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))).getSqlType());
            }
        }
    }

    private Object findEnum(@Nullable String string, @NotNull MetaColumn metaColumn) throws IllegalUjormException {
        if (Check.isEmpty((CharSequence)string)) {
            return null;
        }
        for (Object t : metaColumn.getType().getEnumConstants()) {
            if (!string.equals(((StringWrapper)t).exportToString())) continue;
            return t;
        }
        String string2 = MsgFormatter.format((CharSequence)"No enum was found for the key {} type of {} using the value: '{}'.", (Object[])new Serializable[]{metaColumn, metaColumn.getType().getSimpleName(), string});
        throw new IllegalUjormException(string2);
    }

    private Object createStringWrapper(@Nullable String string, @NotNull MetaColumn metaColumn) throws IllegalUjormException {
        if (Check.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            Object t = metaColumn.getType().getConstructor(STR_ARGS).newInstance(string);
            return t;
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            throw new IllegalUjormException("Bad value export " + metaColumn.getType() + "." + string, (Throwable)exception);
        }
    }

    private Object createBytesWrapper(@Nullable byte[] byArray, @NotNull MetaColumn metaColumn) throws IllegalUjormException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            Object t = metaColumn.getType().getConstructor(BYTES_ARGS).newInstance(new Object[]{byArray});
            return t;
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            throw new IllegalUjormException("Bad value export " + metaColumn.getType() + "." + byArray, (Throwable)exception);
        }
    }

    @Override
    public Class getDbTypeClass(@NotNull MetaColumn metaColumn) {
        Object object;
        assert (metaColumn.getConverter() == this) : "Invalid column for this service: " + metaColumn;
        switch (metaColumn.getTypeCode()) {
            case '#': {
                return metaColumn.getType();
            }
            case '$': {
                return metaColumn.getType();
            }
        }
        Class<?> clazz = metaColumn.getType();
        Class<?> clazz2 = metaColumn.isValueWrapper() ? ValueWrapper.getInstance((Class)clazz).readPersistentClass() : clazz;
        Object object2 = metaColumn.getKey().getDefault();
        if (object2 == null) {
            if (clazz2.isEnum()) {
                object2 = clazz2.getEnumConstants()[0];
            } else {
                return clazz2;
            }
        }
        if (!metaColumn.readOnly() && metaColumn.getTypeCode() == '!') {
            metaColumn.initTypeCode();
        }
        if ((object = new UjoStatement().getDatabaseValue(metaColumn, object2)) instanceof Integer) {
            switch (metaColumn.getTypeCode()) {
                case '7': {
                    return Short.class;
                }
            }
        }
        return object != null ? object.getClass() : clazz2;
    }
}

