/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Unmodifiable;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.KeyFactory;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;

@Unmodifiable
public final class MetaPKey
extends AbstractMetaModel {
    private static final Class<MetaPKey> CLASS = MetaPKey.class;
    private static final KeyFactory<MetaPKey> fa = KeyFactory.CamelBuilder.get(CLASS);
    public static final Key<MetaPKey, MetaTable> TABLE = fa.newKey("table");
    public static final ListKey<MetaPKey, MetaColumn> COLUMNS = fa.newListKey("columns");

    public MetaPKey(MetaTable metaTable) {
        TABLE.setValue((Ujo)this, (Object)metaTable);
        COLUMNS.setValue((Ujo)this, new ArrayList(0));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        for (MetaColumn metaColumn : COLUMNS.getList((Ujo)this)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(metaColumn.toString());
        }
        return stringBuilder.toString();
    }

    public boolean assignPrimaryKey(OrmUjo ormUjo, Session session) throws IllegalUjormException {
        int n = COLUMNS.getItemCount((Ujo)this);
        if (n == 1) {
            MetaColumn metaColumn = (MetaColumn)COLUMNS.getItem((Ujo)this, 0);
            Key key = metaColumn.getKey();
            if (key.of((Ujo)ormUjo) != null) {
                return false;
            }
            switch (metaColumn.getTypeCode()) {
                case '\'': {
                    ormUjo.writeValue(key, this.nextValue(session));
                    return true;
                }
                case '&': {
                    ormUjo.writeValue(key, (int)this.nextValue(session));
                    return true;
                }
                case '%': {
                    ormUjo.writeValue(key, (short)this.nextValue(session));
                    return true;
                }
                case '#': {
                    ormUjo.writeValue(key, (byte)this.nextValue(session));
                    return true;
                }
                case '+': {
                    ormUjo.writeValue(key, BigInteger.valueOf(this.nextValue(session)));
                    return true;
                }
                case ',': {
                    ormUjo.writeValue(key, String.valueOf(this.nextValue(session)));
                    return true;
                }
                case '9': {
                    ormUjo.writeValue(key, UUID.randomUUID());
                    return true;
                }
            }
            return false;
        }
        for (int i = 0; i < n; ++i) {
            MetaColumn metaColumn = (MetaColumn)COLUMNS.getItem((Ujo)this, i);
            Key key = metaColumn.getKey();
            Assert.notNull((Object)key.of((Ujo)ormUjo), (Object[])new Object[]{"Table {} must have defined only one primary key type of Long, Integer, Short, Byte, BigInteger or String for an auto-increment support", ormUjo});
        }
        return false;
    }

    protected final long nextValue(Session session) {
        return ((MetaTable)TABLE.of((Ujo)this)).getSequencer().nextValue(session);
    }

    public MetaColumn getFirstColumn() {
        return this.getColumn(0);
    }

    public MetaColumn getColumn(int n) {
        return (MetaColumn)((List)COLUMNS.of((Ujo)this)).get(n);
    }

    public int getCount() {
        return COLUMNS.getItemCount((Ujo)this);
    }

    static {
        fa.lock();
    }
}

