/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.UjoManager;
import org.ujorm.core.annot.Transient;
import org.ujorm.core.annot.XmlAttribute;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.annot.Comment;
import org.ujorm.orm.annot.Table;
import org.ujorm.orm.annot.View;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.ao.QuoteEnum;
import org.ujorm.orm.impl.TableWrapperImpl;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaSelect;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;

@Unmodifiable
public final class MetaTable
extends AbstractMetaModel
implements TableWrapper {
    private static final Class<MetaTable> CLASS = MetaTable.class;
    private static final KeyFactory<MetaTable> fa = KeyFactory.CamelBuilder.get(CLASS);
    @XmlAttribute
    public static final Key<MetaTable, String> ID = fa.newKey("id", (Object)"");
    public static final Key<MetaTable, String> NAME = fa.newKey("name", (Object)"");
    public static final Key<MetaTable, QuoteEnum> QUOTED = fa.newKey("quoted", (Object)QuoteEnum.BY_CONFIG);
    public static final Key<MetaTable, String> ALIAS = fa.newKey("alias", (Object)"");
    public static final Key<MetaTable, String> SCHEMA = fa.newKey("schema", (Object)"");
    public static final Key<MetaTable, Boolean> READ_ONLY = fa.newKey("readOnly", (Object)false);
    public static final Key<MetaTable, Orm2ddlPolicy> ORM2DLL_POLICY = fa.newKey("orm2ddlPolicy", (Object)Orm2ddlPolicy.INHERITED);
    public static final Key<MetaTable, String> SEQUENCE = fa.newKey("sequence", (Object)"");
    @XmlAttribute
    public static final Key<MetaTable, Boolean> VIEW = fa.newKey("view", (Object)false);
    public static final Key<MetaTable, String> SELECT = fa.newKey("select", (Object)"");
    public static final Key<MetaTable, String> COMMENT = fa.newKey("comment", (Object)"");
    public static final ListKey<MetaTable, MetaColumn> COLUMNS = fa.newListKey("column");
    public static final ListKey<MetaTable, MetaRelation2Many> RELATIONS = fa.newListKey("relation2m");
    @Transient
    public static final Key<MetaTable, MetaSelect> SELECT_MODEL = fa.newKey("selectModel");
    @Transient
    public static final Key<MetaTable, MetaPKey> PK = fa.newKey("pk");
    @Transient
    public static final Key<MetaTable, RelationToMany> DB_PROPERTY = fa.newKey("dbProperty");
    @Transient
    public static final Key<MetaTable, MetaDatabase> DATABASE = fa.newKey("database");
    private final UjoSequencer sequencer;
    private Boolean sequenceSchemaSymbol;

    public MetaTable() {
        this.sequencer = null;
    }

    public MetaTable(MetaDatabase metaDatabase, RelationToMany<?, ?> relationToMany, MetaTable metaTable) {
        Object object;
        Object object2;
        this.sequencer = metaDatabase.createSequencer(this);
        ID.setValue((Ujo)this, (Object)relationToMany.getName());
        DATABASE.setValue((Ujo)this, (Object)metaDatabase);
        DB_PROPERTY.setValue((Ujo)this, relationToMany);
        Field field = UjoManager.getPropertyField((Ujo)((Ujo)MetaDatabase.ROOT.of((Ujo)metaDatabase)), relationToMany);
        View view = field != null ? field.getAnnotation(View.class) : null;
        View view2 = relationToMany.getItemType().getAnnotation(View.class);
        VIEW.setValue((Ujo)this, (Object)(view != null || view2 != null ? 1 : 0));
        if (metaTable != null) {
            this.changeDefault(this, NAME, NAME.of((Ujo)metaTable));
            this.changeDefault(this, ALIAS, ALIAS.of((Ujo)metaTable));
            this.changeDefault(this, SCHEMA, SCHEMA.of((Ujo)metaTable));
            this.changeDefault(this, READ_ONLY, READ_ONLY.of((Ujo)metaTable));
            this.changeDefault(this, ORM2DLL_POLICY, ORM2DLL_POLICY.of((Ujo)metaTable));
            this.changeDefault(this, SEQUENCE, SEQUENCE.of((Ujo)metaTable));
            this.changeDefault(this, SELECT, SELECT.of((Ujo)metaTable));
            this.changeDefault(this, VIEW, VIEW.of((Ujo)metaTable));
            this.changeDefault(this, COMMENT, COMMENT.of((Ujo)metaTable));
            this.changeDefault(this, QUOTED, QUOTED.of((Ujo)metaTable));
        }
        if (((Boolean)VIEW.of((Ujo)this)).booleanValue()) {
            if (view != null) {
                this.changeDefault(this, NAME, view.name());
            }
            if (view != null) {
                this.changeDefault(this, NAME, view.value());
            }
            if (view != null) {
                this.changeDefault(this, ALIAS, view.alias());
            }
            if (view != null) {
                this.changeDefault(this, SCHEMA, view.schema());
            }
            if (view != null) {
                this.changeDefault(this, SELECT, view.select());
            }
            if (view2 != null) {
                this.changeDefault(this, NAME, view2.name());
            }
            if (view2 != null) {
                this.changeDefault(this, NAME, view2.value());
            }
            if (view2 != null) {
                this.changeDefault(this, ALIAS, view2.alias());
            }
            if (view2 != null) {
                this.changeDefault(this, SCHEMA, view2.schema());
            }
            if (view2 != null) {
                this.changeDefault(this, SELECT, view2.select());
            }
        } else {
            object2 = field != null ? field.getAnnotation(Table.class) : null;
            object = relationToMany.getItemType().getAnnotation(Table.class);
            if (object2 != null) {
                this.changeDefault(this, NAME, object2.name());
            }
            if (object2 != null) {
                this.changeDefault(this, NAME, object2.value());
            }
            if (object2 != null) {
                this.changeDefault(this, ALIAS, object2.alias());
            }
            if (object2 != null) {
                this.changeDefault(this, SCHEMA, object2.schema());
            }
            if (object2 != null) {
                this.changeDefault(this, READ_ONLY, object2.readOnly());
            }
            if (object2 != null) {
                this.changeDefault(this, ORM2DLL_POLICY, object2.orm2ddlPolicy());
            }
            if (object2 != null) {
                this.changeDefault(this, SEQUENCE, object2.sequence());
            }
            if (object2 != null) {
                this.changeDefault(this, QUOTED, object2.quoted());
            }
            if (object != null) {
                this.changeDefault(this, NAME, object.name());
            }
            if (object != null) {
                this.changeDefault(this, NAME, object.value());
            }
            if (object != null) {
                this.changeDefault(this, ALIAS, object.alias());
            }
            if (object != null) {
                this.changeDefault(this, SCHEMA, object.schema());
            }
            if (object != null) {
                this.changeDefault(this, READ_ONLY, object.readOnly());
            }
            if (object != null) {
                this.changeDefault(this, ORM2DLL_POLICY, object.orm2ddlPolicy());
            }
            if (object != null) {
                this.changeDefault(this, SEQUENCE, object.sequence());
            }
            if (object != null) {
                this.changeDefault(this, QUOTED, object.quoted());
            }
        }
        this.changeDefault(this, SCHEMA, MetaDatabase.SCHEMA.of((Ujo)metaDatabase));
        this.changeDefault(this, READ_ONLY, MetaDatabase.READ_ONLY.of((Ujo)metaDatabase));
        this.changeDefault(this, ORM2DLL_POLICY, MetaDatabase.ORM2DLL_POLICY.of((Ujo)metaDatabase));
        this.changeDefault(this, NAME, relationToMany.getName());
        object2 = (String)MetaParams.TABLE_ALIAS_PREFIX.of((Ujo)metaDatabase.getParams());
        object = (String)MetaParams.TABLE_ALIAS_SUFFIX.of((Ujo)metaDatabase.getParams());
        this.changeDefault(this, ALIAS, (String)object2 + (String)NAME.of((Ujo)this) + (String)object);
        Comment comment = field != null ? field.getAnnotation(Comment.class) : null;
        Comment comment2 = relationToMany.getItemType().getAnnotation(Comment.class);
        if (comment != null) {
            this.changeDefault(this, COMMENT, comment.value());
        }
        if (comment2 != null) {
            this.changeDefault(this, COMMENT, comment2.value());
        }
        if (((Boolean)VIEW.of((Ujo)this)).booleanValue() && !SELECT.isDefault((Ujo)this)) {
            SELECT_MODEL.setValue((Ujo)this, (Object)new MetaSelect(this));
        }
        MetaPKey metaPKey = new MetaPKey(this);
        PK.setValue((Ujo)this, (Object)metaPKey);
        OrmHandler ormHandler = metaDatabase.getOrmHandler();
        UjoManager ujoManager = UjoManager.getInstance();
        UjoManager.newInstance((Class)relationToMany.getItemType());
        for (Key<Ujo, Object> key : this.getColumns(relationToMany.getItemType())) {
            MetaRelation2Many metaRelation2Many;
            MetaRelation2Many metaRelation2Many2;
            if (ujoManager.isTransient(key)) continue;
            String string = key.getName();
            if (key instanceof RelationToMany) {
                metaRelation2Many2 = metaTable != null ? metaTable.findRelation(string) : null;
                metaRelation2Many = new MetaRelation2Many(this, key, metaRelation2Many2);
                RELATIONS.addItem((Ujo)this, (Object)metaRelation2Many);
                ormHandler.addColumnModel(metaRelation2Many);
                continue;
            }
            metaRelation2Many2 = metaTable != null ? metaTable.findColumn(string) : null;
            metaRelation2Many = new MetaColumn(this, key, (MetaColumn)metaRelation2Many2);
            COLUMNS.addItem((Ujo)this, (Object)metaRelation2Many);
            ormHandler.addColumnModel(metaRelation2Many);
            if (!((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)metaRelation2Many)).booleanValue()) continue;
            MetaPKey.COLUMNS.addItem((Ujo)metaPKey, (Object)metaRelation2Many);
        }
        if (QUOTED.isDefault((Ujo)this)) {
            switch (ormHandler.getParameters().get(MetaParams.QUOTATION_POLICY)) {
                case QUOTE_SQL_NAMES: {
                    QUOTED.setValue((Ujo)this, (Object)QuoteEnum.YES);
                    break;
                }
                case QUOTE_ONLY_SQL_KEYWORDS: {
                    QUOTED.setValue((Ujo)this, (Object)QuoteEnum.BY_CONFIG);
                    break;
                }
                default: {
                    QUOTED.setValue((Ujo)this, (Object)QuoteEnum.NO);
                }
            }
        }
    }

    private Iterable<Key<Ujo, Object>> getColumns(Class clazz) {
        return UjoManager.getInstance().readKeys(clazz);
    }

    public void assignPrimaryKey(OrmUjo ormUjo, Session session) {
        Class<OrmUjo> clazz = this.getType();
        Assert.isTrue((boolean)clazz.isInstance(ormUjo), (Object[])new Serializable[]{"Argument is not type of {}", clazz});
        try {
            MetaPKey metaPKey = (MetaPKey)((Object)PK.of((Ujo)this));
            metaPKey.assignPrimaryKey(ormUjo, session);
        }
        catch (OutOfMemoryError | RuntimeException throwable) {
            throw new IllegalUjormException("DB SEQUENCE is not supported for " + clazz, throwable);
        }
    }

    public OrmUjo createBO() throws ReflectiveOperationException {
        OrmUjo ormUjo = this.getType().newInstance();
        return ormUjo;
    }

    public final Class<OrmUjo> getType() {
        return ((RelationToMany)((Object)DB_PROPERTY.of((Ujo)this))).getItemType();
    }

    public MetaColumn getFirstPK() {
        return ((MetaPKey)((Object)PK.of((Ujo)this))).getFirstColumn();
    }

    public boolean isPersistent() {
        return this.getDatabase() != null;
    }

    public boolean isDefaultSchema() {
        if (this.sequenceSchemaSymbol == null) {
            this.sequenceSchemaSymbol = this.getDatabase().getParams().get(MetaParams.SEQUENCE_SCHEMA_SYMBOL);
        }
        if (this.sequenceSchemaSymbol.booleanValue()) {
            String string = (String)SCHEMA.of((Ujo)this);
            String string2 = (String)MetaDatabase.SCHEMA.of((Ujo)this.getDatabase());
            return string.equals(string2);
        }
        return false;
    }

    @Override
    public boolean isView() {
        return (Boolean)VIEW.of((Ujo)this);
    }

    public boolean isTable() {
        return this.isPersistent() && !this.isView();
    }

    public boolean isCommented() {
        return !COMMENT.isDefault((Ujo)this);
    }

    public String getComment() {
        return (String)COMMENT.of((Ujo)this);
    }

    public boolean isSelectModel() {
        return SELECT_MODEL.of((Ujo)this) != null;
    }

    public void setNotPersistent() {
        DATABASE.setValue((Ujo)this, null);
    }

    @Override
    public String getAlias() {
        return (String)ALIAS.of((Ujo)this);
    }

    public final MetaDatabase getDatabase() {
        return (MetaDatabase)DATABASE.of((Ujo)this);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Nullable
    MetaColumn findColumn(String string) {
        if (Check.hasLength((CharSequence)string)) {
            for (MetaColumn metaColumn : COLUMNS.getList((Ujo)this)) {
                if (!MetaColumn.ID.equals((Ujo)metaColumn, (Object)string)) continue;
                return metaColumn;
            }
        }
        return null;
    }

    MetaRelation2Many findRelation(String string) {
        if (Check.hasLength((CharSequence)string)) {
            for (MetaRelation2Many metaRelation2Many : RELATIONS.getList((Ujo)this)) {
                if (!MetaRelation2Many.ID.equals((Ujo)metaRelation2Many, (Object)string)) continue;
                return metaRelation2Many;
            }
        }
        return null;
    }

    public List<MetaColumn> getForeignColumns() {
        ArrayList<MetaColumn> arrayList = new ArrayList<MetaColumn>();
        for (MetaColumn metaColumn : COLUMNS.getList((Ujo)this)) {
            if (!metaColumn.isForeignKey()) continue;
            arrayList.add(metaColumn);
        }
        return arrayList;
    }

    public UjoSequencer getSequencer() {
        return this.sequencer;
    }

    @NotNull
    public String getSchema() {
        return (String)SCHEMA.of((Ujo)this);
    }

    @NotNull
    public String getName() {
        return (String)NAME.of((Ujo)this);
    }

    public String getFullName() {
        String string = (String)SCHEMA.of((Ujo)this);
        return MsgFormatter.format((CharSequence)"{}.{}", (Object[])new String[]{string != null ? string : "public", this.getName()});
    }

    @NotNull
    public String toString() {
        return this.getFullName();
    }

    public Collection<MetaIndex> getIndexCollection() {
        MetaParams metaParams = this.getDatabase().getParams();
        try {
            return metaParams.getIndexModelBuilder(this).getIndexModels();
        }
        catch (Exception exception) {
            String string = MsgFormatter.format((CharSequence)"The {} with an entity {} fails, see the parameter {}", (Object[])new Serializable[]{metaParams.get(MetaParams.INDEX_MODEL_BUILDER), this.getType().getSimpleName(), MetaParams.INDEX_MODEL_BUILDER.getFullName()});
            throw new IllegalUjormException(string, (Throwable)exception);
        }
    }

    @Nullable
    public OrmUjo getParent(OrmUjo ormUjo) {
        MetaColumn metaColumn = this.getFirstPK();
        if (metaColumn.isForeignKey()) {
            return (OrmUjo)metaColumn.getValue(ormUjo);
        }
        return null;
    }

    public boolean isReadOnly() {
        return (Boolean)READ_ONLY.of((Ujo)this);
    }

    public void assertChangeAllowed() throws IllegalUjormException {
        if (this.isReadOnly()) {
            String string = MsgFormatter.format((CharSequence)"The table '{}' have got the READ-ONLY mode. Check the {} meta-model configuration.", (Object[])new String[]{(String)NAME.of((Ujo)this), "Ujorm"});
            throw new IllegalUjormException(string);
        }
    }

    public Orm2ddlPolicy getOrm2ddlPolicy() {
        return (Orm2ddlPolicy)((Object)ORM2DLL_POLICY.of((Ujo)this));
    }

    @Override
    public MetaTable getModel() {
        return this;
    }

    @Override
    public List<? extends ColumnWrapper> getColumns() {
        return COLUMNS.getList((Ujo)this);
    }

    public void clearReadOnly() {
        super.clearReadOnly(this.getDatabase().getOrmHandler());
    }

    public TableWrapper addAlias(String string) {
        return string != null ? new TableWrapperImpl(this, string) : this;
    }

    public boolean isQuoted() {
        switch ((QuoteEnum)((Object)QUOTED.of((Ujo)this))) {
            case YES: {
                return true;
            }
        }
        return false;
    }

    static {
        fa.lock();
    }
}

