/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.utility;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.jetbrains.annotations.NotNull;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.ExtendedOrmUjo;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;

public final class OrmTools {
    public static final SerialBlob createBlob(byte[] byArray) {
        try {
            return byArray != null ? new SerialBlob(byArray) : null;
        }
        catch (Exception exception) {
            throw new IllegalUjormException((Throwable)exception);
        }
    }

    public static SerialBlob createBlob(InputStream inputStream) {
        try {
            int n;
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            SerialBlob serialBlob = new SerialBlob(byteArrayOutputStream.toByteArray());
            return serialBlob;
        }
        catch (IOException | RuntimeException | SQLException exception) {
            throw new IllegalUjormException("Reding error", (Throwable)exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new IllegalUjormException("Reding error", (Throwable)iOException);
            }
        }
    }

    public static byte[] getBlobBytes(Blob blob) throws IllegalUjormException, IndexOutOfBoundsException {
        try {
            if (blob == null) {
                return null;
            }
            if (blob.length() <= Integer.MAX_VALUE) {
                return blob.getBytes(1L, (int)blob.length());
            }
        }
        catch (Exception exception) {
            throw new IllegalUjormException("Reding error", (Throwable)exception);
        }
        throw new IndexOutOfBoundsException("Length of the result is great than Integer.MAX_VALUE");
    }

    public static InputStream getBlobStream(Blob blob) throws IllegalUjormException {
        try {
            return blob.getBinaryStream();
        }
        catch (Exception exception) {
            throw new IllegalUjormException("Reding error", (Throwable)exception);
        }
    }

    public static final SerialClob createClob(char[] cArray) {
        try {
            return cArray != null ? new SerialClob(cArray) : null;
        }
        catch (Exception exception) {
            throw new IllegalUjormException((Throwable)exception);
        }
    }

    public static SerialClob createClob(String string) {
        return string != null ? OrmTools.createClob(string.toCharArray()) : null;
    }

    public static SerialClob createClob(Reader reader) {
        try {
            int n;
            char[] cArray = new char[1024];
            StringBuilder stringBuilder = new StringBuilder(cArray.length);
            while ((n = reader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
            SerialClob serialClob = new SerialClob(OrmTools.toCharArray(stringBuilder));
            return serialClob;
        }
        catch (IOException | RuntimeException | SQLException exception) {
            throw new IllegalUjormException("Reader error", (Throwable)exception);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new IllegalUjormException("Reader error", (Throwable)iOException);
            }
        }
    }

    public static char[] toCharArray(@NotNull StringBuilder stringBuilder) {
        char[] cArray = new char[stringBuilder.length()];
        stringBuilder.getChars(0, cArray.length, cArray, 0);
        return cArray;
    }

    public static String getClobString(Clob clob) throws IllegalUjormException, IndexOutOfBoundsException {
        try {
            if (clob == null) {
                return null;
            }
            if (clob.length() <= Integer.MAX_VALUE) {
                return clob.getSubString(1L, (int)clob.length());
            }
        }
        catch (Exception exception) {
            throw new IllegalUjormException("Reding error", (Throwable)exception);
        }
        throw new IndexOutOfBoundsException("Length of the result is great than Integer.MAX_VALUE");
    }

    public static char[] getClob(Clob clob) throws IllegalStateException, IndexOutOfBoundsException {
        return clob != null ? OrmTools.getClobString(clob).toCharArray() : null;
    }

    public static void loadLazyValues(OrmUjo ormUjo) {
        OrmTools.loadLazyValues(ormUjo, 1);
    }

    public static void loadLazyValues(OrmUjo ormUjo, int n) {
        if (--n < 0) {
            return;
        }
        for (Key key : ormUjo.readKeys()) {
            Object object;
            if (!key.isTypeOf(OrmUjo.class) || (object = key.of((Ujo)ormUjo)) == null || n <= 0) continue;
            OrmTools.loadLazyValues((OrmUjo)object, n);
        }
    }

    public static <U extends OrmUjo> List<U> loadLazyValues(Iterable<U> iterable, int n) {
        List<OrmUjo> list = iterable instanceof List ? null : new ArrayList(64);
        for (OrmUjo ormUjo : iterable) {
            OrmTools.loadLazyValues(ormUjo, n);
            if (list == null) continue;
            list.add(ormUjo);
        }
        if (list == null) {
            list = (List)iterable;
        }
        return list;
    }

    public boolean reload(OrmUjo ormUjo, Session session) {
        return session.reload(ormUjo);
    }

    public static <U extends ExtendedOrmUjo> List<U> loadLazyValuesAsBatch(Iterable<U> iterable, Key<U, ? extends OrmUjo> key) {
        Object object;
        Object object222;
        ArrayList<ExtendedOrmUjo> arrayList = new ArrayList<ExtendedOrmUjo>(iterable instanceof List ? ((List)iterable).size() : 128);
        HashMap<Object, OrmUjo> hashMap = new HashMap<Object, OrmUjo>(64);
        while (key.isComposite()) {
            key = ((CompositeKey)key).getKey(0);
        }
        for (Object object222 : iterable) {
            arrayList.add((ExtendedOrmUjo)object222);
            object = object222.readValue(key);
            if (!(object instanceof ForeignKey)) continue;
            hashMap.put(((ForeignKey)object).getValue(), null);
        }
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        Session session = ((ExtendedOrmUjo)arrayList.get(0)).readSession();
        object222 = (MetaColumn)session.getHandler().findColumnModel(key, true);
        object = ((MetaColumn)object222).getForeignColumns().get(0);
        Query<OrmUjo> query = session.createQuery(((MetaRelation2Many)((Object)object)).getTable().getType());
        int n = session.getParameters().get(MetaParams.MAX_ITEM_COUNT_4_IN);
        int n2 = hashMap.size();
        ArrayList arrayList2 = new ArrayList(Math.min(n, n2));
        Iterator iterator = hashMap.keySet().iterator();
        for (int i = 1; i <= n2; ++i) {
            arrayList2.add(iterator.next());
            if (i % n != 0 && i != n2) continue;
            query.setCriterion((Criterion<OrmUjo>)Criterion.whereIn((Key)((MetaRelation2Many)((Object)object)).getKey(), arrayList2));
            for (OrmUjo ormUjo : query) {
                hashMap.put(((MetaColumn)object).getValue(ormUjo), ormUjo);
            }
            arrayList2.clear();
        }
        for (ExtendedOrmUjo extendedOrmUjo : arrayList) {
            Object object2 = extendedOrmUjo.readValue(key);
            if (!(object2 instanceof ForeignKey)) continue;
            extendedOrmUjo.writeSession(null);
            extendedOrmUjo.writeValue(key, hashMap.get(((ForeignKey)object2).getValue()));
            extendedOrmUjo.writeSession(session);
        }
        return arrayList;
    }

    public static <U extends ExtendedOrmUjo> List<U> loadLazyValuesAsBatch(Query<U> query) {
        List<U> list = query.iterator().toList();
        List list2 = MetaTable.COLUMNS.getList((Ujo)query.getTableModel());
        for (MetaColumn metaColumn : list2) {
            if (!metaColumn.isForeignKey()) continue;
            OrmTools.loadLazyValuesAsBatch(list, metaColumn.getKey());
        }
        return list;
    }

    public static Criterion createCriterion(MetaTable metaTable, Criterion criterion, List<Object> list) {
        Criterion criterion2 = criterion;
        if (Check.hasLength(list)) {
            MetaPKey metaPKey = (MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable));
            Assert.isTrue((metaPKey.getCount() == 1 ? 1 : 0) != 0, (Object[])new String[]{"There are supported objects with a one primary keys only"});
            Criterion criterion3 = metaPKey.getFirstColumn().getKey().whereIn(list);
            criterion2 = criterion2 != null ? criterion2.or(criterion3) : criterion3;
        }
        return criterion2 != null ? criterion2 : metaTable.getFirstPK().getKey().forNone();
    }

    public static <U extends Ujo> U clone(U u) throws IllegalStateException {
        KeyList keyList = u.readKeys();
        Ujo ujo = keyList.newBaseUjo();
        for (Key key : keyList) {
            key.copy(u, ujo);
        }
        if (u instanceof OrmUjo) {
            ((OrmUjo)ujo).writeSession(((OrmUjo)u).readSession());
        }
        return (U)ujo;
    }
}

