/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.core;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.CompositeKey;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoIterator;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.metaModel.MetaColumn;

final class ResultSetIterator<T extends OrmUjo>
extends UjoIterator<T>
implements Closeable {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(ResultSetIterator.class);
    @NotNull
    private final Query query;
    @NotNull
    private final ColumnWrapper[] queryColumns;
    @Nullable
    private final ResultSet rs;
    @Nullable
    private PreparedStatement statement;
    private final boolean view;
    private long count = -1L;
    private boolean initState = true;
    private boolean cursorReady = false;
    private boolean hasNext = true;

    public ResultSetIterator(@NotNull Query query) throws IllegalUjormException {
        try {
            this.query = query;
            this.queryColumns = query.getColumnArray();
            this.statement = query.getStatement();
            this.rs = this.statement.executeQuery();
            this.view = query.getTableModel().isSelectModel();
        }
        catch (SQLException sQLException) {
            throw this.newException(sQLException);
        }
    }

    @NotNull
    private RuntimeException newException(@Nullable Throwable throwable) {
        this.close(false);
        boolean bl = throwable == null;
        String string = "Error for SQL: " + this.query;
        return bl ? new NoSuchElementException(string) : new IllegalUjormException(string, throwable);
    }

    @NotNull
    private RuntimeException newNoSuchElementException() {
        return this.newException(null);
    }

    @Override
    public boolean hasNext() throws IllegalUjormException {
        if (!this.cursorReady) {
            try {
                this.cursorReady = true;
                this.hasNext = this.rs.next();
                if (!this.hasNext) {
                    this.close();
                }
            }
            catch (SQLException sQLException) {
                throw this.newException(sQLException);
            }
        }
        return this.hasNext;
    }

    @Override
    public void close() throws IllegalUjormException {
        this.close(true);
    }

    private void close(boolean bl) throws IllegalUjormException {
        if (this.statement != null) {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException sQLException) {
                this.statement = null;
                if (bl) {
                    throw this.newException(sQLException);
                }
                LOGGER.log(UjoLogger.WARN, "", (Throwable)sQLException);
            }
        }
    }

    public boolean isClosed() {
        return this.statement == null;
    }

    @Override
    public T next() throws NoSuchElementException, IllegalUjormException {
        if (!this.hasNext()) {
            throw this.newNoSuchElementException();
        }
        try {
            this.cursorReady = false;
            OrmUjo ormUjo = this.query.getTableModel().createBO();
            int n = this.queryColumns.length;
            for (int i = 0; i < n; ++i) {
                ColumnWrapper columnWrapper = this.queryColumns[i];
                MetaColumn metaColumn = columnWrapper.getModel();
                int n2 = this.view ? this.rs.findColumn((String)MetaColumn.NAME.of((Ujo)metaColumn)) : i + 1;
                Object j = metaColumn.getConverter().getValue(metaColumn, this.rs, n2);
                if (columnWrapper.isCompositeKey()) {
                    Ujo ujo = ((CompositeKey)columnWrapper.getKey()).getSemiValue((Ujo)ormUjo, true);
                    metaColumn.setValueRaw(ujo, j);
                    continue;
                }
                metaColumn.setValueRaw(ormUjo, j);
            }
            ormUjo.writeSession(this.query.getSession());
            if (this.initState) {
                this.initState = false;
            }
            return (T)ormUjo;
        }
        catch (OutOfMemoryError | ReflectiveOperationException | RuntimeException | SQLException throwable) {
            throw this.newException(throwable);
        }
    }

    @Override
    public long count() {
        if (this.count < 0L) {
            this.count = !this.hasNext() && this.initState ? 0L : this.query.getCount();
        }
        return this.count;
    }

    @Override
    public boolean skip(int n) {
        while (n > 0 && this.hasNext()) {
            this.cursorReady = false;
            --n;
        }
        return n == 0;
    }
}

