/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.tools.msg.MsgFormatter;

public final class AliasKey {
    static final String DEFAULT_RELATION_ALIAS = "[RELATION ALIAS]";
    final Key<?, ?> key;
    final String aliasFrom;
    final String aliasTo;
    int hashCode;

    public AliasKey(Key<?, ?> key) {
        this(key, CompositeKey.DEFAULT_ALIAS, CompositeKey.DEFAULT_ALIAS);
    }

    public AliasKey(Key<?, ?> key, String string, String string2) {
        this.key = key;
        this.aliasFrom = string;
        this.aliasTo = string2;
    }

    public Key<?, ?> getKey() {
        return this.key;
    }

    public String getAliasFrom() {
        return this.aliasFrom;
    }

    public String getAliasTo() {
        return this.aliasTo;
    }

    public ColumnWrapper getColumn(OrmHandler ormHandler) {
        MetaColumn metaColumn = (MetaColumn)ormHandler.findColumnModel(this.key, true);
        return this.aliasFrom != null ? ColumnWrapper.forAlias(metaColumn, this.aliasFrom) : metaColumn;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 5;
            n = 79 * n + this.key.hashCode();
            n = 79 * n + (this.aliasFrom != null ? this.aliasFrom.hashCode() : 0);
            this.hashCode = n = 79 * n + (this.aliasTo != null ? this.aliasTo.hashCode() : 0);
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        AliasKey aliasKey = (AliasKey)object;
        if (this.key != aliasKey.key) {
            return false;
        }
        if (!Objects.equals(this.aliasFrom, aliasKey.aliasFrom)) {
            return false;
        }
        return Objects.equals(this.aliasTo, aliasKey.aliasTo);
    }

    public String toString() {
        String string = MsgFormatter.format((CharSequence)"{} ({}, {})", (Object[])new String[]{this.key.getFullName(), this.aliasFrom, this.aliasTo});
        return string;
    }

    public static void addRelations(Key<?, ?> key, Collection<AliasKey> collection) {
        if (key.isComposite()) {
            CompositeKey compositeKey = (CompositeKey)key;
            AliasKey.addConditions(compositeKey, 0, compositeKey.getKeyCount() - 1, collection);
        }
    }

    public static void addKeys(Key<?, ?> key, Collection<AliasKey> collection) {
        if (key.isComposite()) {
            CompositeKey compositeKey = (CompositeKey)key;
            AliasKey.addConditions(compositeKey, 0, compositeKey.getKeyCount(), collection);
        } else {
            collection.add(new AliasKey(key));
        }
    }

    public static void addLastKey(Key<?, ?> key, Collection<AliasKey> collection) {
        if (key.isComposite()) {
            CompositeKey compositeKey = (CompositeKey)key;
            int n = compositeKey.getKeyCount();
            AliasKey.addConditions(compositeKey, n - 1, n, collection);
        } else {
            collection.add(new AliasKey(key));
        }
    }

    public static AliasKey getLastKey(Key<?, ?> key) {
        ArrayList<AliasKey> arrayList = new ArrayList<AliasKey>(1);
        AliasKey.addLastKey(key, arrayList);
        return arrayList.isEmpty() ? null : arrayList.get(0);
    }

    private static void addConditions(CompositeKey<?, ?> compositeKey, int n, int n2, Collection<AliasKey> collection) {
        String string = n > 0 ? compositeKey.getAlias(n - 1) : CompositeKey.DEFAULT_ALIAS;
        for (int i = n; i < n2; ++i) {
            String string2 = compositeKey.getAlias(i);
            Key key = compositeKey.getDirectKey(i);
            collection.add(new AliasKey(key, string, string2));
            string = string2;
        }
    }
}

