/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import org.jetbrains.annotations.NotNull;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.orm.SqlDialect;

public class H2Dialect
extends SqlDialect {
    @Override
    public String getJdbcUrl() {
        return "jdbc:h2:mem:db1;DB_CLOSE_DELAY=-1";
    }

    @Override
    public String getJdbcDriver() {
        return "org.h2.Driver";
    }

    @Override
    @NotNull
    public String getCriterionTemplate(@NotNull ValueCriterion valueCriterion) {
        switch (valueCriterion.getOperator()) {
            case STARTS_CASE_INSENSITIVE: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "{0} ILIKE {1}";
            }
        }
        return super.getCriterionTemplate(valueCriterion);
    }
}

