/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.ujorm.Ujo;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.DbType;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.dialect.PostgreSqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaTable;

public class OracleDialect
extends PostgreSqlDialect {
    @Override
    public String getJdbcUrl() {
        return "jdbc:oracle:thin:@myhost:1521:orcl";
    }

    @Override
    public String getJdbcDriver() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public Appendable printCreateSchema(String string, Appendable appendable) throws IOException {
        return appendable;
    }

    @Override
    protected Appendable printSelectTable(Query query, boolean bl, Appendable appendable) throws IOException {
        if (!bl && (query.isOffset() || query.isLimit())) {
            appendable.append("SELECT * FROM (SELECT ujorm__.*, ROWNUM AS ujorm_rownum FROM (\n");
            super.printSelectTable(query, bl, appendable);
            appendable.append("\n) ujorm__) WHERE ujorm_rownum > " + query.getOffset());
            if (query.isLimit()) {
                long l = query.getOffset() + (long)query.getLimit();
                appendable.append(" AND ujorm_rownum <= " + l);
            }
        } else {
            super.printSelectTable(query, bl, appendable);
        }
        return appendable;
    }

    @Override
    public void printLimitAndOffset(Query query, Appendable appendable) throws IOException {
    }

    @Override
    protected String getColumnType(MetaColumn metaColumn) {
        if (MetaColumn.DB_TYPE.of((Ujo)metaColumn) == DbType.BIGINT) {
            return "NUMBER";
        }
        return ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))).name();
    }

    @Override
    public Appendable printAlterTableAddColumn(MetaColumn metaColumn, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaColumn.getTable(), appendable);
        appendable.append(" ADD (");
        if (metaColumn.isForeignKey()) {
            this.printFKColumnsDeclaration(metaColumn, appendable);
        } else {
            this.printColumnDeclaration_2(metaColumn, null, appendable);
        }
        appendable.append(" )");
        return appendable;
    }

    public Appendable printColumnDeclaration_2(MetaColumn metaColumn, String string, Appendable appendable) throws IOException {
        this.printColumnName(string != null ? ColumnWrapper.forName(metaColumn, string) : metaColumn, appendable);
        appendable.append(' ');
        appendable.append(this.getColumnType(metaColumn));
        if (!MetaColumn.MAX_LENGTH.isDefault((Ujo)metaColumn)) {
            appendable.append("(" + MetaColumn.MAX_LENGTH.of((Ujo)metaColumn));
            if (!MetaColumn.PRECISION.isDefault((Ujo)metaColumn)) {
                appendable.append("," + MetaColumn.PRECISION.of((Ujo)metaColumn));
            }
            appendable.append(")");
        }
        if (metaColumn.hasDefaultValue()) {
            this.printDefaultValue(metaColumn, appendable);
        }
        if (((Boolean)MetaColumn.MANDATORY.of((Ujo)metaColumn)).booleanValue() && string == null) {
            appendable.append(" NOT NULL");
        }
        if (((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)metaColumn)).booleanValue() && string == null) {
            appendable.append(" PRIMARY KEY");
        }
        return appendable;
    }

    @Override
    public Appendable printIndexCondition(MetaIndex metaIndex, Appendable appendable) throws IOException {
        return appendable;
    }

    @Override
    public Appendable printInsert(List<? extends OrmUjo> list, int n, int n2, Appendable appendable) throws IOException {
        return this.printInsertBySelect(list, n, n2, "FROM DUAL", appendable);
    }

    @Override
    public Appendable printNextSequence(String string, MetaTable metaTable, Appendable appendable) throws IOException {
        appendable.append("SELECT ");
        appendable.append(string);
        appendable.append(".NEXTVAL FROM DUAL");
        return appendable;
    }

    @Override
    @NotNull
    public String getCriterionTemplate(@NotNull ValueCriterion valueCriterion) {
        switch (valueCriterion.getOperator()) {
            case STARTS_CASE_INSENSITIVE: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "LOWER({0}) LIKE {1}";
            }
        }
        return super.getCriterionTemplate(valueCriterion);
    }
}

