/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.ao.CommentPolicy;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.metaModel.DbItems;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;

@Unmodifiable
public class MetaDbService {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(MetaDbService.class);
    private static final Level INFO = UjoLogger.INFO;
    private static final boolean DEBUG_MODE = false;
    protected MetaDatabase db;
    protected final StringBuilder sql = new StringBuilder(256);
    protected Statement stat = null;
    protected boolean anyChange = false;

    public void create(MetaDatabase metaDatabase, Session session) {
        this.db = metaDatabase;
        Connection connection = session.getConnection(this.db, true);
        int[] nArray = this.db.getDbItemCount();
        int n = nArray[0];
        int n2 = nArray[1];
        DbItems dbItems = new DbItems(n, n2);
        try {
            boolean bl = this.initialize(connection);
            boolean bl2 = false;
            switch ((Orm2ddlPolicy)((Object)MetaDatabase.ORM2DLL_POLICY.of((Ujo)this.db))) {
                case CREATE_DDL: {
                    bl2 = true;
                }
                case CREATE_OR_UPDATE_DDL: 
                case VALIDATE: 
                case WARNING: 
                case INHERITED: {
                    boolean bl3 = this.isModelChanged(connection, dbItems);
                    if (!bl3 || !bl2 || dbItems.getTables().size() >= n) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.checkReportKeywords(connection, dbItems);
            this.createSchema(dbItems.getSchemas(), connection);
            this.createTable(dbItems);
            this.createNewColumn(dbItems);
            this.changeIndex(dbItems.getIndexes());
            this.createForeignKey(dbItems.getForeignColumns());
            this.createSequenceTable(bl);
            this.createTableComments(dbItems.getTables());
            this.sql.setLength(0);
            if (bl) {
                this.db.getParams().getFixingTableSequences(this.db, connection).run();
            }
            connection.commit();
        }
        catch (IOException | OutOfMemoryError | RuntimeException | SQLException throwable) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                LOGGER.log(UjoLogger.WARN, "Can't rollback DB {}", new Object[]{this.db.getId(), sQLException});
            }
            String string = "ILLEGAL SQL: " + this.getSql();
            LOGGER.log(Level.SEVERE, string, throwable);
            throw new IllegalUjormException(string, throwable);
        }
    }

    public StringBuilder getSql() {
        return this.sql;
    }

    protected boolean isModelChanged(Connection connection, DbItems dbItems) throws SQLException {
        Object object;
        Object object22;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        Boolean bl = this.db.getDialect().isCatalog();
        for (Object object22 : MetaDatabase.TABLES.getList((Ujo)this.db)) {
            if (!((MetaTable)object22).isTable()) continue;
            this.addNewColumns(databaseMetaData, (MetaTable)object22, dbItems.getTables(), dbItems.getColumns());
            this.addNewIndexes(databaseMetaData, (MetaTable)object22, dbItems.getIndexes());
            switch (((MetaTable)object22).getOrm2ddlPolicy()) {
                case CREATE_DDL: 
                case CREATE_OR_UPDATE_DDL: {
                    object = this.toUpperCase(((MetaTable)object22).getSchema());
                    if (hashMap.containsKey(object)) break;
                    hashMap.put(object, ((MetaTable)object22).getSchema());
                }
            }
        }
        ResultSet resultSet = databaseMetaData.getSchemas();
        object22 = null;
        try {
            object = UjoLogger.TRACE;
            while (resultSet.next()) {
                String string = resultSet.getString(bl != false ? 2 : 1);
                String string2 = this.toUpperCase(string);
                if (LOGGER.isLoggable((Level)object)) {
                    LOGGER.log((Level)object, "DB schema: {}.{} by catalog: {}", new Object[]{resultSet.getString(2), resultSet.getString(1), bl});
                }
                if (string2 == null || !hashMap.containsKey(string2)) continue;
                LOGGER.log((Level)object, "The db schema '{}' already exists", (Object)string);
                hashMap.remove(string2);
            }
        }
        catch (Throwable throwable) {
            object22 = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (object22 != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object22).addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        dbItems.getSchemas().addAll(hashMap.values());
        boolean bl2 = !dbItems.getTables().isEmpty() || !dbItems.getColumns().isEmpty() || !dbItems.getIndexes().isEmpty();
        return bl2;
    }

    @Nullable
    private String toUpperCase(@Nullable String string) {
        return string != null ? string.toUpperCase(Locale.ENGLISH) : string;
    }

    private void logColumn(ResultSet resultSet) throws SQLException {
        LOGGER.log(INFO, "DB column: {}.{}.{}.{}", new Object[]{resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_NAME"), resultSet.getString("COLUMN_NAME")});
    }

    protected String dbIdentifier(String string, DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData.storesUpperCaseIdentifiers()) {
            return string.toUpperCase();
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            return string.toLowerCase();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initialize(Connection connection) throws SQLException, IOException, IllegalUjormException {
        this.stat = connection.createStatement();
        boolean bl = false;
        if (this.db.isSequenceTableRequired()) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            SQLException sQLException = null;
            String string = "";
            try {
                UjoSequencer ujoSequencer = (UjoSequencer)Assert.notNull((Object)this.findFirstSequencer(), (Object[])new String[]{"sequencer"});
                this.db.getDialect().printSequenceCurrentValue(ujoSequencer, this.sql);
                preparedStatement = connection.prepareStatement(this.sql.toString());
                preparedStatement.setString(1, "-");
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            if (sQLException != null) {
                switch ((Orm2ddlPolicy)((Object)MetaDatabase.ORM2DLL_POLICY.of((Ujo)this.db))) {
                    case VALIDATE: 
                    case WARNING: {
                        throw new IllegalUjormException(string, (Throwable)sQLException);
                    }
                    case CREATE_DDL: 
                    case CREATE_OR_UPDATE_DDL: 
                    case INHERITED: {
                        bl = true;
                    }
                }
            }
            if (LOGGER.isLoggable(INFO)) {
                LOGGER.log(INFO, "Table '{}' {} available on the database '{}'.", new Object[]{this.db.getDialect().getSeqTableModel().getTableName(), sQLException != null ? "is not" : "is", this.db.getId()});
            }
            try {
                if (sQLException != null) {
                    connection.rollback();
                }
            }
            finally {
                MetaDatabase.close(null, preparedStatement, resultSet, false);
            }
        }
        return bl;
    }

    protected void checkReportKeywords(Connection connection, DbItems dbItems) throws SQLException {
        switch (this.db.getParams().get(MetaParams.QUOTATION_POLICY)) {
            case QUOTE_ONLY_SQL_KEYWORDS: {
                this.db.getParams().set(MetaParams.KEYWORD_SET, this.db.getDialect().getKeywordSet(connection));
                break;
            }
            case WARNING: 
            case EXCEPTION: {
                Set<String> set = this.db.getDialect().getKeywordSet(connection);
                for (MetaTable abstractMetaModel : dbItems.getTables()) {
                    if (!abstractMetaModel.isTable()) continue;
                    if (!abstractMetaModel.isQuoted()) {
                        this.checkKeyWord((String)MetaTable.NAME.of((Ujo)abstractMetaModel), abstractMetaModel, set);
                    }
                    for (MetaColumn metaColumn : MetaTable.COLUMNS.getList((Ujo)abstractMetaModel)) {
                        if (metaColumn.isQuoted()) continue;
                        this.checkKeyWord(metaColumn.getName(), abstractMetaModel, set);
                    }
                }
                for (MetaColumn metaColumn : dbItems.getColumns()) {
                    if (metaColumn.isQuoted()) continue;
                    this.checkKeyWord((String)MetaColumn.NAME.of((Ujo)metaColumn), metaColumn.getTable(), set);
                }
                for (MetaIndex metaIndex : dbItems.getIndexes()) {
                    this.checkKeyWord((String)MetaIndex.NAME.of((Ujo)metaIndex), (MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex), set);
                }
                break;
            }
        }
    }

    protected void createSchema(List<String> list, Connection connection) throws SQLException, IOException {
        for (String string : list) {
            this.sql.setLength(0);
            this.db.getDialect().printCreateSchema(string, this.sql);
            if (!Check.hasLength((CharSequence)this.sql)) continue;
            try {
                this.stat.executeUpdate(this.sql.toString());
            }
            catch (SQLException sQLException) {
                LOGGER.log(INFO, "{}: {}; {}", new Object[]{sQLException.getClass().getName(), this.sql.toString(), sQLException.getMessage()});
                connection.rollback();
            }
        }
    }

    protected void createTable(DbItems dbItems) throws IOException, SQLException {
        for (MetaTable metaTable : dbItems.getTables()) {
            if (!metaTable.isTable()) continue;
            this.sql.setLength(0);
            this.db.getDialect().printTable(metaTable, this.sql);
            this.executeUpdate(this.sql, metaTable);
            dbItems.getForeignColumns().addAll(metaTable.getForeignColumns());
            this.anyChange = true;
        }
    }

    protected void createNewColumn(DbItems dbItems) throws IOException, SQLException {
        for (MetaColumn metaColumn : dbItems.getColumns()) {
            this.sql.setLength(0);
            this.db.getDialect().printAlterTableAddColumn(metaColumn, this.sql);
            this.executeUpdate(this.sql, metaColumn.getTable());
            this.anyChange = true;
            if (!metaColumn.isForeignKey()) continue;
            dbItems.getForeignColumns().add(metaColumn);
        }
    }

    protected void changeIndex(List<MetaIndex> list) throws SQLException, IOException {
        for (MetaIndex metaIndex : list) {
            this.sql.setLength(0);
            this.db.getDialect().printIndex(metaIndex, this.sql);
            this.executeUpdate(this.sql, (MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex));
            this.anyChange = true;
        }
    }

    protected void createForeignKey(List<MetaColumn> list) throws IOException, SQLException {
        for (MetaColumn metaColumn : list) {
            if (!metaColumn.isForeignKey()) continue;
            this.sql.setLength(0);
            this.db.getDialect().printForeignKey(metaColumn, this.sql);
            this.executeUpdate(this.sql, metaColumn.getTable());
            this.anyChange = true;
        }
    }

    protected void createSequenceTable(boolean bl) throws SQLException, IOException {
        if (bl) {
            this.sql.setLength(0);
            this.db.getDialect().printSequenceTable(this.db, this.sql);
            MetaTable metaTable = new MetaTable();
            MetaTable.ORM2DLL_POLICY.setValue((Ujo)metaTable, MetaParams.ORM2DLL_POLICY.getDefault());
            this.executeUpdate(this.sql, metaTable);
            this.sql.setLength(0);
            MetaTable.NAME.setValue((Ujo)metaTable, (Object)this.db.getDialect().getSeqTableModel().getTableName());
            MetaTable.SCHEMA.setValue((Ujo)metaTable, MetaDatabase.SCHEMA.of((Ujo)this.db));
            MetaTable.COMMENT.setValue((Ujo)metaTable, (Object)this.db.getDialect().getSeqTableModel().getTableComment());
            this.db.getDialect().printComment(metaTable, (Appendable)this.sql);
            this.executeUpdate(this.sql, metaTable);
        }
    }

    protected void createTableComments(List<MetaTable> list) throws IllegalUjormException {
        List<MetaTable> list2;
        CommentPolicy commentPolicy = (CommentPolicy)((Object)MetaParams.COMMENT_POLICY.of((Ujo)this.db.getParams()));
        switch (commentPolicy) {
            case FOR_NEW_OBJECT: {
                list2 = list;
                break;
            }
            case ALWAYS: {
                list2 = MetaDatabase.TABLES.getList((Ujo)this.db);
                break;
            }
            case ON_ANY_CHANGE: {
                list2 = this.isAnyChange() ? MetaDatabase.TABLES.getList((Ujo)this.db) : Collections.emptyList();
                break;
            }
            case NEVER: {
                list2 = Collections.emptyList();
                break;
            }
            default: {
                throw new IllegalUjormException("Unsupported parameter: " + (Object)((Object)commentPolicy));
            }
        }
        if (!list2.isEmpty()) {
            this.createTableComments(list2, this.sql);
        }
    }

    protected void createTableComments(List<MetaTable> list, StringBuilder stringBuilder) {
        try {
            for (MetaTable metaTable : list) {
                switch ((Orm2ddlPolicy)((Object)MetaTable.ORM2DLL_POLICY.of((Ujo)metaTable))) {
                    case CREATE_DDL: 
                    case CREATE_OR_UPDATE_DDL: {
                        if (!metaTable.isTable()) break;
                        if (metaTable.isCommented()) {
                            stringBuilder.setLength(0);
                            Appendable appendable = this.db.getDialect().printComment(metaTable, (Appendable)stringBuilder);
                            this.executeUpdate(appendable, metaTable);
                        }
                        for (MetaColumn metaColumn : MetaTable.COLUMNS.getList((Ujo)metaTable)) {
                            if (!metaColumn.isCommented()) continue;
                            stringBuilder.setLength(0);
                            Appendable appendable = this.db.getDialect().printComment(metaColumn, (Appendable)stringBuilder);
                            this.executeUpdate(appendable, metaTable);
                        }
                        break;
                    }
                }
            }
        }
        catch (IOException | RuntimeException | SQLException exception) {
            LOGGER.log(UjoLogger.ERROR, "Error on table comment: {}", (Object)stringBuilder);
        }
    }

    protected void checkKeyWord(String string, MetaTable metaTable, Set<String> set) throws IllegalUjormException {
        if (set.contains(string.toUpperCase())) {
            String string2 = MsgFormatter.format((CharSequence)"The database table or column called '{}' is a SQL keyword of table '{}'.\nNOTE: the keyword checking can be disabled by the Ujorm parameter: {}", (Object[])new Serializable[]{string, metaTable.getType(), MetaParams.QUOTATION_POLICY.getFullName()});
            switch (this.db.getParams().get(MetaParams.QUOTATION_POLICY)) {
                case EXCEPTION: {
                    throw new IllegalUjormException(string2);
                }
                case WARNING: {
                    LOGGER.log(UjoLogger.WARN, string2);
                }
            }
        }
    }

    protected void executeUpdate(@NotNull Appendable appendable, @NotNull MetaTable metaTable) throws IllegalUjormException, SQLException {
        String string = appendable.toString();
        if (string.isEmpty()) {
            LOGGER.log(Level.FINEST, "Empty SQL statement");
            return;
        }
        boolean bl = false;
        switch (metaTable.getOrm2ddlPolicy()) {
            case INHERITED: {
                throw new IllegalUjormException("An internal error due the DDL policy: " + (Object)((Object)metaTable.getOrm2ddlPolicy()));
            }
            case DO_NOTHING: {
                return;
            }
            case VALIDATE: {
                bl = true;
            }
            case WARNING: {
                String string2 = "A database validation (caused by the parameter " + MetaTable.ORM2DLL_POLICY + ") have found an inconsistency. There is required a database change: " + string;
                if (bl) {
                    throw new IllegalUjormException(string2);
                }
                LOGGER.log(UjoLogger.WARN, string2);
            }
        }
        this.stat.executeUpdate(string);
        LOGGER.log(INFO, string);
    }

    @Nullable
    protected UjoSequencer findFirstSequencer() {
        for (MetaTable metaTable : MetaDatabase.TABLES.getList((Ujo)this.db)) {
            if (!metaTable.isTable()) continue;
            return metaTable.getSequencer();
        }
        return null;
    }

    protected boolean isAnyChange() {
        return this.anyChange;
    }

    protected SqlDialect getDialect() {
        return this.db.getDialect();
    }

    protected final boolean isCatalog() {
        return this.getDialect().isCatalog();
    }

    private boolean addNewColumns(DatabaseMetaData databaseMetaData, MetaTable metaTable, List<MetaTable> list, List<MetaColumn> list2) throws SQLException {
        boolean bl;
        boolean bl2 = this.isCatalog();
        HashSet<String> hashSet = new HashSet<String>(32);
        String string = this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)metaTable), databaseMetaData);
        ResultSet resultSet = databaseMetaData.getColumns(bl2 ? string : null, bl2 ? null : string, this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData), null);
        Object object = null;
        try {
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("COLUMN_NAME").toUpperCase());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (object != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        boolean bl3 = bl = hashSet.size() > 0;
        if (bl) {
            for (MetaColumn metaColumn : MetaTable.COLUMNS.getList((Ujo)metaTable)) {
                boolean bl4 = hashSet.contains(metaColumn.getName().toUpperCase());
                if (bl4) continue;
                LOGGER.log(INFO, "New DB column: {}", (Object)metaColumn.getFullName());
                list2.add(metaColumn);
            }
        } else {
            LOGGER.log(INFO, "New DB table: {}", (Object)metaTable);
            list.add(metaTable);
        }
        return bl;
    }

    protected void addNewIndexes(DatabaseMetaData databaseMetaData, MetaTable metaTable, List<MetaIndex> list) throws SQLException {
        boolean bl = this.isCatalog();
        String string = this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)metaTable), databaseMetaData);
        HashSet<String> hashSet = new HashSet<String>();
        Throwable object2 = null;
        try (ResultSet resultSet = databaseMetaData.getIndexInfo(bl ? string : null, bl ? null : string, this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData), false, false);){
            while (resultSet.next()) {
                String bl2 = resultSet.getString("INDEX_NAME");
                if (bl2 == null) continue;
                hashSet.add(bl2.toUpperCase());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        for (MetaIndex metaIndex : metaTable.getIndexCollection()) {
            boolean bl2 = hashSet.contains(((String)MetaIndex.NAME.of((Ujo)metaIndex)).toUpperCase());
            if (bl2) continue;
            LOGGER.log(INFO, "New DB index: {}", (Object)metaIndex);
            list.add(metaIndex);
        }
    }
}

