/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.UjoManager;
import org.ujorm.core.UjoManagerXML;
import org.ujorm.core.XmlHeader;
import org.ujorm.extensions.UjoTextable;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.tools.Check;

@Unmodifiable
public final class MetaRoot
extends AbstractMetaModel {
    private static final Class<MetaRoot> CLASS = MetaRoot.class;
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(CLASS);
    private static final String XSD_SOURCE = "https://pponec.github.io/ujorm/xsd/ujorm-1.91.xsd";
    private static final KeyFactory<MetaRoot> fa = KeyFactory.CamelBuilder.get(CLASS);
    public static final ListKey<MetaRoot, MetaDatabase> DATABASES = fa.newListKey("database");
    public static final Key<MetaRoot, MetaParams> PARAMETERS = fa.newKey("parameters");

    public MetaRoot() {
        PARAMETERS.setValue((Ujo)this, (Object)new MetaParams());
    }

    public MetaDatabase getDatabase() {
        MetaDatabase metaDatabase = DATABASES.getItemCount((Ujo)this) > 0 ? (MetaDatabase)DATABASES.getItem((Ujo)this, 0) : null;
        return metaDatabase;
    }

    @Nullable
    public MetaDatabase getDatabase(String string) {
        for (MetaDatabase metaDatabase : DATABASES.getList((Ujo)this)) {
            if (string != null && !MetaDatabase.SCHEMA.equals((Ujo)metaDatabase, (Object)string)) continue;
            return metaDatabase;
        }
        return null;
    }

    public int getDatabaseCount() {
        return DATABASES.getItemCount((Ujo)this);
    }

    public void add(MetaDatabase metaDatabase) {
        DATABASES.addItem((Ujo)this, (Object)metaDatabase);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        try {
            this.print(stringBuilder);
            stringBuilder.append("\n---\n");
        }
        catch (IOException iOException) {
            LOGGER.log(UjoLogger.ERROR, "Can't export model into XML", (Throwable)iOException);
        }
        return stringBuilder.toString();
    }

    private XmlHeader getXmlHeader() {
        XmlHeader xmlHeader = new XmlHeader();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.ENGLISH);
        String string = "The Ujorm configuration file release " + UjoManager.version() + " was created " + simpleDateFormat.format(new Date());
        xmlHeader.setComment(string);
        xmlHeader.getAttributes().put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlHeader.getAttributes().put("xsi:noNamespaceSchemaLocation", XSD_SOURCE);
        return xmlHeader;
    }

    public void print(Appendable appendable) throws IOException {
        UjoManagerXML.getInstance().saveXML(appendable, (UjoTextable)this, this.getXmlHeader(), ((Object)((Object)this)).getClass());
    }

    public void print(File file) throws IOException {
        UjoManagerXML.getInstance().saveXML(file, (UjoTextable)this, this.getXmlHeader(), ((Object)((Object)this)).getClass());
    }

    @Nullable
    public MetaDatabase removeDb(String string) {
        if (super.readOnly()) {
            throw new UnsupportedOperationException("The internal state is 'read only'");
        }
        if (Check.hasLength((CharSequence)string)) {
            for (MetaDatabase metaDatabase : DATABASES.getList((Ujo)this)) {
                if (!MetaDatabase.ID.equals((Ujo)metaDatabase, (Object)string)) continue;
                DATABASES.getList((Ujo)this).remove(metaDatabase);
                return metaDatabase;
            }
        }
        return null;
    }

    static {
        fa.lock();
    }
}

