/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.MessageArg;

public class MessageService {
    public static final String PARAM_BEG = "${";
    public static final char PARAM_END = '}';

    public Map<String, Object> map(Object ... args) {
        int max = args.length >> 1;
        HashMap<String, Object> result = new HashMap<String, Object>(max + 3);
        for (int j = 0; j < max; ++j) {
            int i = j << 1;
            result.put(args[i].toString(), this.convertValue(args[i + 1]));
        }
        return result;
    }

    public String template(Object ... args) {
        StringBuilder result = new StringBuilder(256);
        for (Object arg : args) {
            if (arg instanceof MessageArg) {
                result.append(PARAM_BEG).append(arg).append('}');
                continue;
            }
            result.append(arg);
        }
        return result.toString();
    }

    public final String format(@Nullable String msg, @Nullable Map<String, Object> args) {
        return this.format(msg, args, null);
    }

    public final String format(@Nullable String msg, @Nullable Map<String, Object> args, @Nullable Locale locale) {
        int i;
        if (msg == null || args == null) {
            return String.valueOf(msg);
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        StringBuffer result = new StringBuffer(255);
        int last = 0;
        while ((i = msg.indexOf(PARAM_BEG, last)) >= 0) {
            String expr;
            int end = msg.indexOf(125, i);
            int formatIndex = (expr = msg.substring(i + PARAM_BEG.length(), end)).indexOf(44);
            String key = expr.substring(0, formatIndex >= 0 ? formatIndex : expr.length());
            Object value = args.get(key);
            if (value != null) {
                result.append(msg, last, i);
                Object niceValue = formatIndex > 0 ? new Formatter(locale).format(expr.substring(1 + formatIndex), value, value, value, value, value, value) : value;
                this.appendValue(niceValue.toString(), result);
            } else {
                result.append(msg, last, end + 1);
            }
            last = end + 1;
        }
        result.append(msg, last, msg.length());
        return result.toString();
    }

    @Nullable
    protected Object convertValue(@Nullable Object value) {
        return value;
    }

    protected void appendValue(@Nullable String value, @Nonnull StringBuffer result) {
        result.append(value);
    }
}

