/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Check;

public abstract class MsgFormatter {
    protected static final String MARK = "{}";
    protected static final String SEPARATOR = ", ";

    private MsgFormatter() {
    }

    @Nonnull
    public static String format(@Nullable String messageTemplate, Object ... arguments) {
        String template;
        String string = template = messageTemplate != null ? messageTemplate : String.valueOf(messageTemplate);
        if (!Check.hasLength(arguments)) {
            return template;
        }
        int max = template.length();
        StringBuilder result = new StringBuilder(Math.max(32, max + (max >> 1)));
        int last = 0;
        for (Object arg : arguments) {
            int i = template.indexOf(MARK, last);
            if (i >= last) {
                result.append(template, last, i);
                last = i + MARK.length();
            } else {
                if (last < max) {
                    result.append(template, last, max);
                    last = max;
                }
                result.append(SEPARATOR);
            }
            result.append(arg);
        }
        if (last < max) {
            result.append(template, last, max);
        }
        return result.toString();
    }

    @Nullable
    public static String format(Object ... templateAndArguments) {
        if (Check.hasLength(templateAndArguments)) {
            String template = String.valueOf(templateAndArguments[0]);
            Object[] params = new Object[templateAndArguments.length - 1];
            System.arraycopy(templateAndArguments, 1, params, 0, params.length);
            return MsgFormatter.format(template, params);
        }
        return null;
    }
}

