/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import java.io.CharArrayWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.ujorm.tools.MsgFormatter;

@Immutable
public class ValueFormatter
extends MsgFormatter {
    private static final char THREE_DOTS = '\u2026';
    private final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final String valueBorder;

    protected ValueFormatter() {
        this.valueBorder = "";
    }

    protected ValueFormatter(@Nonnull String mark, @Nonnull String textBorder) {
        super(mark);
        this.valueBorder = textBorder;
    }

    @Override
    protected void writeValue(@Nullable Object value, @Nonnull CharArrayWriter out, boolean marked) {
        if (!marked) {
            out.append(", ");
        }
        if (value == null) {
            out.append(null);
        } else if (value instanceof CharSequence) {
            out.append(this.valueBorder);
            this.writeLongValue((CharSequence)value, out);
            out.append(this.valueBorder);
        } else if (value instanceof Number) {
            out.append(String.valueOf(value));
        } else if (value instanceof Date) {
            out.append(this.valueBorder);
            String format = value instanceof java.sql.Date ? "yyyy-MM-dd" : "yyyy-MM-dd'T'HH:mm:ss.SSS";
            out.append(new SimpleDateFormat(format, Locale.ENGLISH).format((Date)value));
            out.append(this.valueBorder);
        } else if (value instanceof byte[]) {
            out.append(this.valueBorder);
            this.writeByteArray((byte[])value, out);
            out.append(this.valueBorder);
        } else if (value instanceof Character) {
            out.append(this.valueBorder);
            out.append(((Character)value).charValue());
            out.append(this.valueBorder);
            out.append(((Throwable)value).getMessage());
        } else if (value instanceof Enum) {
            out.append(((Enum)value).name());
        } else if (value instanceof Throwable) {
            out.append(value.getClass().getSimpleName());
            out.append(':');
            out.append(((Throwable)value).getMessage());
        } else {
            this.writeLongValue(String.valueOf(value), out);
        }
    }

    protected void writeByteArray(@Nonnull byte[] bytes, @Nonnull CharArrayWriter out) {
        int v;
        int i;
        int length = bytes != null ? bytes.length : -1;
        int limit = this.getSizeLimit() >> 1;
        int half = limit - 4 >> 1;
        int max = length > limit ? half : length;
        for (i = 0; i < max; ++i) {
            v = bytes[i] & 0xFF;
            out.append(this.HEX_ARRAY[v >>> 4]);
            out.append(this.HEX_ARRAY[v & 0xF]);
        }
        if (length > limit) {
            out.append('\u2026');
            out.append(String.valueOf(length));
            out.append('\u2026');
            for (i = length - half; i < length; ++i) {
                v = bytes[i] & 0xFF;
                out.append(this.HEX_ARRAY[v >>> 4]);
                out.append(this.HEX_ARRAY[v & 0xF]);
            }
        }
    }

    protected void writeLongValue(@Nonnull CharSequence value, @Nonnull CharArrayWriter out) {
        int length = value != null ? value.length() : -1;
        int limit = this.getSizeLimit();
        int half = limit - 4 >> 1;
        if (length > limit) {
            out.append(value, 0, half);
            out.append('\u2026');
            out.append(String.valueOf(length));
            out.append('\u2026');
            out.append(value, length - half, length);
        } else {
            out.append(value);
        }
    }

    protected int getSizeLimit() {
        return 32;
    }

    @Nonnull
    public static String format(@Nullable String messageTemplate, Object ... arguments) {
        return new ValueFormatter().formatMsg(messageTemplate, arguments);
    }

    @Nonnull
    public static String formatSql(@Nullable String sqlTemplate, Object ... arguments) {
        return new ValueFormatter("?", "'").formatMsg(sqlTemplate, arguments);
    }
}

