/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.MsgFormatter;

public abstract class Assert {
    public static final Object[] NO_MESSAGE = null;

    private Assert() {
    }

    public static final void validState(boolean condition, Object ... message) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static final void isTrue(boolean condition) throws IllegalArgumentException {
        Assert.isTrue(condition, NO_MESSAGE);
    }

    public static final void isTrue(boolean condition, Object ... message) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static <T> void isTrue(@Nullable T condition, @Nonnull Predicate<T> predicate, Object ... message) {
        if (condition == null || !predicate.test(condition)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void isTrueNullable(@Nullable T value, @Nonnull Predicate<T> predicate, Object ... message) {
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static final void notNull(@Nullable Object value) throws IllegalArgumentException {
        Assert.notNull(value, NO_MESSAGE);
    }

    public static void notNull(@Nullable Object value, Object ... message) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static void hasLength(@Nullable byte[] array, Object ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void hasLength(@Nullable char[] array, Object ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void hasLength(@Nullable Object[] values, Object ... message) throws IllegalArgumentException {
        if (!Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void hasLength(@Nullable Collection<?> values, Object ... message) throws IllegalArgumentException {
        if (!Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void hasLength(@Nullable Map<?, ?> values, Object ... message) throws IllegalArgumentException {
        if (!Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void hasLength(@Nullable CharSequence value, Object ... message) throws IllegalArgumentException {
        if (!Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static final void isFalse(boolean condition) throws IllegalArgumentException {
        Assert.isFalse(condition, NO_MESSAGE);
    }

    public static final void isFalse(boolean condition, Object ... message) throws IllegalArgumentException {
        if (condition) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static <T> void isFalse(@Nullable T value, @Nonnull Predicate<T> predicate, Object ... message) {
        if (value == null || predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void isFalseNullable(@Nullable T value, @Nonnull Predicate<T> predicate, Object ... message) {
        if (predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static final void isNull(@Nullable Object value) throws IllegalArgumentException {
        Assert.isNull(value, NO_MESSAGE);
    }

    public static void isNull(@Nullable Object value, Object ... message) throws IllegalArgumentException {
        if (value != null) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void isEmpty(byte[] array, Object ... message) throws IllegalArgumentException {
        if (Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void isEmpty(@Nullable char[] array, Object ... message) throws IllegalArgumentException {
        if (Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void isEmpty(@Nullable Object[] values, Object ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void isEmpty(@Nullable Collection<?> values, Object ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> values, Object ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void isEmpty(@Nullable CharSequence value, Object ... message) throws IllegalArgumentException {
        if (Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }
}

