/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.ujorm.tools.Check;

@Immutable
public class MsgFormatter {
    protected static final String DEFAULT_MARK = "{}";
    protected static final String SEPARATOR = ", ";
    private final String mark;

    protected MsgFormatter() {
        this(DEFAULT_MARK);
    }

    protected MsgFormatter(@Nonnull String mark) {
        this.mark = mark;
    }

    @Nonnull
    public String formatMsg(@Nullable String messageTemplate, Object ... arguments) {
        String template;
        String string = template = messageTemplate != null ? messageTemplate : String.valueOf(messageTemplate);
        if (!Check.hasLength(arguments)) {
            return template;
        }
        int max = template.length();
        CharArrayWriter out = new CharArrayWriter(Math.max(32, max + (max >> 1)));
        int last = 0;
        for (Object arg : arguments) {
            int i = template.indexOf(this.mark, last);
            if (i >= last) {
                out.append(template, last, i);
                last = i + this.mark.length();
                this.writeValue(arg, out, true);
                continue;
            }
            if (last < max) {
                out.append(template, last, max);
                last = max;
            }
            this.writeValue(arg, out, false);
        }
        if (last < max) {
            out.append(template, last, max);
        }
        return out.toString();
    }

    @Nullable
    public String formatMsg(Object ... templateAndArguments) {
        if (Check.hasLength(templateAndArguments)) {
            String template = String.valueOf(templateAndArguments[0]);
            Object[] params = new Object[templateAndArguments.length - 1];
            System.arraycopy(templateAndArguments, 1, params, 0, params.length);
            return MsgFormatter.format(template, params);
        }
        return null;
    }

    protected void writeValue(@Nullable Object value, @Nonnull CharArrayWriter out, boolean marked) {
        Object val;
        Object object = val = value instanceof Supplier ? ((Supplier)value).get() : value;
        if (marked) {
            out.append(val != null ? val.toString() : String.valueOf(val));
        } else if (val instanceof Throwable) {
            out.append('\n');
            ((Throwable)val).printStackTrace(new PrintWriter((Writer)out, true));
        } else {
            out.append(SEPARATOR);
            out.append(String.valueOf(val));
        }
    }

    @Nonnull
    public static String format(@Nullable String messageTemplate, Object ... arguments) {
        return new MsgFormatter().formatMsg(messageTemplate, arguments);
    }

    @Nullable
    public static String format(Object ... templateAndArguments) {
        return new MsgFormatter().formatMsg(templateAndArguments);
    }
}

