/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import java.io.CharArrayWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.ValueFormatter;

public class SimpleValuePrinter
extends ValueFormatter {
    protected final CharArrayWriter out;

    public SimpleValuePrinter(int size) {
        this(new CharArrayWriter(size));
    }

    public SimpleValuePrinter(@Nonnull CharArrayWriter out) {
        this("?", "\"", out);
    }

    public SimpleValuePrinter(@Nonnull String mark, @Nonnull String textBorder, @Nonnull CharArrayWriter out) {
        super(mark, textBorder);
        this.out = out;
    }

    @Nonnull
    public SimpleValuePrinter appendValue(@Nullable Object value) {
        if (value instanceof Object[]) {
            boolean first = true;
            for (Object object : (Object[])value) {
                if (first) {
                    first = !first;
                } else {
                    this.out.append(", ");
                }
                this.appendValue(object);
            }
        } else {
            super.writeValue(value, this.out, true);
        }
        return this;
    }

    public CharArrayWriter getWriter() {
        return this.out;
    }

    @Nonnull
    public String toString() {
        return this.out.toString();
    }
}

