/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.dom;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.dom.Element;
import org.ujorm.tools.dom.XmlElement;

public class HtmlElement
extends XmlElement {
    public static final String HEADER = "<!DOCTYPE html>";
    @Nonnull
    private final Element head;
    @Nonnull
    private final Element body;
    @Nonnull
    protected final Charset charset;

    public HtmlElement(@Nonnull CharSequence title) {
        this(title, StandardCharsets.UTF_8);
    }

    public HtmlElement(@Nonnull CharSequence title, @Nonnull Charset charset) {
        super("html");
        this.charset = charset;
        this.head = this.addElement("head");
        this.head.addElement("meta").addAttrib("charset", charset);
        this.body = this.addElement("body");
        this.head.addElement("title").addText(title);
    }

    @Nonnull
    public <T extends Element> T getHead() {
        return (T)this.head;
    }

    @Nonnull
    public <T extends Element> T getBody() {
        return (T)this.body;
    }

    public <T extends Element> T addElementToHead(@Nonnull CharSequence name) {
        return this.head.addElement(name);
    }

    public <T extends Element> T addElementToBody(@Nonnull CharSequence name) {
        return this.body.addElement(name);
    }

    public <T extends Element> T addCssLink(String css) {
        return this.head.addElement("link").addAttrib("href", css).addAttrib("rel", "stylesheet").addAttrib("type", "text/css");
    }

    public <T extends Element> T addCssBody(@Nullable String css) {
        return this.head.addElement("style").addAttrib("type", "text/css").addRawText(css);
    }

    @Override
    @Nonnull
    public String toString() throws IllegalStateException {
        try {
            return this.toWriter(new CharArrayWriter(512).append(HEADER).append('\n')).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void toResponse(@Nonnull Object httpServletResponse, boolean noCache) throws IOException, IllegalArgumentException {
        try {
            Method setEncoding = httpServletResponse.getClass().getMethod("setCharacterEncoding", String.class);
            Method setHeader = httpServletResponse.getClass().getMethod("setHeader", String.class, String.class);
            Method getWriter = httpServletResponse.getClass().getMethod("getWriter", new Class[0]);
            setEncoding.invoke(httpServletResponse, this.charset.toString());
            setHeader.invoke(httpServletResponse, "Content-Type", "text/html; charset=" + this.charset);
            if (noCache) {
                setHeader.invoke(httpServletResponse, "Cache-Control", "no-cache, no-store, must-revalidate");
                setHeader.invoke(httpServletResponse, "Pragma", "no-cache");
                setHeader.invoke(httpServletResponse, "Expires", "0");
            }
            Writer writer = (Writer)getWriter.invoke(httpServletResponse, new Object[0]);
            this.toWriter(writer.append(HEADER).append('\n'));
            writer.flush();
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Response must be type of HttpServletResponse", e);
        }
    }

    public static interface Html {
        public static final String HTML = "html";
        public static final String HEAD = "head";
        public static final String META = "meta";
        public static final String BODY = "body";
        public static final String TITLE = "title";
        public static final String LINK = "link";
        public static final String STYLE = "style";
        public static final String A_CHARSET = "charset";
        public static final String A_CONTENT = "content";
        public static final String A_HREF = "href";
        public static final String A_REL = "rel";
        public static final String A_TYPE = "type";
    }
}

